/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;

public class DmcUncheckedOIFParser {
    DmcUncheckedOIFHandlerIF handler;
    int allowedErrorsV;
    ResultException exG;
    HashMap<String, String> preserveNL;
    boolean dropLineContinuation;

    public DmcUncheckedOIFParser(DmcUncheckedOIFHandlerIF objHandler) {
        this.handler = objHandler;
        this.allowedErrorsV = 0;
        this.exG = null;
        this.preserveNL = new HashMap();
    }

    public void addPreserveNewlinesAttribute(String an) {
        this.preserveNL.put(an, an);
    }

    public void dropLineContinuations() {
        this.dropLineContinuation = true;
    }

    public void allowedErrors(int i) {
        this.allowedErrorsV = i;
    }

    public void parseFile(String fileName) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.parseFile(fileName, false);
    }

    public void parseFile(String fileName, boolean isResource) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        boolean inObject = false;
        String attrName = null;
        DmcUncheckedObject uco = null;
        StringBuffer attrVal = new StringBuffer();
        String val = null;
        String fn = fileName.replace('\\', '/');
        int lastLine = 0;
        LineNumberReader in = null;
        this.exG = null;
        try {
            String str;
            if (isResource) {
                InputStreamReader isr = null;
                try {
                    isr = new InputStreamReader(this.getClass().getResourceAsStream(fn));
                }
                catch (Exception e) {
                    ResultException ex = new ResultException("Tried to open this file as a resource from a JAR, but failed: " + fn);
                    ex.moreMessages("This may be because you're using ConfigFinder but not passing in the name of the resource based on the JAR");
                    throw ex;
                }
                in = new LineNumberReader(isr);
            } else {
                in = new LineNumberReader(new FileReader(fileName));
            }
            while ((str = in.readLine()) != null) {
                if (!str.startsWith("*") && !str.startsWith("//")) {
                    StringTokenizer t = new StringTokenizer(str);
                    if (t.countTokens() != 0) {
                        if (!inObject) {
                            ArrayList<String> al = new ArrayList<String>();
                            while (t.hasMoreTokens()) {
                                al.add(t.nextToken().trim());
                            }
                            uco = new DmcUncheckedObject(al, in.getLineNumber());
                            inObject = true;
                            attrName = null;
                        } else if (Character.isWhitespace(str.charAt(0))) {
                            if (this.preserveNL.get(attrName) != null) {
                                if (this.dropLineContinuation) {
                                    attrVal.append("\n" + str.substring(1));
                                } else {
                                    attrVal.append("\n" + str);
                                }
                            } else if (this.dropLineContinuation) {
                                attrVal.append(str.substring(1));
                            } else {
                                attrVal.append(str);
                            }
                        } else {
                            if (attrName != null) {
                                val = attrVal.toString().trim();
                                if (this.preserveNL.get(attrName) != null) {
                                    val = val.replaceAll("\n", "\\\\n");
                                }
                                uco.addValue(attrName, new String(val));
                            }
                            attrName = t.nextToken().trim();
                            attrVal.delete(0, attrVal.length());
                            attrVal.append(str);
                            attrVal.delete(0, attrName.length());
                            if (attrVal.length() == 0) {
                                ResultException ex = new ResultException();
                                ex.addError("No value for attribute: " + attrName);
                                ex.setLocationInfo(fileName, in.getLineNumber());
                                throw ex;
                            }
                            while (attrVal.charAt(0) == ' ') {
                                attrVal.delete(0, 1);
                            }
                        }
                    } else if (uco != null) {
                        block45: {
                            inObject = false;
                            if (attrName != null) {
                                val = attrVal.toString().trim();
                                if (this.preserveNL.get(attrName) != null) {
                                    val = val.replaceAll("\n", "\\\\n");
                                }
                                uco.addValue(attrName, new String(val));
                            }
                            try {
                                this.handler.handleObject(uco, fn, uco.lineNumber);
                            }
                            catch (ResultException ex) {
                                if (this.exG == null) {
                                    this.exG = ex;
                                } else {
                                    this.exG.result.addResults(ex.result);
                                }
                                if (this.exG.result.worst() == 4) {
                                    uco = null;
                                    break;
                                }
                                if (this.allowedErrorsV == -1) break block45;
                                if (this.allowedErrorsV == 0 && this.exG.result.errors() > 0) {
                                    uco = null;
                                    break;
                                }
                                if (this.exG.result.errors() < this.allowedErrorsV) break block45;
                                uco = null;
                                break;
                            }
                        }
                        uco = null;
                    }
                }
                lastLine = in.getLineNumber();
            }
            in.close();
        }
        catch (IOException e) {
            if (this.exG == null) {
                this.exG = new ResultException();
            }
            this.exG.result.addResult(4, e.toString());
            this.exG.result.lastResult().moreMessages("Occurred while reading file: " + fileName);
            uco = null;
        }
        catch (Exception e) {
            if (this.exG == null) {
                this.exG = new ResultException();
            }
            this.exG.result.addResult(4, e.toString());
            this.exG.result.lastResult().moreMessages("Occurred while reading file: " + fileName + " at line: " + in.getLineNumber());
            this.exG.result.lastResult().moreMessages(DebugInfo.extractTheStack(e));
            uco = null;
        }
        if (uco != null) {
            if (attrName != null) {
                val = new String(attrVal);
                if (this.preserveNL.get(attrName) != null) {
                    val = val.replaceAll("\n", "\\\\n");
                }
                uco.addValue(attrName, val.trim());
            }
            try {
                this.handler.handleObject(uco, fn, uco.lineNumber);
            }
            catch (ResultException ex) {
                if (ex == this.exG) {
                    throw this.exG;
                }
                if (this.exG == null) {
                    this.exG = ex;
                }
                this.exG.result.addResults(ex.result);
            }
        }
        if (this.exG != null) {
            throw this.exG;
        }
    }
}

