/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import org.dmd.dmc.types.IntegerVar;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.exceptions.ResultSet;

public class JSONParser {
    ResultSet rsG = new ResultSet();

    public DmcUncheckedObject parse(String input) throws ResultException {
        return this.parseObject(input);
    }

    /*
     * Enabled aggressive block sorting
     */
    DmcUncheckedObject parseObject(String in) throws ResultException {
        IntegerVar index = new IntegerVar(0);
        boolean wantStartCurly = true;
        boolean wantEndCurly = false;
        String input = in.trim();
        DmcUncheckedObject basic = new DmcUncheckedObject();
        this.rsG.reset();
        while (index.intValue() < input.length()) {
            if (wantStartCurly) {
                if (input.charAt(index.intValue()) != '{') {
                    ResultException ex = new ResultException();
                    ex.addError("Expecting opening bracket for object.");
                    throw ex;
                }
                wantStartCurly = false;
                index.set(index.intValue() + 1);
                this.parseObject(input, index, basic);
                wantEndCurly = true;
            } else if (wantEndCurly) {
                this.eatWhiteSpace(input, index, "end bracket for object");
                if (input.charAt(index.intValue()) != '}') {
                    ResultException ex = new ResultException();
                    ex.addError("Expecting closing bracket for object.");
                    throw ex;
                }
                if (input.length() - 1 != index.intValue()) {
                    ResultException ex = new ResultException();
                    ex.addError("Extraneous characters after object.");
                    throw ex;
                }
                wantEndCurly = false;
            }
            index.set(index.intValue() + 1);
        }
        if (wantEndCurly) {
            ResultException ex = new ResultException();
            ex.addError("Closing bracket missing.");
            throw ex;
        }
        return basic;
    }

    void parseObject(String input, IntegerVar index, DmcUncheckedObject basic) throws ResultException {
        this.parseAttributes(input, index, basic);
    }

    void parseAttributes(String input, IntegerVar index, DmcUncheckedObject basic) throws ResultException {
        while (index.intValue() < input.length()) {
            if (this.parseAttribute(input, index, basic)) {
                if (input.charAt(index.intValue()) == '}') {
                    index.set(index.intValue() - 1);
                    break;
                }
                ResultException ex = new ResultException();
                ex.addError("Expecting closing bracket for object.");
                throw ex;
            }
            index.set(index.intValue() + 1);
        }
    }

    boolean parseAttribute(String input, IntegerVar index, DmcUncheckedObject basic) throws ResultException {
        boolean rc = true;
        String attrName = this.getColonTerminatedChunk(input, index, "attribute name");
        if (this.isMultiValued(input, index)) {
            this.parseMVAttribute(input, index, basic, attrName);
        } else {
            this.parseSVAttribute(input, index, basic, attrName);
        }
        this.eatWhiteSpace(input, index, "value separating comma");
        if (input.charAt(index.intValue()) == ',') {
            rc = false;
        }
        return rc;
    }

    boolean isMultiValued(String input, IntegerVar index) {
        boolean rc = false;
        for (int i = index.intValue(); i < input.length(); ++i) {
            if (Character.isWhitespace(input.charAt(i))) continue;
            if (input.charAt(i) != '[') break;
            rc = true;
            break;
        }
        return rc;
    }

    void parseSVAttribute(String input, IntegerVar index, DmcUncheckedObject basic, String attrName) throws ResultException {
        String value = this.getQuotedValue(input, index, "value for attribute: " + attrName);
        basic.addValue(attrName, value);
    }

    void parseMVAttribute(String input, IntegerVar index, DmcUncheckedObject basic, String attrName) throws ResultException {
        String value = null;
        boolean wantOpenBracket = true;
        while (index.intValue() < input.length()) {
            if (wantOpenBracket) {
                this.eatWhiteSpace(input, index, "open square bracket for array");
                if (input.charAt(index.intValue()) == '[') {
                    wantOpenBracket = false;
                }
            } else {
                value = this.getQuotedValue(input, index, "value for attribute: " + attrName);
                if (attrName.equals("objectClass")) {
                    basic.addToClasses(value);
                } else {
                    basic.addValue(attrName, value);
                }
                this.eatWhiteSpace(input, index, "comma or end of array");
                if (input.charAt(index.intValue()) == ']') {
                    index.set(index.intValue() + 1);
                    break;
                }
                if (input.charAt(index.intValue()) != ',') {
                    ResultException ex = new ResultException();
                    ex.addError("Malformed array - value followed by unrecognized character: " + input.charAt(index.intValue()));
                    throw ex;
                }
            }
            index.set(index.intValue() + 1);
        }
    }

    void eatWhiteSpace(String input, IntegerVar index, String message) throws ResultException {
        while (index.intValue() < input.length() && Character.isWhitespace(input.charAt(index.intValue()))) {
            index.set(index.intValue() + 1);
        }
        if (index.intValue() == input.length()) {
            ResultException ex = new ResultException();
            ex.addError("Ran out of characters while expecting to find: " + message);
            throw ex;
        }
    }

    String getColonTerminatedChunk(String input, IntegerVar index, String message) throws ResultException {
        String rc = null;
        int quote1 = -1;
        int quote2 = -1;
        int colon = -1;
        try {
            quote1 = this.indexOf(input, "\"", index.intValue(), "Expecting open quote: ");
            quote2 = this.indexOf(input, "\"", quote1 + 1, "Expecting close quote: ");
            colon = this.indexOf(input, ":", quote2 + 1, "Expecting colon after: ");
        }
        catch (ResultException ex) {
            ex.result.lastResult().moreMessages("While trying to parse " + message);
            throw ex;
        }
        rc = input.substring(quote1 + 1, quote2);
        if (rc.length() == 0) {
            ex = new ResultException();
            ex.addError("Empty string while trying to parse " + message + " at index: " + index.intValue() + " in input string: " + input);
            throw ex;
        }
        index.set(colon + 1);
        return rc;
    }

    String getQuotedValue(String input, IntegerVar index, String message) throws ResultException {
        String rc = null;
        int quote1 = -1;
        int quote2 = -1;
        try {
            quote1 = this.indexOf(input, "\"", index.intValue(), "Expecting open quote: ");
            quote2 = this.indexOf(input, "\"", quote1 + 1, "Expecting close quote: ");
        }
        catch (ResultException ex) {
            ex.result.lastResult().moreMessages("While trying to parse " + message);
            throw ex;
        }
        rc = input.substring(quote1 + 1, quote2);
        if (rc.length() == 0) {
            ex = new ResultException();
            ex.addError("Empty string while trying to parse " + message + " at index: " + index.intValue() + " in input string: " + input);
            throw ex;
        }
        index.set(quote2 + 1);
        return rc;
    }

    private int indexOf(String instr, String substr, int after, String message) throws ResultException {
        if (after >= instr.length()) {
            ResultException ex = new ResultException();
            ex.addError("Ran out of input while trying to find: " + substr + "  at offset: " + after + "  in input string: " + instr);
            throw ex;
        }
        int rc = instr.indexOf(substr, after);
        if (rc == -1) {
            ResultException ex = new ResultException();
            ex.addError(message + instr);
            throw ex;
        }
        return rc;
    }
}

