/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import org.dmd.dmc.types.IntegerVar;
import org.dmd.util.BooleanVar;
import org.dmd.util.parsing.IntegerArrayList;
import org.dmd.util.parsing.OptionType;
import org.dmd.util.parsing.StringArrayList;

public class OptionDef {
    public final int STROPT = 1;
    public final int STRARROPT = 2;
    public final int INTOPT = 3;
    public final int INTARROPT = 4;
    public final int FLAGOPT = 5;
    public String optionName;
    public Object option;
    public String optionHelp;
    private OptionType optionType;
    private boolean optionFound;

    public OptionDef(String name, BooleanVar var, String helpText) {
        this.init(name, var, helpText);
        this.optionType = OptionType.FLAG;
    }

    public OptionDef(String name, IntegerVar var, String helpText) {
        this.init(name, var, helpText);
        this.optionType = OptionType.INTEGER;
    }

    public OptionDef(String name, StringBuffer var, String helpText) {
        this.init(name, var, helpText);
        this.optionType = OptionType.STRING;
    }

    public OptionDef(String name, IntegerArrayList var, String helpText) {
        this.init(name, var, helpText);
        this.optionType = OptionType.INTEGERARRAY;
    }

    public OptionDef(String name, StringArrayList var, String helpText) {
        this.init(name, var, helpText);
        this.optionType = OptionType.STRINGARRAY;
    }

    void init(String name, Object var, String helpText) {
        this.optionName = new String(name);
        this.option = var;
        this.optionFound = false;
        this.optionHelp = new String(helpText);
    }

    public void exists() {
        this.optionFound = true;
        if (this.optionType == OptionType.FLAG) {
            BooleanVar b = (BooleanVar)this.option;
            b.set(true);
        }
    }

    public boolean found() {
        return this.optionFound;
    }

    public void add(String str) {
        switch (this.optionType) {
            case FLAG: {
                break;
            }
            case INTEGER: {
                IntegerVar i = (IntegerVar)this.option;
                i.set(str);
                break;
            }
            case STRING: {
                StringBuffer s = (StringBuffer)this.option;
                if (s.length() != 0) {
                    s.delete(0, s.length());
                }
                s.append(str);
                break;
            }
            case INTEGERARRAY: {
                IntegerArrayList ial = (IntegerArrayList)this.option;
                ial.add(Integer.valueOf(str));
                break;
            }
            case STRINGARRAY: {
                StringArrayList sal = (StringArrayList)this.option;
                sal.add(new String(str));
            }
        }
    }
}

