/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.util.TreeSet;

public class Part {
    TypeE type;
    char value = '\u0000';
    boolean alphaNum = false;
    boolean upper = false;
    boolean lower = false;
    TreeSet<String> allValues = new TreeSet();
    int length = 1;

    public Part(char c, boolean collapseAlphaNumeric) {
        this.value = c;
        this.allValues.add(new String(c + ""));
        if (Character.isAlphabetic(c)) {
            this.type = TypeE.ALPHA;
            if (Character.isUpperCase(c)) {
                this.upper = true;
            } else {
                this.lower = true;
            }
            if (collapseAlphaNumeric) {
                this.alphaNum = true;
            }
        } else if (Character.isDigit(c)) {
            this.type = TypeE.DIGIT;
            if (collapseAlphaNumeric) {
                this.alphaNum = true;
            }
        } else {
            this.type = c == ' ' ? TypeE.SPACE : (c == '\t' ? TypeE.TAB : TypeE.OTHER);
        }
    }

    public boolean consume(Part p) {
        boolean rc = false;
        if (p.type == this.type) {
            rc = true;
        } else if (this.alphaNum && p.alphaNum) {
            rc = true;
        }
        if (rc) {
            if (this.type == TypeE.OTHER) {
                if (this.value == p.value) {
                    ++this.length;
                } else {
                    rc = false;
                }
            } else {
                ++this.length;
                this.allValues.add(new String(p + ""));
                if (p.upper) {
                    this.upper = true;
                }
                if (p.lower) {
                    this.lower = true;
                }
            }
        }
        return rc;
    }

    public boolean matches(Part p, boolean strict) {
        if (strict && this.length != p.length) {
            return false;
        }
        if (this.alphaNum && p.alphaNum) {
            return true;
        }
        if (this.type == p.type) {
            if (this.type == TypeE.OTHER) {
                if (this.value == p.value) {
                    return this.length == p.length;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString(boolean strict) {
        StringBuffer sb = new StringBuffer();
        String lengthInfo = "*";
        if (strict) {
            lengthInfo = this.length + "";
        }
        if (this.alphaNum) {
            sb.append("ALPHANUM (" + lengthInfo + ")  ");
        } else if (this.type == TypeE.ALPHA) {
            sb.append("ALPHA (" + lengthInfo + ")  ");
        } else if (this.type == TypeE.DIGIT) {
            sb.append("DIGIT (" + lengthInfo + ")  ");
        } else if (this.type == TypeE.SPACE) {
            sb.append("SPACE (" + lengthInfo + ")  ");
        } else if (this.type == TypeE.TAB) {
            sb.append("TAB (" + lengthInfo + ")  ");
        } else {
            sb.append(this.value + " (" + this.length + ")  ");
        }
        return sb.toString();
    }

    private static enum TypeE {
        OTHER,
        DIGIT,
        SPACE,
        TAB,
        ALPHA;

    }
}

