/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.util.formatting.PrintfFormat;
import org.dmd.util.parsing.Part;

public class Pattern {
    private static final PrintfFormat occurFormat = new PrintfFormat("%-7d");
    private static int nextId = 1;
    private String example;
    private ArrayList<Part> parts;
    private int count = 1;
    private boolean strict;
    private String id;

    public Pattern(String ex, ArrayList<Part> p, boolean strict) {
        this.example = ex;
        this.parts = p;
        this.strict = strict;
        this.id = "" + nextId;
        ++nextId;
    }

    public String id() {
        return this.id;
    }

    public String example() {
        return this.example;
    }

    public Iterator<Part> getParts() {
        return this.parts.iterator();
    }

    public int count() {
        return this.count;
    }

    public int getPartCount() {
        return this.parts.size();
    }

    public boolean strict() {
        return this.strict;
    }

    public boolean matches(Pattern p) {
        boolean rc = true;
        if (this.parts.size() != p.parts.size()) {
            rc = false;
        } else {
            for (int i = 0; i < this.parts.size(); ++i) {
                if (this.parts.get(i).matches(p.parts.get(i), this.strict)) continue;
                rc = false;
                break;
            }
        }
        if (rc) {
            ++this.count;
        }
        return rc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Example: " + this.example + "     Ocurred: " + occurFormat.sprintf(this.count) + "  ");
        for (Part p : this.parts) {
            sb.append(p.toString(this.strict));
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString(PrintfFormat exampleFormat) {
        StringBuffer sb = new StringBuffer();
        sb.append("Example: " + exampleFormat.sprintf(this.example) + "     Ocurred: " + occurFormat.sprintf(this.count) + "  ");
        for (Part p : this.parts) {
            sb.append(p.toString(this.strict));
        }
        sb.append("\n");
        return sb.toString();
    }
}

