/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.util.ArrayList;
import org.dmd.util.formatting.PrintfFormat;
import org.dmd.util.parsing.Part;
import org.dmd.util.parsing.Pattern;

public class PatternDiscriminator {
    ArrayList<Pattern> patterns;
    int longestExample = 0;
    int limit;
    boolean collapseAlphaNumeric;
    boolean strict;

    public PatternDiscriminator(int limit, boolean collapseAlphaNumeric, boolean strict) {
        this.limit = limit;
        this.collapseAlphaNumeric = collapseAlphaNumeric;
        this.strict = strict;
        this.patterns = new ArrayList();
    }

    public Pattern analyze(String input) {
        Pattern newPattern;
        Pattern rc = null;
        if (this.patterns.size() == this.limit) {
            return null;
        }
        ArrayList<Part> baseParts = new ArrayList<Part>();
        String value = input.trim();
        for (int i = 0; i < value.length(); ++i) {
            baseParts.add(new Part(value.charAt(i), this.collapseAlphaNumeric));
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        Part currPart = (Part)baseParts.get(0);
        parts.add(currPart);
        for (int i = 1; i < baseParts.size(); ++i) {
            if (currPart.consume((Part)baseParts.get(i))) continue;
            currPart = (Part)baseParts.get(i);
            parts.add(currPart);
        }
        rc = newPattern = new Pattern(value, parts, this.strict);
        boolean foundMatch = false;
        for (Pattern p : this.patterns) {
            if (!p.matches(newPattern)) continue;
            foundMatch = true;
            rc = p;
            break;
        }
        if (!foundMatch && this.patterns.size() < this.limit) {
            this.patterns.add(newPattern);
            if (newPattern.example().length() > this.longestExample) {
                this.longestExample = newPattern.example().length();
            }
        }
        return rc;
    }

    public ArrayList<Pattern> getPatterns() {
        return this.patterns;
    }

    public ArrayList<String> getFormattedPatterns() {
        ArrayList<String> rc = new ArrayList<String>();
        PrintfFormat format = new PrintfFormat("%" + this.longestExample + "s");
        for (Pattern p : this.patterns) {
            rc.add(p.toString(format));
        }
        return rc;
    }
}

