//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2012 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.dmp.server.servlet.generated.types;

import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.types.DmcTypeNamedObjectREF;
import org.dmd.dmc.types.DotName;

import org.dmd.dmp.server.servlet.generated.types.SessionRIREF;

import org.dmd.dmp.server.servlet.generated.dmo.SessionRIDMO;

/**
 * This is the generated DmcAttribute derivative for values of type SessionRI
 * <P>
 * Generated from the dmpServer schema at version unknown
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoTypeFormatter.dumpNamedREFHelperType(DmoTypeFormatter.java:583)
 */
@SuppressWarnings("serial")
abstract public class DmcTypeSessionRIREF extends DmcTypeNamedObjectREF<SessionRIREF, DotName> {

    public DmcTypeSessionRIREF(){
    
    }

    public DmcTypeSessionRIREF(DmcAttributeInfo ai){
        super(ai);
    }

    @Override
    protected SessionRIREF getNewHelper(){
        return(new SessionRIREF());
    }

    @Override
    protected DotName getNewName(){
        return(new DotName());
    }

    @Override
    protected String getDMOClassName(){
        return( SessionRIDMO.class.getName());
    }

    @Override
    protected boolean isDMO(Object value){
        if (value instanceof SessionRIDMO)
            return(true);
        return(false);
    }

    @Override
    protected SessionRIREF typeCheck(Object value) throws DmcValueException {
        SessionRIREF rc = null;

        if (value instanceof SessionRIREF)
            rc = (SessionRIREF)value;
        else if (value instanceof SessionRIDMO)
            rc = new SessionRIREF((SessionRIDMO)value);
        else if (value instanceof DotName)
            rc = new SessionRIREF((DotName)value);
        else if (value instanceof String)
            rc = new SessionRIREF((String)value);
        else
            throw(new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with SessionRIREF, SessionRIDMO or String expected."));

        return(rc);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, SessionRIREF value) throws Exception {
        value.serializeIt(dos);
    }

    @Override
    public SessionRIREF deserializeValue(DmcInputStreamIF dis) throws Exception {
        SessionRIREF rc = new SessionRIREF();
        rc.deserializeIt(dis);
        return(rc);
    }

    @Override
    public SessionRIREF cloneValue(SessionRIREF value){
        return(new SessionRIREF(value));
    }



}
