//	---------------------------------------------------------------------------
//	dark-matter-mvw
//	Copyright (c) 2012 dark-matter-mvw committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.mvw.client.mvw;

import org.dmd.mvw.client.mvw.generated.mvw.MvwRunContextIF;

import com.google.gwt.activity.shared.Activity;
import com.google.gwt.place.shared.Place;

/**
 * The MvwPlace extends the base Place and provides a useful interface for code that's
 * generated by the Model View Whatever framework. For instance, it indicates that any
 * given Place knows the Activity that runs in it; this is part of the specification
 * of a Place in MVW.
 */
abstract public class MvwPlace extends Place {
	
	// This is the token that's passed in when the place is created
	private String token;
	
	protected MvwPlace(String t){
		token = t;
	}
	
	public String getToken(){
		return(token);
	}

	/**
	 * Derived generated code will instantiate the Activity that's specified
	 * in the runsActivity attribute of the Place definition.
	 * @return The appropriate Activity for this place.
	 */
	public abstract Activity getActivity(MvwRunContextIF runContext);
}
