//	---------------------------------------------------------------------------
//	dark-matter-data
//	Copyright (c) 2018 dark-matter-data committers
//	---------------------------------------------------------------------------
//	This program is free software; you can redistribute it and/or modify it
//	under the terms of the GNU Lesser General Public License as published by the
//	Free Software Foundation; either version 3 of the License, or (at your
//	option) any later version.
//	This program is distributed in the hope that it will be useful, but WITHOUT
//	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
//	FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for
//	more details.
//	You should have received a copy of the GNU Lesser General Public License along
//	with this program; if not, see <http://www.gnu.org/licenses/lgpl.html>.
//	---------------------------------------------------------------------------
package org.dmd.mvw.tools.mvwgenerator.generated.dmo;

// Generated from: org.dmd.dms.util.GenUtility.formatImports(GenUtility.java:408)
import java.io.Serializable;                                                                    // Always required - (GenUtility.java:227)
import java.util.*;                                                                             // Always required if we have any MV attributes - (GenUtility.java:224)
import org.dmd.dmc.DmcAttribute;                                                                // Named object - (GenUtility.java:388)
import org.dmd.dmc.DmcNamedObjectIF;                                                            // Named object - (GenUtility.java:387)
import org.dmd.dmc.DmcOmni;                                                                     // Lazy resolution - (GenUtility.java:331)
import org.dmd.dmc.DmcSliceInfo;                                                                // Required for object slicing - (GenUtility.java:232)
import org.dmd.dmc.DmcValueException;                                                           // Any attributes - (GenUtility.java:249)
import org.dmd.dmc.types.CamelCaseName;                                                         // Naming attribute type - (GenUtility.java:382)
import org.dmd.dms.generated.dmo.MetaDMSAG;                                                     // Required for MODREC constructor - (GenUtility.java:231)
import org.dmd.dms.generated.types.DmcTypeBooleanSV;                                            // Required type - (GenUtility.java:339)
import org.dmd.dms.generated.types.DmcTypeCamelCaseNameSV;                                      // Required type - (GenUtility.java:339)
import org.dmd.dms.generated.types.DmcTypeModifierMV;                                           // Required for MODREC constructor - (GenUtility.java:230)
import org.dmd.dms.generated.types.DmcTypeStringSET;                                            // Required type - (GenUtility.java:339)
import org.dmd.dms.generated.types.DmcTypeStringSV;                                             // Required type - (GenUtility.java:339)
import org.dmd.mvw.tools.mvwgenerator.generated.dmo.EnumMappingGeneratorDMO;                    // Type specific set/add - (GenUtility.java:318)
import org.dmd.mvw.tools.mvwgenerator.generated.dmo.MvwDefinitionDMO;                           // Base class - (GenUtility.java:367)
import org.dmd.mvw.tools.mvwgenerator.generated.types.DmcTypeEnumMappingGeneratorREFSV;         // Reference type - (GenUtility.java:311)
import org.dmd.mvw.tools.mvwgenerator.generated.types.EnumMappingGeneratorREF;                  // Helper class - (GenUtility.java:346)

// Generated from: org.dmd.dms.util.DmoFormatter.getClassHeader(DmoFormatter.java:678)
/**
 * The EnumMapping class allows for generation of a set of static data
 * instances\n that represent the values from the specified enumeration
 * (type). Depending on the widget set\n you're using, you will specify
 * different mappingGenerators; these are defined as extensions\n to the
 * standard MVW generation mechanisms. For example, the dark-matter-gxt
 * project defines\n the GXTEnumGenerator generator that will generate code
 * that maps an enum to code that can be used with\n a selector widget.\n <p
 * />\n Enum values are comprised of an integer, a name, a description and
 * optionally, a label as follows - int name description : label.\n If you
 * specify useNameAsLabel, the uppercase name value of the enum is used to
 * display the value\n of the. If useNameAsLabel is not specified, the label
 * will be used if it has been specified. Otherwise,\n the description is
 * used.
 * <P>
 * Generated from the mvw schema at version 0.1
 * <P>
 * This code was auto-generated by the dmogenerator utility and shouldn't be alterred manually!
 * Generated from: org.dmd.dms.util.DmoFormatter.dumpDMO(DmoFormatter.java:134)
 */
@SuppressWarnings("serial")
public class EnumMappingDMO  extends MvwDefinitionDMO  implements DmcNamedObjectIF, Serializable  {

    public final static String constructionClassName = "EnumMapping";


    static {
    }

    public EnumMappingDMO() {
        super("EnumMapping");
    }

    protected EnumMappingDMO(String oc) {
        super(oc);
    }

    @Override
    public EnumMappingDMO getNew(){
        EnumMappingDMO rc = new EnumMappingDMO();
        return(rc);
    }

    @Override
    public EnumMappingDMO getSlice(DmcSliceInfo info){
        EnumMappingDMO rc = new EnumMappingDMO();
        populateSlice(rc,info);
        return(rc);
    }

    public EnumMappingDMO(DmcTypeModifierMV mods) {
        super("EnumMapping");
        modrec(true);
        setModifier(mods);
    }

    public EnumMappingDMO getModificationRecorder(){
        EnumMappingDMO rc = new EnumMappingDMO();
        rc.setMappingName(getMappingName());
        rc.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));
        rc.modrec(true);
        return(rc);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:752)
    public CamelCaseName getObjectName(){
        DmcAttribute<?> name = get(MvwDMSAG.__mappingName);
        if (name != null)
            return((CamelCaseName)name.getSV());
    
        return(null);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:769)
    public DmcAttribute<?> getObjectNameAttribute(){
        DmcAttribute<?> name = get(MvwDMSAG.__mappingName);
        return(name);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:776)
    public boolean equals(Object obj){
        if (obj instanceof EnumMappingDMO){
            return( getObjectName().equals( ((EnumMappingDMO) obj).getObjectName()) );
        }
        return(false);
    }

    // org.dmd.dms.util.DmoFormatter.getAccessFunctions(DmoFormatter.java:784)
    public int hashCode(){
        CamelCaseName objn = getObjectName();
        if (objn == null)
            return(0);
        
        return(objn.hashCode());
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:789)
    public Boolean isUseNameAsLabel(){
        DmcTypeBooleanSV attr = (DmcTypeBooleanSV) get(MvwDMSAG.__useNameAsLabel);
        if (attr == null)
            return(false);

        return(attr.getSV());
    }

    /**
     * Sets useNameAsLabel to the specified value.
     * @param value Boolean
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:829)
    public void setUseNameAsLabel(Boolean value) {
        DmcAttribute<?> attr = get(MvwDMSAG.__useNameAsLabel);
        if (attr == null)
            attr = new DmcTypeBooleanSV(MvwDMSAG.__useNameAsLabel);
        
        try{
            attr.set(value);
            set(MvwDMSAG.__useNameAsLabel,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets useNameAsLabel to the specified value.
     * @param value A value compatible with DmcTypeBooleanSV
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:882)
    public void setUseNameAsLabel(Object value) throws DmcValueException {
        DmcTypeBooleanSV attr  = (DmcTypeBooleanSV) get(MvwDMSAG.__useNameAsLabel);
        if (attr == null)
            attr = new DmcTypeBooleanSV(MvwDMSAG.__useNameAsLabel);
        
        attr.set(value);
        set(MvwDMSAG.__useNameAsLabel,attr);
    }

    /**
     * Removes the useNameAsLabel attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:902)
    public void remUseNameAsLabel(){
         rem(MvwDMSAG.__useNameAsLabel);
    }

    /**
     * @return An Iterator of String objects.
     */
    @SuppressWarnings("unchecked")
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1278)
    public Iterator<String> getSkipEnumValue(){
        DmcTypeStringSET attr = (DmcTypeStringSET) get(MvwDMSAG.__skipEnumValue);
        if (attr == null)
            return( ((List<String>) Collections.EMPTY_LIST).iterator());

        return(attr.getMV());
    }

    /**
     * @return The nth String value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1290)
    public String getNthSkipEnumValue(int i){
        DmcTypeStringSET attr = (DmcTypeStringSET) get(MvwDMSAG.__skipEnumValue);
        if (attr == null)
            return(null);

        return(attr.getMVnth(i));
    }

    /**
     * Adds another skipEnumValue to the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1304)
    public DmcAttribute<?> addSkipEnumValue(String value) {
        DmcAttribute<?> attr = get(MvwDMSAG.__skipEnumValue);
        if (attr == null)
            attr = new DmcTypeStringSET(MvwDMSAG.__skipEnumValue);
        
        try{
            setLastValue(attr.add(value));
            add(MvwDMSAG.__skipEnumValue,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific add() method shouldn't throw exceptions!",ex));
        }
        return(attr);
    }

    /**
     * Returns true if we contain a valued keyed by the specified String.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1379)
    public boolean skipEnumValueContains(String value) {
        DmcAttribute<?> attr = get(MvwDMSAG.__skipEnumValue);
        if (attr == null)
            return(false);
        return(attr.contains(value));
    }

    /**
     * Adds another skipEnumValue value.
     * @param value A value compatible with String
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1411)
    public DmcAttribute<?> addSkipEnumValue(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(MvwDMSAG.__skipEnumValue);
        if (attr == null)
            attr = new DmcTypeStringSET(MvwDMSAG.__skipEnumValue);
        
        setLastValue(attr.add(value));
        add(MvwDMSAG.__skipEnumValue,attr);
        return(attr);
    }

    /**
     * Returns the number of values in skipEnumValue
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1428)
    public int getSkipEnumValueSize(){
        DmcAttribute<?> attr = get(MvwDMSAG.__skipEnumValue);
        if (attr == null){
            if (MvwDMSAG.__skipEnumValue.indexSize == 0)
                return(0);
            else
                return(MvwDMSAG.__skipEnumValue.indexSize);
        }
        return(attr.getMVSize());
    }

    /**
     * Deletes a skipEnumValue value.
     * @param value The String to be deleted from set of attribute values.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1486)
    public DmcAttribute<?> delSkipEnumValue(Object value) throws DmcValueException {
        DmcAttribute<?> attr = get(MvwDMSAG.__skipEnumValue);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeStringSET(MvwDMSAG.__skipEnumValue), value);
        else
            attr = del(MvwDMSAG.__skipEnumValue, value);
        
        return(attr);
    }

    /**
     * Deletes a skipEnumValue from the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1502)
    public DmcAttribute<?> delSkipEnumValue(String value) {
        DmcAttribute<?> attr = get(MvwDMSAG.__skipEnumValue);
        
        if ( (attr == null) && (getModifier()!= null))
            delFromEmptyAttribute(new DmcTypeStringSET(MvwDMSAG.__skipEnumValue), value);
        else
            attr = del(MvwDMSAG.__skipEnumValue, value);
        
        return(attr);
    }

    /**
     * Removes the skipEnumValue attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatMV(GenUtility.java:1521)
    public void remSkipEnumValue(){
         rem(MvwDMSAG.__skipEnumValue);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:789)
    public String getEmptyText(){
        DmcTypeStringSV attr = (DmcTypeStringSV) get(MvwDMSAG.__emptyText);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets emptyText to the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:829)
    public void setEmptyText(String value) {
        DmcAttribute<?> attr = get(MvwDMSAG.__emptyText);
        if (attr == null)
            attr = new DmcTypeStringSV(MvwDMSAG.__emptyText);
        
        try{
            attr.set(value);
            set(MvwDMSAG.__emptyText,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets emptyText to the specified value.
     * @param value A value compatible with DmcTypeStringSV
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:882)
    public void setEmptyText(Object value) throws DmcValueException {
        DmcTypeStringSV attr  = (DmcTypeStringSV) get(MvwDMSAG.__emptyText);
        if (attr == null)
            attr = new DmcTypeStringSV(MvwDMSAG.__emptyText);
        
        attr.set(value);
        set(MvwDMSAG.__emptyText,attr);
    }

    /**
     * Removes the emptyText attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:902)
    public void remEmptyText(){
         rem(MvwDMSAG.__emptyText);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:789)
    public CamelCaseName getMappingName(){
        DmcTypeCamelCaseNameSV attr = (DmcTypeCamelCaseNameSV) get(MvwDMSAG.__mappingName);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets mappingName to the specified value.
     * @param value CamelCaseName
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:829)
    public void setMappingName(CamelCaseName value) {
        DmcAttribute<?> attr = get(MvwDMSAG.__mappingName);
        if (attr == null)
            attr = new DmcTypeCamelCaseNameSV(MvwDMSAG.__mappingName);
        
        try{
            attr.set(value);
            set(MvwDMSAG.__mappingName,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets mappingName to the specified value.
     * @param value A value compatible with DmcTypeCamelCaseNameSV
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:882)
    public void setMappingName(Object value) throws DmcValueException {
        DmcTypeCamelCaseNameSV attr  = (DmcTypeCamelCaseNameSV) get(MvwDMSAG.__mappingName);
        if (attr == null)
            attr = new DmcTypeCamelCaseNameSV(MvwDMSAG.__mappingName);
        
        attr.set(value);
        set(MvwDMSAG.__mappingName,attr);
    }

    /**
     * Removes the mappingName attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:902)
    public void remMappingName(){
         rem(MvwDMSAG.__mappingName);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:789)
    public String getEnumName(){
        DmcTypeStringSV attr = (DmcTypeStringSV) get(MetaDMSAG.__enumName);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets enumName to the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:829)
    public void setEnumName(String value) {
        DmcAttribute<?> attr = get(MetaDMSAG.__enumName);
        if (attr == null)
            attr = new DmcTypeStringSV(MetaDMSAG.__enumName);
        
        try{
            attr.set(value);
            set(MetaDMSAG.__enumName,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets enumName to the specified value.
     * @param value A value compatible with DmcTypeStringSV
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:882)
    public void setEnumName(Object value) throws DmcValueException {
        DmcTypeStringSV attr  = (DmcTypeStringSV) get(MetaDMSAG.__enumName);
        if (attr == null)
            attr = new DmcTypeStringSV(MetaDMSAG.__enumName);
        
        attr.set(value);
        set(MetaDMSAG.__enumName,attr);
    }

    /**
     * Removes the enumName attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:902)
    public void remEnumName(){
         rem(MetaDMSAG.__enumName);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:789)
    public String getUnsetValue(){
        DmcTypeStringSV attr = (DmcTypeStringSV) get(MvwDMSAG.__unsetValue);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets unsetValue to the specified value.
     * @param value String
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:829)
    public void setUnsetValue(String value) {
        DmcAttribute<?> attr = get(MvwDMSAG.__unsetValue);
        if (attr == null)
            attr = new DmcTypeStringSV(MvwDMSAG.__unsetValue);
        
        try{
            attr.set(value);
            set(MvwDMSAG.__unsetValue,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets unsetValue to the specified value.
     * @param value A value compatible with DmcTypeStringSV
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:882)
    public void setUnsetValue(Object value) throws DmcValueException {
        DmcTypeStringSV attr  = (DmcTypeStringSV) get(MvwDMSAG.__unsetValue);
        if (attr == null)
            attr = new DmcTypeStringSV(MvwDMSAG.__unsetValue);
        
        attr.set(value);
        set(MvwDMSAG.__unsetValue,attr);
    }

    /**
     * Removes the unsetValue attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:902)
    public void remUnsetValue(){
         rem(MvwDMSAG.__unsetValue);
    }

    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:660)
    public EnumMappingGeneratorREF getMappingGenerator(){
        DmcTypeEnumMappingGeneratorREFSV attr = (DmcTypeEnumMappingGeneratorREFSV) get(MvwDMSAG.__mappingGenerator);
        if (attr == null)
            return(null);

        if (DmcOmni.instance().lazyResolution()){
            if (attr.doLazyResolution(this)){
                rem(attr.getAttributeInfo());
                return(null);
            }
        }

        return(attr.getSV());
    }

    /**
     * Returns the reference to EnumMappingGenerator without attempting lazy resolution (if turned on).
     */
    public EnumMappingGeneratorREF getMappingGeneratorREF(){
        DmcTypeEnumMappingGeneratorREFSV attr = (DmcTypeEnumMappingGeneratorREFSV) get(MvwDMSAG.__mappingGenerator);
        if (attr == null)
            return(null);

        return(attr.getSV());
    }

    /**
     * Sets mappingGenerator to the specified value.
     * @param value EnumMappingGeneratorDMO
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:714)
    public void setMappingGenerator(EnumMappingGeneratorDMO value) {
        DmcAttribute<?> attr = get(MvwDMSAG.__mappingGenerator);
        if (attr == null)
            attr = new DmcTypeEnumMappingGeneratorREFSV(MvwDMSAG.__mappingGenerator);
        else
            ((DmcTypeEnumMappingGeneratorREFSV)attr).removeBackReferences();
        
        try{
            attr.set(value);
            set(MvwDMSAG.__mappingGenerator,attr);
        }
        catch(DmcValueException ex){
            throw(new IllegalStateException("The type specific set() method shouldn't throw exceptions!",ex));
        }
    }

    /**
     * Sets mappingGenerator to the specified value.
     * @param value A value compatible with DmcTypeEnumMappingGeneratorREFSV
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:882)
    public void setMappingGenerator(Object value) throws DmcValueException {
        DmcTypeEnumMappingGeneratorREFSV attr  = (DmcTypeEnumMappingGeneratorREFSV) get(MvwDMSAG.__mappingGenerator);
        if (attr == null)
            attr = new DmcTypeEnumMappingGeneratorREFSV(MvwDMSAG.__mappingGenerator);
        else
            attr.removeBackReferences();
        
        attr.set(value);
        set(MvwDMSAG.__mappingGenerator,attr);
    }

    /**
     * Removes the mappingGenerator attribute value.
     */
    // org.dmd.dms.util.GenUtility.formatSV(GenUtility.java:902)
    public void remMappingGenerator(){
         rem(MvwDMSAG.__mappingGenerator);
    }




}
