/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.client;

import org.dmd.dmp.client.CommsControllerIF;
import org.dmd.dmp.client.ErrorOptionsEnum;
import org.dmd.dmp.client.EventHandlerIF;
import org.dmd.dmp.client.ResponseHandlerIF;
import org.dmd.dmp.shared.generated.dmo.RequestDMO;
import org.dmd.dmp.shared.generated.dmo.ResponseDMO;

public class ResponseCallback {
    ResponseHandlerIF handler;
    EventHandlerIF eventHandler;
    RequestDMO request;
    CommsControllerIF commsController;
    int callbackID;
    ErrorOptionsEnum RPC;
    ErrorOptionsEnum DMP;

    protected ResponseCallback(RequestDMO req, ResponseHandlerIF h, CommsControllerIF cc, int cbid, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        this.request = req;
        this.handler = h;
        this.eventHandler = null;
        this.commsController = cc;
        this.callbackID = cbid;
        this.RPC = rpc;
        this.DMP = dmp;
    }

    protected ResponseCallback(RequestDMO req, ResponseHandlerIF h, EventHandlerIF eh, CommsControllerIF cc, int cbid, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        this.request = req;
        this.handler = h;
        this.eventHandler = eh;
        this.commsController = cc;
        this.callbackID = cbid;
        this.RPC = rpc;
        this.DMP = dmp;
    }

    public int getCallbackID() {
        return this.callbackID;
    }

    protected void handleResponse(ResponseDMO response) {
        this.commsController.handleResponse(this, response);
    }

    protected void rpcError(Throwable caught) {
        this.commsController.handleFailure(this, caught);
    }

    public ResponseHandlerIF getHandler() {
        return this.handler;
    }

    public EventHandlerIF getEventHandler() {
        return this.eventHandler;
    }

    public RequestDMO getRequest() {
        return this.request;
    }

    public Integer getRequestID() {
        return this.request.getNthRequestID(0);
    }

    public ErrorOptionsEnum rpcErrorOption() {
        return this.RPC;
    }

    public ErrorOptionsEnum dmpErrorOption() {
        return this.DMP;
    }
}

