/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmp.server.DmpPipeIF;
import org.dmd.dmp.server.extended.DMPEvent;
import org.dmd.dmp.server.extended.DMPMessage;
import org.dmd.dmp.server.extended.DenotifyRequest;
import org.dmd.dmp.server.extended.GetRequest;
import org.dmd.dmp.server.extended.GetResponse;
import org.dmd.dmp.server.extended.Response;
import org.dmd.dmp.server.servlet.base.cache.CacheIF;
import org.dmd.dmp.server.servlet.base.cache.CacheIndexListener;
import org.dmd.dmp.server.servlet.base.cache.CacheListener;
import org.dmd.dmp.server.servlet.base.cache.CacheRegistration;
import org.dmd.dmp.server.servlet.base.interfaces.DmpEventHandlerIF;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.util.exceptions.DebugInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRequestProcessor
implements DmpEventHandlerIF {
    private CacheRegistration cacheRegistration;
    private CacheIF cache;
    private WeakReference<DmpPipeIF> pipeRef;
    private HashMap<Long, CacheListener> listeners;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public GetRequestProcessor(DmpPipeIF pipe, CacheRegistration dcr) {
        this.cacheRegistration = dcr;
        this.cache = this.cacheRegistration.getCache();
        this.pipeRef = new WeakReference<DmpPipeIF>(pipe);
        this.listeners = new HashMap();
    }

    public void processRequest(GetRequest request) {
        if (request.getTargetsHasValue()) {
            this.processTargetedRequest(request);
        } else if (request.getFilter() != null) {
            this.processClassIndexRequest(request);
        } else {
            Response response = request.getErrorResponse();
            response.setResponseText("Unsupported form of GetRequest");
            response.setLastResponse(Boolean.valueOf(true));
            this.sendMessage((DMPMessage)response);
        }
    }

    public void processRequest(DenotifyRequest request) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTargetedRequest(GetRequest request) {
        GetRequestProcessor getRequestProcessor = this;
        synchronized (getRequestProcessor) {
            GetResponse response = null;
            switch (request.getScope()) {
                case ALL: {
                    break;
                }
                case BASE: 
                case NONE: {
                    if (request.getTargetsSize() != 1) break;
                    DmcObjectName name = request.getDMO().getNthTargets(0).getName();
                    DmwNamedObjectWrapper wrapper = this.cache.get(name);
                    if (wrapper == null) {
                        response = (GetResponse)request.getErrorResponse();
                        response.setResponseText("Couldn't retrieve object: " + name.getNameString());
                        break;
                    }
                    response = request.getResponse();
                    response.addObjectList(wrapper.getDmcObject());
                    response.setLastResponse(Boolean.valueOf(true));
                    break;
                }
            }
            this.sendMessage((DMPMessage)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassIndexRequest(GetRequest request) {
        try {
            DmcClassInfo dci = DmcOmni.instance().getClassInfo(request.getFilter());
            if (dci == null) {
                Response response = request.getErrorResponse();
                response.setResponseText("Unknown class: " + request.getFilter());
                response.setLastResponse(Boolean.valueOf(true));
                this.sendMessage((DMPMessage)response);
                this.logger.error("Unknown filter class: " + request.getFilter() + " in GetRequest\n" + request.toOIF());
                return;
            }
            if (request.isTrackingEnabled().booleanValue()) {
                this.logger.trace("Retrieving objects from class index: " + dci.name);
            }
            GetRequestProcessor getRequestProcessor = this;
            synchronized (getRequestProcessor) {
                Collection<DmwNamedObjectWrapper> objects = null;
                Integer bf = request.getBlockingFactor();
                int blockingFactor = bf == null ? -1 : (bf < 10 ? -1 : bf);
                GetResponse response = request.getResponse();
                if (request.isRegisterForEvents().booleanValue()) {
                    CacheIndexListener listener = null;
                    listener = new CacheIndexListener(this.cacheRegistration, this, request.getSliceInfo(), dci);
                    this.logger.trace("Registered cache index listener with ID: " + listener.getListenerID());
                    this.listeners.put(listener.getListenerID(), listener);
                    response.setListenerID(Long.valueOf(listener.getListenerID()));
                    objects = listener.activateAndRetrieve();
                } else {
                    objects = this.cache.getIndex(dci);
                }
                if (objects.size() == 0) {
                    response.setLastResponse(Boolean.valueOf(true));
                    response.setResponseText("No " + dci.name + " objects have been indexed.");
                } else {
                    if (request.isTrackingEnabled().booleanValue()) {
                        this.logger.trace(objects.size() + " objects to be sent");
                    }
                    for (DmwNamedObjectWrapper object : objects) {
                        response.addObjectList((Object)object);
                        if (response.getObjectListSize() != blockingFactor) continue;
                        response.setLastResponse(Boolean.valueOf(false));
                        this.sendMessage((DMPMessage)response);
                        response = request.getResponse();
                    }
                }
                response.setLastResponse(Boolean.valueOf(true));
                this.sendMessage((DMPMessage)response);
            }
        }
        catch (Exception ex) {
            this.logger.error(DebugInfo.extractTheStack((Exception)ex));
        }
    }

    private void sendMessage(DMPMessage msg) {
        this.logger.trace("Sending message...");
        DmpPipeIF pipe = (DmpPipeIF)this.pipeRef.get();
        if (pipe == null) {
            return;
        }
        pipe.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEvent(DMPEvent event) {
        this.logger.trace("Sending event...");
        GetRequestProcessor getRequestProcessor = this;
        synchronized (getRequestProcessor) {
            this.sendMessage((DMPMessage)event);
        }
    }
}

