/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base;

import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;
import org.dmd.dmc.DmcCompactSchemaIF;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmp.server.generated.DmpSchemaAG;
import org.dmd.dmp.server.servlet.base.DmpServletPlugin;
import org.dmd.dmp.server.servlet.base.actions.ActionManagerIF;
import org.dmd.dmp.server.servlet.base.cache.CacheIF;
import org.dmd.dmp.server.servlet.base.interfaces.RequestTrackerIF;
import org.dmd.dmp.server.servlet.base.interfaces.SecurityManagerIF;
import org.dmd.dmp.server.servlet.dmpservletri.DMPServiceImpl;
import org.dmd.dmp.server.servlet.extended.PluginConfig;
import org.dmd.dmp.server.servlet.generated.DmpServerSchemaAG;
import org.dmd.dmp.server.servlet.generated.dmo.DmpServerDMSAG;
import org.dmd.dmp.shared.generated.dmo.DmpDMSAG;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.dmw.DmwOmni;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class PluginManager
implements DmcUncheckedOIFHandlerIF {
    DmwObjectFactory factory;
    DmcUncheckedOIFParser configParser;
    TreeMap<DmcObjectName, PluginConfig> pluginConfigs;
    TreeMap<Integer, ArrayList<DmpServletPlugin>> startOrder;
    DMPServiceImpl servlet;
    RequestTrackerIF requestTracker;
    DmpServletPlugin requestTrackerPlugin;
    SecurityManagerIF securityManager;
    DmpServletPlugin securityPlugin;
    CacheIF cache;
    DmpServletPlugin cachePlugin;
    ActionManagerIF actionManager;
    DmpServletPlugin actionManagerPlugin;
    DmvRuleManager ruleManager;

    public PluginManager(DMPServiceImpl s) throws ResultException, DmcValueException {
        this.servlet = s;
        DmpSchemaAG dmp = new DmpSchemaAG();
        DmpServerSchemaAG dmps = new DmpServerSchemaAG();
        DmwOmni.instance().addSchema((SchemaDefinition)dmp.getInstance());
        DmwOmni.instance().addSchema((SchemaDefinition)dmps.getInstance());
        this.factory = new DmwObjectFactory(DmwOmni.instance().getSchema());
        this.configParser = new DmcUncheckedOIFParser((DmcUncheckedOIFHandlerIF)this);
        this.pluginConfigs = new TreeMap();
        this.startOrder = new TreeMap();
        this.securityManager = null;
        this.ruleManager = new DmvRuleManager();
        this.ruleManager.loadRules((DmcCompactSchemaIF)DmpDMSAG.instance());
        this.ruleManager.loadRules((DmcCompactSchemaIF)DmpServerDMSAG.instance());
    }

    public SecurityManagerIF getSecurityManager() {
        return this.securityManager;
    }

    public RequestTrackerIF getRequestTracker() {
        return this.requestTracker;
    }

    public DMPServiceImpl getServlet() {
        return this.servlet;
    }

    public CacheIF getCache() {
        return this.cache;
    }

    public ActionManagerIF getActionManager() {
        return this.actionManager;
    }

    public void loadPlugins(String fn) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        ResultException ex2;
        File pluginFile = new File(fn);
        if (!pluginFile.exists()) {
            ResultException ex2 = new ResultException();
            ex2.addError("Could not open DMP Servlet configuration file: " + fn);
            throw ex2;
        }
        this.configParser.parseFile(fn);
        for (PluginConfig sp : this.pluginConfigs.values()) {
            ResultException ex3;
            DmpServletPlugin plugin = this.instantiatePlugin(sp);
            if (plugin instanceof RequestTrackerIF) {
                if (this.requestTracker == null) {
                    this.requestTracker = (RequestTrackerIF)((Object)plugin);
                    this.requestTrackerPlugin = plugin;
                    continue;
                }
                ex3 = new ResultException("Multiple request tracker plugins specified.");
                throw ex3;
            }
            if (plugin instanceof CacheIF) {
                if (this.cache == null) {
                    this.cache = (CacheIF)((Object)plugin);
                    this.cachePlugin = plugin;
                    continue;
                }
                ex3 = new ResultException("Multiple cache plugins specified.");
                throw ex3;
            }
            if (plugin instanceof SecurityManagerIF) {
                if (this.securityManager == null) {
                    this.securityManager = (SecurityManagerIF)((Object)plugin);
                    this.securityPlugin = plugin;
                    continue;
                }
                ex3 = new ResultException("Multiple security manager plugins specified.");
                throw ex3;
            }
            if (plugin instanceof ActionManagerIF) {
                if (this.actionManager == null) {
                    this.actionManager = (ActionManagerIF)((Object)plugin);
                    this.actionManagerPlugin = plugin;
                    continue;
                }
                ex3 = new ResultException("Multiple action manager plugins specified.");
                throw ex3;
            }
            ArrayList<DmpServletPlugin> plugins = this.startOrder.get(sp.getStartOrder());
            if (plugins == null) {
                plugins = new ArrayList();
                this.startOrder.put(sp.getStartOrder(), plugins);
            }
            plugins.add(plugin);
        }
        if (this.requestTracker == null) {
            ex2 = new ResultException();
            ex2.addError("No plugin has been specified that implements the org.dmd.dmp.server.servlet.base.interfaces.RequestTrackerIF interface");
            throw ex2;
        }
        if (this.cache == null) {
            ex2 = new ResultException();
            ex2.addError("No plugin has been specified that implements the org.dmd.dmp.server.servlet.base.interfaces.CacheIF interface");
            throw ex2;
        }
        if (this.securityManager == null) {
            ex2 = new ResultException();
            ex2.addError("No plugin has been specified that implements the org.dmd.dmp.server.servlet.base.interfaces.SecurityManagerIF interface");
            throw ex2;
        }
    }

    public void preInit() throws ResultException, DmcValueException {
        this.requestTrackerPlugin.preInit();
        this.cachePlugin.preInit();
        this.securityPlugin.preInit();
        if (this.actionManagerPlugin != null) {
            this.actionManagerPlugin.preInit();
        }
        for (Integer order : this.startOrder.keySet()) {
            ArrayList<DmpServletPlugin> plugins = this.startOrder.get(order);
            for (DmpServletPlugin sp : plugins) {
                sp.preInit();
            }
        }
    }

    public void init() throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.requestTrackerPlugin.init();
        this.cachePlugin.init();
        this.securityPlugin.init();
        if (this.actionManagerPlugin != null) {
            this.actionManagerPlugin.init();
        }
        for (Integer order : this.startOrder.keySet()) {
            ArrayList<DmpServletPlugin> plugins = this.startOrder.get(order);
            for (DmpServletPlugin sp : plugins) {
                sp.init();
            }
        }
    }

    public void start() throws ResultException, DmcValueException {
        this.requestTrackerPlugin.start();
        this.cachePlugin.start();
        this.securityPlugin.start();
        if (this.actionManagerPlugin != null) {
            this.actionManagerPlugin.start();
        }
        for (Integer order : this.startOrder.keySet()) {
            ArrayList<DmpServletPlugin> plugins = this.startOrder.get(order);
            for (DmpServletPlugin sp : plugins) {
                sp.start();
            }
        }
    }

    public void shutdown() {
        ArrayList<DmpServletPlugin> reverse = new ArrayList<DmpServletPlugin>();
        for (Integer order : this.startOrder.keySet()) {
            ArrayList<DmpServletPlugin> plugins = this.startOrder.get(order);
            for (DmpServletPlugin sp : plugins) {
                reverse.add(0, sp);
            }
        }
        for (DmpServletPlugin sp : reverse) {
            sp.shutdown();
        }
        if (this.actionManagerPlugin != null) {
            this.actionManagerPlugin.shutdown();
        }
        this.securityPlugin.shutdown();
        this.cachePlugin.shutdown();
        this.requestTrackerPlugin.shutdown();
    }

    DmpServletPlugin instantiatePlugin(PluginConfig pc) throws ResultException {
        DmpServletPlugin rc = null;
        Class<?> pluginClass = null;
        try {
            if (pc.getPluginClass() == null) {
                ResultException ex = new ResultException();
                ex.addError("Mandatory attribute pluginClass not specified");
                ex.setLocationInfo(pc.getFile(), pc.getLineNumber().intValue());
                throw ex;
            }
            pluginClass = Class.forName(pc.getPluginClass());
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException();
            ex.addError("Plugin class not found: " + pc.getPluginClass());
            ex.setLocationInfo(pc.getFile(), pc.getLineNumber().intValue());
            throw ex;
        }
        try {
            rc = (DmpServletPlugin)pluginClass.newInstance();
            rc.setManagerAndConfig(this, pc);
        }
        catch (InstantiationException e) {
            ResultException ex = new ResultException();
            ex.addError("InstantiationException for: " + pc.getPluginClass());
            ex.setLocationInfo(pc.getFile(), pc.getLineNumber().intValue());
            throw ex;
        }
        catch (IllegalAccessException e) {
            ResultException ex = new ResultException();
            ex.addError("IllegalAccessException for: " + pc.getPluginClass());
            ex.setLocationInfo(pc.getFile(), pc.getLineNumber().intValue());
            throw ex;
        }
        return rc;
    }

    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException {
        PluginConfig config = null;
        try {
            config = (PluginConfig)this.factory.createWrapper(uco);
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + (String)uco.classes.get(0));
            ex.result.lastResult().moreMessages("The plugin configuration file should contain PluginConfig objects.");
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ClassCastException e) {
            ResultException ex = new ResultException("Invalid object in plugin config file: " + (String)uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (DmcNameClashException e) {
            ResultException ex = new ResultException("Name clash for class: " + (String)uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        config.setLineNumber(lineNumber);
        config.setFile(infile);
        if (config.getPluginName() != null) {
            config.setCamelCaseName(config.getPluginName());
        }
        try {
            this.ruleManager.executeAttributeValidation(config.getDmcObject());
            this.ruleManager.executeObjectValidation(config.getDmcObject());
        }
        catch (DmcRuleExceptionSet e) {
            e.printStackTrace();
        }
        if (this.pluginConfigs.get(config.getObjectName()) != null) {
            ResultException ex = new ResultException("Duplicate plugin name: " + config.getObjectName());
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        this.pluginConfigs.put((DmcObjectName)config.getObjectName(), config);
    }
}

