/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base.actions;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.types.LongVar;
import org.dmd.dmp.server.extended.ActionRequest;
import org.dmd.dmp.server.extended.ActionResponse;
import org.dmd.dmp.server.extended.Response;
import org.dmd.dmp.server.servlet.base.actions.ActionManagerIF;
import org.dmd.dmp.server.servlet.base.cache.CacheIF;
import org.dmd.dmp.server.servlet.base.interfaces.RequestTrackerIF;
import org.dmd.dmp.shared.generated.enums.ResponseTypeEnum;
import org.dmd.util.BooleanVar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ActionHandler
implements Runnable {
    public static final long DEFAULT_HEARTBEAT_MS = 3000L;
    protected ActionRequest request;
    protected ActionManagerIF actionManager;
    protected CacheIF cache;
    private LongVar responseSendTime;
    protected final Integer serverActionID;
    private RequestTrackerIF requestTracker;
    protected volatile BooleanVar cancelled;
    private final ScheduledExecutorService ses;
    private final ScheduledFuture<?> heartbeatTask;
    private boolean lastResponseSent;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public ActionHandler(Integer serverActionID, ActionRequest request, ActionManagerIF actionManager, CacheIF cache, RequestTrackerIF requestTracker) {
        this.serverActionID = serverActionID;
        this.request = request;
        this.actionManager = actionManager;
        this.cache = cache;
        this.requestTracker = requestTracker;
        this.cancelled = new BooleanVar(false);
        this.ses = Executors.newSingleThreadScheduledExecutor();
        this.heartbeatTask = this.ses.scheduleWithFixedDelay(new HeartbeatTask(this), 500L, 3000L, TimeUnit.MILLISECONDS);
        this.responseSendTime = new LongVar();
        this.lastResponseSent = false;
    }

    public ActionManagerIF actionManager() {
        return this.actionManager;
    }

    public ActionRequest request() {
        return this.request;
    }

    public Integer serverActionID() {
        return this.serverActionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        BooleanVar booleanVar = this.cancelled;
        synchronized (booleanVar) {
            this.cancelled.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelled() {
        BooleanVar booleanVar = this.cancelled;
        synchronized (booleanVar) {
            return this.cancelled.booleanValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(ActionResponse response) {
        RequestTrackerIF requestTrackerIF = this.requestTracker;
        synchronized (requestTrackerIF) {
            if (this.lastResponseSent) {
                return;
            }
            this.logger.debug("sending response");
            response.setServerActionID(this.serverActionID);
            this.lastResponseTime(System.currentTimeMillis());
            this.requestTracker.processResponse((Response)response);
            if (response.isLastResponse().booleanValue()) {
                this.logger.debug("Last response - cancelling heartbeat");
                this.lastResponseSent = true;
                this.heartbeatTask.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long lastResponseTime() {
        LongVar longVar = this.responseSendTime;
        synchronized (longVar) {
            return this.responseSendTime.longValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lastResponseTime(long time) {
        LongVar longVar = this.responseSendTime;
        synchronized (longVar) {
            this.responseSendTime.set(time);
        }
    }

    public abstract ActionResponse canProceed();

    protected void sendProgressObject(DmcObject object) {
        ActionResponse response = this.request.getResponse();
        response.setResponseType(ResponseTypeEnum.PROGRESSOBJECTS);
        response.addObjectList(object);
        response.setLastResponse(Boolean.valueOf(false));
        this.sendResponse(response);
    }

    protected void sendProgressObjects(ArrayList<DmcObject> objects) {
        ActionResponse response = this.request.getResponse();
        response.setResponseType(ResponseTypeEnum.PROGRESSOBJECTS);
        for (DmcObject obj : objects) {
            response.addObjectList(obj);
        }
        response.setLastResponse(Boolean.valueOf(false));
        this.sendResponse(response);
    }

    protected void sendProgressText(String message) {
        ActionResponse response = this.request.getResponse();
        response.setResponseType(ResponseTypeEnum.PROGRESSTEXT);
        response.setResponseText(message);
        response.setLastResponse(Boolean.valueOf(false));
        this.sendResponse(response);
    }

    protected void sendError(String message) {
        ActionResponse response = (ActionResponse)this.request.getErrorResponse();
        response.setResponseText(message);
        response.setLastResponse(Boolean.valueOf(true));
        this.sendResponse(response);
    }

    public class HeartbeatTask
    implements Runnable {
        ActionHandler handler;

        public HeartbeatTask(ActionHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.logger.debug("Heartbeat triggered");
            ActionResponse response = this.handler.request.getResponse();
            response.setResponseType(ResponseTypeEnum.HEARTBEAT);
            long delta = System.currentTimeMillis() - ActionHandler.this.lastResponseTime();
            if (delta > 3000L) {
                if (this.handler.cancelled()) {
                    response.setResponseText("Cancel pending");
                } else {
                    response.setResponseText("Still running");
                }
                response.setLastResponse(Boolean.valueOf(false));
                this.handler.sendResponse(response);
            }
        }
    }
}

