/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base.cache;

import java.util.Collection;
import org.dmd.dmc.DmcSliceInfo;
import org.dmd.dmp.server.extended.DMPEvent;
import org.dmd.dmp.server.servlet.base.SessionIF;
import org.dmd.dmp.server.servlet.base.cache.CacheRegistration;
import org.dmd.dmp.server.servlet.base.interfaces.DmpEventHandlerIF;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.slf4j.LoggerFactory;

public abstract class CacheListener {
    private final long listenerId;
    protected final CacheRegistration cacheRegistration;
    private final DmpEventHandlerIF eventHandler;
    private final DmcSliceInfo sliceInfo;

    protected CacheListener(CacheRegistration reg, DmpEventHandlerIF eh, DmcSliceInfo dsi) {
        this.cacheRegistration = reg;
        this.listenerId = this.cacheRegistration.getCache().getNextListenerID();
        this.eventHandler = eh;
        this.sliceInfo = dsi;
    }

    public CacheRegistration getCacheRegistration() {
        return this.cacheRegistration;
    }

    public long getListenerID() {
        return this.listenerId;
    }

    public SessionIF session() {
        return this.cacheRegistration.getSession();
    }

    public Collection<DmwNamedObjectWrapper> activateAndRetrieve() {
        return this.cacheRegistration.getCache().addListener(this);
    }

    public void processCacheEvent(DMPEvent event) {
        if (event.getOriginatorID() == null) {
            throw new IllegalStateException("OriginatorID should not be null: " + event.toOIF());
        }
        if (event.getOriginatorID().intValue() == this.cacheRegistration.getID() && !event.isNotifyOriginator().booleanValue()) {
            if (event.isTrackingEnabled().booleanValue()) {
                LoggerFactory.getLogger(this.getClass()).debug("Dropping event because notifyOriginator is false: " + event.toOIF());
            }
            return;
        }
        DMPEvent forwardedEvent = null;
        forwardedEvent = this.sliceInfo == null ? event.clone() : event.getSlice(this.sliceInfo);
        if (forwardedEvent == null) {
            if (event.isTrackingEnabled().booleanValue()) {
                LoggerFactory.getLogger(this.getClass()).debug("Dropping event due to slicing: " + event.toOIF());
            }
            return;
        }
        forwardedEvent.setListenerID(Long.valueOf(this.listenerId));
        this.eventHandler.handleEvent(forwardedEvent);
    }

    public abstract String getTraceInfo();
}

