/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base.cache;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmp.server.extended.DMPEvent;
import org.dmd.dmp.server.servlet.base.SessionIF;
import org.dmd.dmp.server.servlet.base.cache.CacheFullListener;
import org.dmd.dmp.server.servlet.base.cache.CacheIndexListener;
import org.dmd.dmp.server.servlet.base.cache.CacheListener;
import org.dmd.dms.ClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheListenerManager {
    ListenerSet<CacheFullListener> fullListeners = new ListenerSet();
    HashMap<DmcClassInfo, IndexListenerSet> indexListeners = new HashMap();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CacheListener listener) {
        CacheListenerManager cacheListenerManager = this;
        synchronized (cacheListenerManager) {
            if (listener instanceof CacheFullListener) {
                this.fullListeners.add((CacheFullListener)listener);
            } else if (listener instanceof CacheIndexListener) {
                CacheIndexListener cil = (CacheIndexListener)listener;
                IndexListenerSet set = this.indexListeners.get(cil.getClassInfo());
                if (set == null) {
                    set = new IndexListenerSet(cil.getClassInfo());
                    this.indexListeners.put(cil.getClassInfo(), set);
                }
                set.add(cil);
            }
            this.logger.trace("Added listener: " + listener.getTraceInfo());
        }
    }

    public void removeAllListeners() {
        this.fullListeners = new ListenerSet();
        this.indexListeners = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CacheListener listener) {
        CacheListenerManager cacheListenerManager = this;
        synchronized (cacheListenerManager) {
            if (listener instanceof CacheFullListener) {
                this.fullListeners.remove((CacheFullListener)listener);
            } else if (listener instanceof CacheIndexListener) {
                CacheIndexListener cil = (CacheIndexListener)listener;
                IndexListenerSet set = this.indexListeners.get(cil.getClassInfo());
                if (set == null) {
                    this.logger.trace("Tried removing listener but no listeners found for the index: " + listener.getTraceInfo());
                    return;
                }
                set.remove(cil);
            }
            this.logger.trace("Removed listener: " + listener.getTraceInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListenersForSession(SessionIF session) {
        CacheListenerManager cacheListenerManager = this;
        synchronized (cacheListenerManager) {
            ArrayList<CacheFullListener> fl = new ArrayList<CacheFullListener>();
            for (CacheFullListener cfl : this.fullListeners.getListeners()) {
                if (!cfl.session().sessionID().equals(session.sessionID())) continue;
                fl.add(cfl);
            }
            for (CacheFullListener cfl : fl) {
                this.fullListeners.remove(cfl);
            }
            for (DmcClassInfo dci : this.indexListeners.keySet()) {
                IndexListenerSet set = this.indexListeners.get(dci);
                ArrayList<CacheIndexListener> listeners = new ArrayList<CacheIndexListener>();
                for (CacheIndexListener cil : set.getListeners()) {
                    if (!cil.session().sessionID().equals(session.sessionID())) continue;
                    listeners.add(cil);
                }
                for (CacheIndexListener cil : listeners) {
                    set.remove(cil);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CacheListener> getInterestedListeners(DMPEvent event) {
        CacheListenerManager cacheListenerManager = this;
        synchronized (cacheListenerManager) {
            LinkedList<CacheListener> listeners = new LinkedList<CacheListener>();
            ListenerSet listenerSet = null;
            ListenerSet listenerSet2 = null;
            listeners.addAll(this.fullListeners.getListeners());
            ClassDefinition cd = event.getSourceObjectClass();
            ClassDefinition cd2 = cd.getDerivedFrom();
            listenerSet = this.indexListeners.get(cd.getClassInfo());
            if (listenerSet != null) {
                listeners.addAll(listenerSet.getListeners());
            }
            if (cd2 != null && (listenerSet2 = (ListenerSet)this.indexListeners.get(cd2.getClassInfo())) != null) {
                listeners.addAll(listenerSet2.getListeners());
            }
            return listeners;
        }
    }

    private class IndexListenerSet
    extends ListenerSet<CacheIndexListener> {
        final DmcClassInfo classInfo;

        IndexListenerSet(DmcClassInfo dci) {
            this.classInfo = dci;
        }
    }

    private class ListenerSet<E extends CacheListener> {
        LinkedList<WeakReference<E>> listeners = new LinkedList();

        protected ListenerSet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(E listener) {
            ListenerSet listenerSet = this;
            synchronized (listenerSet) {
                this.listeners.add(new WeakReference<E>(listener));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection<E> getListeners() {
            ListenerSet listenerSet = this;
            synchronized (listenerSet) {
                LinkedList<CacheListener> listenersToNotify = new LinkedList<CacheListener>();
                if (this.listeners == null) {
                    return listenersToNotify;
                }
                Iterator listenerIt = this.listeners.iterator();
                while (listenerIt.hasNext()) {
                    WeakReference ref = (WeakReference)listenerIt.next();
                    CacheListener listener = (CacheListener)ref.get();
                    if (listener == null) {
                        listenerIt.remove();
                        continue;
                    }
                    listenersToNotify.add(listener);
                }
                return listenersToNotify;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(E listener) {
            ListenerSet listenerSet = this;
            synchronized (listenerSet) {
                Iterator refIt = this.listeners.iterator();
                while (refIt.hasNext()) {
                    CacheListener test = (CacheListener)((WeakReference)refIt.next()).get();
                    if (test != listener) continue;
                    refIt.remove();
                    break;
                }
            }
        }
    }
}

