/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base.plugins;

import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmp.server.extended.ActionCancelRequest;
import org.dmd.dmp.server.extended.ActionCancelResponse;
import org.dmd.dmp.server.extended.ActionRequest;
import org.dmd.dmp.server.extended.ActionResponse;
import org.dmd.dmp.server.extended.DMPMessage;
import org.dmd.dmp.server.extended.Request;
import org.dmd.dmp.server.extended.Response;
import org.dmd.dmp.server.servlet.base.DmpServletPlugin;
import org.dmd.dmp.server.servlet.base.actions.ActionFactory;
import org.dmd.dmp.server.servlet.base.actions.ActionHandler;
import org.dmd.dmp.server.servlet.base.actions.ActionManagerIF;
import org.dmd.dmp.server.servlet.base.interfaces.DmpRequestProcessorIF;
import org.dmd.dmp.server.servlet.base.interfaces.RequestTrackerIF;
import org.dmd.dmp.shared.generated.enums.ResponseTypeEnum;
import org.dmd.dms.extended.ActionTriggerInfo;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicActionManagerPlugin
extends DmpServletPlugin
implements Runnable,
ActionManagerIF {
    private RequestTrackerIF requestTracker;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    Thread ourThread;
    private LinkedBlockingQueue<DMPMessage> inputQueue;
    private TreeMap<String, ActionFactory<?, ?>> registeredActions;
    private int actionID;
    private TreeMap<Integer, RunningActionWrapper> runningActions;
    private static int THREADS = 10;
    private Executor executor;

    @Override
    public void registerAction(ActionFactory<?, ?> factory) throws ResultException {
        ActionFactory<?, ?> existing = this.registeredActions.get(factory.actionTriggerInfo().getActionName());
        if (existing != null) {
            ResultException ex = new ResultException("Duplicate action handler for: " + existing.actionTriggerInfo().toOIF());
            throw ex;
        }
        this.registeredActions.put(factory.actionTriggerInfo().getActionName(), factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionFailed(ActionHandler actionHandler, Exception ex) {
        TreeMap<Integer, RunningActionWrapper> treeMap = this.runningActions;
        synchronized (treeMap) {
            ActionResponse response = (ActionResponse)actionHandler.request().getErrorResponse();
            response.setServerActionID(actionHandler.serverActionID());
            response.setLastResponse(Boolean.valueOf(true));
            response.setResponseText(ex.getMessage() + "\n" + DebugInfo.extractTheStack((Exception)ex));
            this.logger.debug("Failure of action: " + actionHandler.serverActionID());
            this.runningActions.remove(actionHandler.serverActionID());
            this.requestTracker.processResponse((Response)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionComplete(ActionHandler actionHandler) {
        TreeMap<Integer, RunningActionWrapper> treeMap = this.runningActions;
        synchronized (treeMap) {
            this.logger.debug("Action complete for action: " + actionHandler.serverActionID());
            this.runningActions.remove(actionHandler.serverActionID());
        }
    }

    @Override
    public void preInit() throws ResultException, DmcValueException {
        this.logger.debug("action manager");
    }

    @Override
    public void init() throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.logger.debug("action manager");
        this.inputQueue = new LinkedBlockingQueue();
        this.executor = Executors.newFixedThreadPool(THREADS);
        this.registeredActions = new TreeMap();
        this.actionID = 1;
        this.runningActions = new TreeMap();
        this.requestTracker = this.pluginManager.getRequestTracker();
        this.requestTracker.bindRequestProcessor(ActionRequest.class, new DmpRequestProcessorIF(){

            @Override
            public void processRequest(Request request) {
                ActionFactory factory;
                ActionResponse response;
                ActionRequest newRequest = (ActionRequest)request;
                if (newRequest.getActionTrigger() == null) {
                    response = newRequest.getResponse();
                    response.setResponseType(ResponseTypeEnum.ERROR);
                    response.setLastResponse(Boolean.valueOf(true));
                    response.setResponseText("No action trigger info specified in Action Request. Make sure you're using the request creation mechanisms for Presenters in MVW.");
                    BasicActionManagerPlugin.this.requestTracker.processResponse((Response)response);
                }
                if (newRequest.getActionName() == null) {
                    response = newRequest.getResponse();
                    response.setResponseType(ResponseTypeEnum.ERROR);
                    response.setLastResponse(Boolean.valueOf(true));
                    response.setResponseText("No action name specified in Action Request. Make sure you're using the request creation mechanisms for Presenters in MVW.");
                    BasicActionManagerPlugin.this.requestTracker.processResponse((Response)response);
                }
                if ((factory = (ActionFactory)BasicActionManagerPlugin.this.registeredActions.get(newRequest.getActionName())) == null) {
                    ActionResponse response2 = newRequest.getResponse();
                    response2.setResponseType(ResponseTypeEnum.ERROR);
                    response2.setLastResponse(Boolean.valueOf(true));
                    response2.setResponseText("No action handler registered for action trigger info: " + newRequest.getActionName());
                    BasicActionManagerPlugin.this.requestTracker.processResponse((Response)response2);
                } else {
                    BasicActionManagerPlugin.this.queueRequest(request);
                }
            }

            @Override
            public boolean acceptRequest(Request request) {
                return true;
            }
        });
        this.requestTracker.bindRequestProcessor(ActionCancelRequest.class, new DmpRequestProcessorIF(){

            @Override
            public void processRequest(Request request) {
                ActionCancelRequest newRequest = (ActionCancelRequest)request;
                if (newRequest.getServerActionID() == null) {
                    ActionCancelResponse response = (ActionCancelResponse)newRequest.getErrorResponse();
                    response.setResponseText("Missing serverActionID attribute");
                    BasicActionManagerPlugin.this.requestTracker.processResponse((Response)response);
                } else if (BasicActionManagerPlugin.this.runningActions.get(newRequest.getServerActionID()) == null) {
                    ActionCancelResponse response = (ActionCancelResponse)newRequest.getErrorResponse();
                    response.setResponseText("There is no running action with serverActionID: " + newRequest.getServerActionID());
                    BasicActionManagerPlugin.this.requestTracker.processResponse((Response)response);
                }
                BasicActionManagerPlugin.this.queueRequest(request);
            }

            @Override
            public boolean acceptRequest(Request request) {
                return true;
            }
        });
    }

    @Override
    public void start() throws ResultException, DmcValueException {
        this.ourThread = new Thread(this);
        this.ourThread.start();
    }

    @Override
    public void shutdown() {
        this.ourThread.interrupt();
    }

    private void queueRequest(Request request) {
        this.addToQueue((DMPMessage)request);
    }

    private void addToQueue(DMPMessage msg) {
        try {
            this.inputQueue.put(msg);
        }
        catch (Exception e) {
            this.logger.error("Caught Exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processActionRequest(ActionRequest request) {
        TreeMap<Integer, RunningActionWrapper> treeMap = this.runningActions;
        synchronized (treeMap) {
            ActionFactory<?, ?> factory;
            if (request.isTrackingEnabled().booleanValue()) {
                this.logger.info("processActionRequest: \n" + request);
            }
            if (!(factory = this.registeredActions.get(request.getActionName())).isCorrectTypeOfATI(request.getActionTrigger())) {
                ActionResponse response = (ActionResponse)request.getErrorResponse();
                response.setResponseText("Incorrect action trigger type: " + request.getActionTrigger().getClass().getName());
                response.setLastResponse(Boolean.valueOf(true));
                this.requestTracker.processResponse((Response)response);
                return;
            }
            ActionTriggerInfo ati = (ActionTriggerInfo)request.getActionTrigger();
            try {
                ati.checkParams();
            }
            catch (DmcValueExceptionSet e) {
                ActionResponse response = (ActionResponse)request.getErrorResponse();
                response.setResponseText(e.toString());
                response.setLastResponse(Boolean.valueOf(true));
                this.requestTracker.processResponse((Response)response);
                return;
            }
            Object handler = factory.newHandler(this.actionID++, request, this, this.pluginManager.getCache(), this.requestTracker);
            ActionResponse errorResponse = ((ActionHandler)handler).canProceed();
            if (errorResponse != null) {
                errorResponse.setLastResponse(Boolean.valueOf(true));
                this.requestTracker.processResponse((Response)errorResponse);
                return;
            }
            RunningActionWrapper runnable = new RunningActionWrapper((ActionHandler)handler);
            this.runningActions.put(((ActionHandler)handler).serverActionID(), runnable);
            this.logger.debug("Action running: " + ((ActionHandler)handler).serverActionID() + "  runningActions.size(): " + this.runningActions.size());
            this.executor.execute(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processActionCancelRequest(ActionCancelRequest request) {
        TreeMap<Integer, RunningActionWrapper> treeMap = this.runningActions;
        synchronized (treeMap) {
            RunningActionWrapper runnable;
            if (request.isTrackingEnabled().booleanValue()) {
                this.logger.debug("Running actions size: " + this.runningActions.size());
                this.logger.info("processActionCancelRequest: \n" + request);
            }
            if ((runnable = this.runningActions.get(request.getServerActionID())) == null) {
                this.logger.debug("Couldn't cancel action: " + request.getServerActionID());
                ActionCancelResponse response = request.getResponse();
                response.setResponseText("Action finished before we could cancel.");
                response.setResponseType(ResponseTypeEnum.SUCCESS);
                response.setLastResponse(Boolean.valueOf(true));
                this.requestTracker.processResponse((Response)response);
            } else {
                this.logger.debug("Cancelling action: " + request.getServerActionID());
                runnable.theAction.cancel();
                ActionCancelResponse response = request.getResponse();
                response.setResponseText("Action cancel pending.");
                response.setResponseType(ResponseTypeEnum.SUCCESS);
                response.setLastResponse(Boolean.valueOf(true));
                this.requestTracker.processResponse((Response)response);
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            DMPMessage message = null;
            try {
                message = this.inputQueue.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (message instanceof ActionRequest) {
                this.processActionRequest((ActionRequest)message);
                continue;
            }
            if (message instanceof ActionCancelRequest) {
                this.processActionCancelRequest((ActionCancelRequest)message);
                continue;
            }
            this.logger.error("Unknown message type was queued!!! \n" + message.toOIF());
        }
    }

    private class RunningActionWrapper
    implements Runnable {
        private ActionHandler theAction;

        public RunningActionWrapper(ActionHandler theRunnable) {
            this.theAction = theRunnable;
        }

        @Override
        public void run() {
            try {
                this.theAction.run();
            }
            catch (Exception ex) {
                this.theAction.actionManager().actionFailed(this.theAction, ex);
            }
            this.theAction.actionManager().actionComplete(this.theAction);
        }
    }
}

