/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base.plugins;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcHierarchicObjectName;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.NameContainer;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dmp.server.extended.CreateRequest;
import org.dmd.dmp.server.extended.CreateResponse;
import org.dmd.dmp.server.extended.DMPEvent;
import org.dmd.dmp.server.extended.DMPMessage;
import org.dmd.dmp.server.extended.DeleteRequest;
import org.dmd.dmp.server.extended.DeleteResponse;
import org.dmd.dmp.server.extended.Request;
import org.dmd.dmp.server.extended.Response;
import org.dmd.dmp.server.extended.SetRequest;
import org.dmd.dmp.server.extended.SetResponse;
import org.dmd.dmp.server.servlet.base.DmpServletPlugin;
import org.dmd.dmp.server.servlet.base.SessionIF;
import org.dmd.dmp.server.servlet.base.cache.CacheIF;
import org.dmd.dmp.server.servlet.base.cache.CacheIndexListener;
import org.dmd.dmp.server.servlet.base.cache.CacheListener;
import org.dmd.dmp.server.servlet.base.cache.CacheListenerManager;
import org.dmd.dmp.server.servlet.base.cache.CacheRegistration;
import org.dmd.dmp.server.servlet.base.cache.NameGeneratorIF;
import org.dmd.dmp.server.servlet.base.interfaces.DmpRequestProcessorIF;
import org.dmd.dmp.server.servlet.base.interfaces.RequestTrackerIF;
import org.dmd.dmp.shared.generated.enums.DMPEventTypeEnum;
import org.dmd.dms.generated.types.DmcTypeModifierMV;
import org.dmd.dmw.DmwHierarchicObjectWrapper;
import org.dmd.dmw.DmwNamedObjectIndexer;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.dmw.DmwOmni;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCachePlugin
extends DmpServletPlugin
implements CacheIF,
Runnable,
DmcUncheckedOIFHandlerIF,
DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF {
    static String PERSISTENCE_FILE = "persistedObjects.oif";
    private long nextListenerId = 1L;
    TreeMap<DmcObjectName, DmwNamedObjectWrapper> theCache;
    private DmwNamedObjectIndexer indexer = new DmwNamedObjectIndexer();
    private LinkedBlockingQueue<DMPMessage> inputQueue;
    private DmcUncheckedOIFParser parser;
    private DmwObjectFactory factory;
    private RequestTrackerIF requestTracker;
    private CacheListenerManager listenerManager = new CacheListenerManager();
    private HashMap<DmcClassInfo, NameGeneratorIF> nameGenerators = new HashMap();
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    Thread ourThread;

    @Override
    public void preInit() throws ResultException, DmcValueException {
        DmcOmni.instance().backRefTracking(true);
    }

    @Override
    protected void init() throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.theCache = new TreeMap();
        this.inputQueue = new LinkedBlockingQueue();
        this.parser = new DmcUncheckedOIFParser((DmcUncheckedOIFHandlerIF)this);
        this.factory = new DmwObjectFactory(DmwOmni.instance().getSchema());
        this.requestTracker = this.pluginManager.getRequestTracker();
        this.requestTracker.bindRequestProcessor(SetRequest.class, new DmpRequestProcessorIF(){

            @Override
            public void processRequest(Request request) {
                BasicCachePlugin.this.queueSetRequest((SetRequest)request);
            }

            @Override
            public boolean acceptRequest(Request request) {
                return true;
            }
        });
        this.requestTracker.bindRequestProcessor(CreateRequest.class, new DmpRequestProcessorIF(){

            @Override
            public void processRequest(Request request) {
                BasicCachePlugin.this.queueCreateRequest((CreateRequest)request);
            }

            @Override
            public boolean acceptRequest(Request request) {
                return true;
            }
        });
        this.requestTracker.bindRequestProcessor(DeleteRequest.class, new DmpRequestProcessorIF(){

            @Override
            public void processRequest(Request request) {
                BasicCachePlugin.this.queueDeleteRequest((DeleteRequest)request);
            }

            @Override
            public boolean acceptRequest(Request request) {
                return true;
            }
        });
        this.loadPersistedObjects();
    }

    @Override
    public void start() throws ResultException, DmcValueException {
        this.ourThread = new Thread(this);
        this.ourThread.start();
    }

    @Override
    public void shutdown() {
        this.ourThread.interrupt();
    }

    void loadPersistedObjects() throws ResultException, DmcRuleExceptionSet, DmcNameClashException {
        File persisted = new File(PERSISTENCE_FILE);
        try {
            if (persisted.exists()) {
                this.parser.parseFile(PERSISTENCE_FILE);
            } else {
                persisted.createNewFile();
            }
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            DMPMessage message = null;
            try {
                message = this.inputQueue.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (message instanceof SetRequest) {
                this.processSetRequest((SetRequest)message);
                continue;
            }
            if (message instanceof CreateRequest) {
                this.processCreateRequest((CreateRequest)message);
                continue;
            }
            if (message instanceof DeleteRequest) {
                this.processDeleteRequest((DeleteRequest)message);
                continue;
            }
            if (!(message instanceof DMPEvent)) continue;
            this.logger.error("We aren't handling foreign events for processing.\n\n" + ((DMPEvent)message).toOIF());
        }
    }

    protected void processSetRequest(SetRequest request) {
        DmwNamedObjectWrapper wrapper;
        SetResponse response = null;
        DMPEvent event = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Processing set request for: " + request.getTarget().getKeyAsString());
        }
        if ((wrapper = this.theCache.get(request.getTarget().getName())) == null) {
            response = (SetResponse)request.getErrorResponse();
            response.setResponseText("Could not find object to modify: " + request.getTarget().getKeyAsString());
        } else {
            try {
                if (wrapper.applyModifier(request.getModifyAttribute())) {
                    event = this.createModifyEvent(request, wrapper);
                }
                response = request.getResponse();
                response.setLastResponse(Boolean.valueOf(true));
            }
            catch (Exception e) {
                response = (SetResponse)request.getErrorResponse();
                response.setResponseText("Modification failed for object: " + request.getTarget().getKeyAsString() + "\n" + e.toString());
                this.logger.error("Modification failed for object: " + request.getTarget().getKeyAsString() + "\n" + e.toString());
            }
        }
        this.requestTracker.processResponse((Response)response);
        if (event != null) {
            this.forwardEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCreateRequest(CreateRequest request) {
        CreateResponse response = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Processing create request for: " + request.getNewObject().getConstructionClassName());
        }
        DmwNamedObjectWrapper wrapper = null;
        try {
            wrapper = (DmwNamedObjectWrapper)request.getNewObjectWrapped();
        }
        catch (DmcNameClashException | DmcValueException e1) {
            e1.printStackTrace();
        }
        if (wrapper.getObjectName() == null) {
            HashMap<DmcClassInfo, NameGeneratorIF> e1 = this.nameGenerators;
            synchronized (e1) {
                NameGeneratorIF ng = this.nameGenerators.get(wrapper.getConstructionClassInfo());
                if (ng == null) {
                    response = (CreateResponse)request.getErrorResponse();
                    response.setResponseText("Null object name and no name generator was available for objects of type: " + wrapper.getConstructionClassName());
                    this.requestTracker.processResponse((Response)response);
                    return;
                }
                ng.createNameForObject(wrapper);
            }
        }
        try {
            wrapper.resolveReferences((DmcNameResolverWithClashSupportIF)this, (DmcNameClashResolverIF)this);
        }
        catch (DmcValueExceptionSet e) {
            response = (CreateResponse)request.getErrorResponse();
            response.setResponseText(e.toString());
            this.requestTracker.processResponse((Response)response);
            return;
        }
        response = this.addAndComplainIfNeeded(request, wrapper);
        if (response != null) {
            this.requestTracker.processResponse((Response)response);
            return;
        }
        response = request.getResponse();
        response.addObjectList(wrapper.getDmcObject());
        response.setLastResponse(Boolean.valueOf(true));
        this.requestTracker.processResponse((Response)response);
        this.sendEvent(DMPEventTypeEnum.CREATED, wrapper, request.getOriginatorID(), request.isTrackingEnabled(), request.isNotifyOriginator());
    }

    private CreateResponse addAndComplainIfNeeded(CreateRequest request, DmwNamedObjectWrapper wrapper) {
        CreateResponse response = null;
        try {
            this.addObject(wrapper);
        }
        catch (ResultException e) {
            this.logger.error(e.toString());
            response = (CreateResponse)request.getErrorResponse();
            response.setResponseText(e.toString());
        }
        return response;
    }

    protected void processDeleteRequest(DeleteRequest request) {
        LinkedList<DMPEvent> events = new LinkedList<DMPEvent>();
        StringBuffer errors = null;
        for (NameContainer container : request.getTargetsIterable()) {
            DmwNamedObjectWrapper wrapper = this._delete(container.getName());
            if (wrapper == null) {
                if (errors == null) {
                    errors = new StringBuffer();
                    errors.append(container.getName().getNameString());
                    continue;
                }
                errors.append(", " + container.getName().getNameString());
                continue;
            }
            events.add(this.createEvent(DMPEventTypeEnum.DELETED, wrapper, request.getOriginatorID(), request.isTrackingEnabled(), request.isNotifyOriginator()));
        }
        DeleteResponse response = null;
        if (errors == null) {
            response = request.getResponse();
        } else {
            this.logger.error("Could not delete: " + errors.toString());
            response = (DeleteResponse)request.getErrorResponse();
            response.setResponseText("Could not delete: " + errors.toString());
        }
        this.requestTracker.processResponse((Response)response);
        for (DMPEvent event : events) {
            this.forwardEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DmwNamedObjectWrapper _delete(DmcObjectName name) {
        TreeMap<DmcObjectName, DmwNamedObjectWrapper> treeMap = this.theCache;
        synchronized (treeMap) {
            DmwNamedObjectWrapper wrapper = this.theCache.remove(name);
            if (wrapper != null) {
                DmwHierarchicObjectWrapper hwrapper;
                this.indexer.deleteFromIndices(wrapper);
                if (name instanceof DmcHierarchicObjectName && (hwrapper = (DmwHierarchicObjectWrapper)wrapper).getParentComponent() != null) {
                    hwrapper.getParentComponent().removeSubcomponent(hwrapper);
                }
                wrapper.youAreDeleted();
            }
            return wrapper;
        }
    }

    private DMPEvent createEvent(DMPEventTypeEnum type, DmwNamedObjectWrapper wrapper, Integer originatorID, boolean track, boolean notifyOriginator) {
        DMPEvent event = new DMPEvent(type, (DmwWrapper)wrapper);
        if (originatorID != null) {
            event.setOriginatorID(originatorID);
        }
        event.setNotifyOriginator(Boolean.valueOf(notifyOriginator));
        event.setTrackingEnabled(Boolean.valueOf(track));
        return event;
    }

    private DMPEvent createModifyEvent(SetRequest request, DmwNamedObjectWrapper wrapper) {
        DMPEvent event = new DMPEvent(request);
        if (request.getOriginatorID() != null) {
            event.setOriginatorID(request.getOriginatorID());
        }
        event.setNotifyOriginator(request.isNotifyOriginator());
        event.setTrackingEnabled(request.isTrackingEnabled());
        event.setSourceObjectClass(wrapper.getConstructionClass());
        return event;
    }

    private void sendEvent(DMPEventTypeEnum type, DmwNamedObjectWrapper wrapper, Integer originatorID, boolean track, boolean notifyOriginator) {
        DMPEvent event = new DMPEvent(type, (DmwWrapper)wrapper);
        if (originatorID != null) {
            event.setOriginatorID(originatorID);
        }
        event.setNotifyOriginator(Boolean.valueOf(notifyOriginator));
        event.setTrackingEnabled(Boolean.valueOf(track));
        this.forwardEvent(event);
    }

    private void forwardEvent(DMPEvent event) {
        for (CacheListener listener : this.listenerManager.getInterestedListeners(event)) {
            listener.processCacheEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObject(DmwNamedObjectWrapper obj) throws ResultException {
        TreeMap<DmcObjectName, DmwNamedObjectWrapper> treeMap = this.theCache;
        synchronized (treeMap) {
            DmcHierarchicObjectName hon;
            DmcHierarchicObjectName pn;
            DmwNamedObjectWrapper existing = this.theCache.get(obj.getObjectName());
            if (existing != null) {
                ResultException ex = new ResultException();
                ex.addError("Duplicate object name: " + obj.getObjectName());
                ex.result.lastResult().moreMessages("Existing:\n" + existing.toOIF());
                ex.result.lastResult().moreMessages("New:\n" + obj.toOIF());
                throw ex;
            }
            if (obj.getConstructionClass().getIsNamedBy().getType().getIsHierarchicName().booleanValue() && (pn = (hon = ((DmwHierarchicObjectWrapper)obj).getObjectName()).getParentName()) != null) {
                DmwHierarchicObjectWrapper po = (DmwHierarchicObjectWrapper)this.theCache.get(pn);
                if (po == null) {
                    ResultException ex = new ResultException();
                    ex.addError("Could not find parent object: " + po + " for object: " + hon);
                    throw ex;
                }
                if (obj.getConstructionClass().allowsParent(po.getConstructionClass())) {
                    po.addSubComponent((DmwHierarchicObjectWrapper)obj);
                } else {
                    ResultException ex = new ResultException();
                    ex.addError("Object of class: " + po.getConstructionClassName() + " is not a valid parent for object of class: " + obj.getConstructionClassName());
                    throw ex;
                }
            }
            this.theCache.put(obj.getObjectName(), obj);
            this.indexer.addToIndices(obj);
        }
    }

    @Override
    public void dumpObjects(PrintStream ps) {
        for (DmwNamedObjectWrapper obj : this.theCache.values()) {
            ps.println(obj.toOIF());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmwNamedObjectWrapper get(DmcObjectName name) {
        TreeMap<DmcObjectName, DmwNamedObjectWrapper> treeMap = this.theCache;
        synchronized (treeMap) {
            return this.theCache.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DmwHierarchicObjectWrapper> getNext(DmcHierarchicObjectName name) {
        TreeMap<DmcObjectName, DmwNamedObjectWrapper> treeMap = this.theCache;
        synchronized (treeMap) {
            DmwHierarchicObjectWrapper root = (DmwHierarchicObjectWrapper)this.theCache.get(name);
            if (root == null) {
                return null;
            }
            return root.getSubComps();
        }
    }

    @Override
    public Collection<DmwHierarchicObjectWrapper> getAll(DmcHierarchicObjectName name) {
        TreeMap<DmcObjectName, DmwNamedObjectWrapper> treeMap = this.theCache;
        synchronized (treeMap) {
            throw new IllegalStateException("Not implemented yet");
        }
    }

    @Override
    public void create(DmwNamedObjectWrapper obj, Request request) {
    }

    @Override
    public void createAndNotify(DmwNamedObjectWrapper obj) {
    }

    @Override
    public void delete(DmwNamedObjectWrapper obj) {
    }

    @Override
    public void delete(DmcObjectName name, Request request) throws ResultException {
    }

    @Override
    public void deleteAndNotify(DmwNamedObjectWrapper obj) {
    }

    @Override
    public void deleteAndNotify(DmcObjectName name) {
    }

    @Override
    public void set(DmwNamedObjectWrapper obj) {
    }

    @Override
    public void setAndNotify(DmwNamedObjectWrapper obj) {
    }

    @Override
    public void set(DmcObjectName name, DmcTypeModifierMV modifier, Request request) throws ResultException {
    }

    @Override
    public void maintainIndex(DmcClassInfo ci) {
        this.indexer.maintainIndex(ci);
    }

    @Override
    public boolean hasIndex(DmcClassInfo dci) {
        return this.indexer.hasIndex(dci);
    }

    @Override
    public int getIndexSize(DmcClassInfo ci) {
        return this.indexer.getIndexSize(ci);
    }

    @Override
    public Collection<DmwNamedObjectWrapper> getIndex(DmcClassInfo ci) {
        return this.indexer.getIndex(ci);
    }

    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException {
        DmwNamedObjectWrapper wrapper = null;
        try {
            wrapper = (DmwNamedObjectWrapper)this.factory.createWrapper(uco);
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + (String)uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ResultException ex) {
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (DmcValueException e) {
            ResultException ex = new ResultException();
            ex.addError(e.getMessage());
            if (e.getAttributeName() != null) {
                ex.result.lastResult().moreMessages("Attribute: " + e.getAttributeName());
            }
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (DmcNameClashException e) {
            ResultException ex = new ResultException();
            ex.addError(e.getMessage());
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        this.addObject(wrapper);
    }

    @Override
    public CacheRegistration register(SessionIF session) {
        return new CacheRegistration(this, session);
    }

    public DmcObject findNamedDMO(DmcObjectName name) {
        DmcObject rc = null;
        DmwNamedObjectWrapper wrapper = this.theCache.get(name);
        rc = wrapper == null ? DmwOmni.instance().findNamedDMO(name) : wrapper.getDmcObject();
        return rc;
    }

    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DmcNamedObjectIF rc = (DmcNamedObjectIF)this.theCache.get(name);
        if (rc == null) {
            rc = DmwOmni.instance().findNamedObject(name);
        }
        return rc;
    }

    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        return this.findNamedObject(name);
    }

    @Override
    public void queueSetRequest(SetRequest request) {
        this.addToQueue((DMPMessage)request);
    }

    @Override
    public void queueCreateRequest(CreateRequest request) {
        this.addToQueue((DMPMessage)request);
    }

    @Override
    public void queueDeleteRequest(DeleteRequest request) {
        this.addToQueue((DMPMessage)request);
    }

    @Override
    public void queueEvent(DMPEvent event) {
        this.addToQueue((DMPMessage)event);
    }

    private void addToQueue(DMPMessage msg) {
        try {
            this.inputQueue.put(msg);
        }
        catch (Exception e) {
            this.logger.error("Caught Exception", (Throwable)e);
        }
    }

    @Override
    public long getNextListenerID() {
        return this.nextListenerId++;
    }

    @Override
    public Collection<DmwNamedObjectWrapper> addListener(CacheListener listener) {
        this.listenerManager.addListener(listener);
        if (listener instanceof CacheIndexListener) {
            CacheIndexListener cil = (CacheIndexListener)listener;
            return this.indexer.getIndex(cil.getClassInfo());
        }
        throw new IllegalStateException("Unknown cache listener type: " + listener.getClass().getName());
    }

    @Override
    public void removeListener(CacheListener listener) {
        this.listenerManager.removeListener(listener);
    }

    @Override
    public void addNameGenerator(NameGeneratorIF ng) {
        if (this.nameGenerators.get(ng.usedForClass()) == null) {
            this.nameGenerators.put(ng.usedForClass(), ng);
            return;
        }
        throw new IllegalStateException("Multiple name generators registered for class: " + ng.usedForClass().name);
    }

    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        DmcNamedObjectIF rc = null;
        DmwNamedObjectWrapper obj = this.theCache.get(name);
        if (obj == null) {
            rc = DmwOmni.instance().getSchema().findNamedObjectMayClash(object, name, resolver, ai);
        }
        return rc;
    }

    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        throw new IllegalStateException("NOT IMPLEMENTED");
    }

    @Override
    public void removeListenersForSession(SessionIF session) {
        this.listenerManager.removeListenersForSession(session);
    }
}

