/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base.plugins;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.dmd.dmp.server.extended.Request;
import org.dmd.dmp.server.extended.Response;
import org.dmd.dmp.server.servlet.base.DmpServletPlugin;
import org.dmd.dmp.server.servlet.base.interfaces.DmpRequestProcessorIF;
import org.dmd.dmp.server.servlet.base.interfaces.DmpResponseHandlerIF;
import org.dmd.dmp.server.servlet.base.interfaces.RequestTrackerIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRequestTrackerPlugin
extends DmpServletPlugin
implements RequestTrackerIF {
    private SynchResponseHandler synchResponseHandler = new SynchResponseHandler();
    private HashMap<Class<? extends Request>, LinkedList<DmpRequestProcessorIF>> requestProcessors = new HashMap();
    private DmpRequestProcessorIF defaultRequestHandler;
    private int nextRequestId = 1;
    private HashMap<Integer, RequestInfo> outstandingRequests = new HashMap();
    private HashMap<Integer, Response> pendingResponses = new HashMap();
    private Timer timer = new Timer();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public BasicRequestTrackerPlugin() {
        this.timer.schedule((TimerTask)new RequestTimeoutProcessor(), 1000L, 1000L);
    }

    @Override
    public void bindDefaultRequestHandler(DmpRequestProcessorIF requestHandler) {
        this.defaultRequestHandler = requestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindRequestProcessor(Class<? extends Request> clazz, DmpRequestProcessorIF requestProcessor) {
        HashMap<Class<? extends Request>, LinkedList<DmpRequestProcessorIF>> hashMap = this.requestProcessors;
        synchronized (hashMap) {
            LinkedList<DmpRequestProcessorIF> procList = this.requestProcessors.get(clazz);
            if (procList == null) {
                procList = new LinkedList();
                this.requestProcessors.put(clazz, procList);
            }
            procList.add(requestProcessor);
        }
    }

    @Override
    public int processRequest(Request req, DmpResponseHandlerIF responseHandler) {
        return this.processRequest(req, responseHandler, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processSynchronousRequest(Request req, DmpResponseHandlerIF asyncResponseHandler, int timeoutSeconds) {
        Request request = req;
        synchronized (request) {
            this.processRequest(req, this.synchResponseHandler, asyncResponseHandler, timeoutSeconds);
            try {
                req.wait();
            }
            catch (Exception e) {
                this.logger.error("Caught exception", (Throwable)e);
                return null;
            }
            return this.pendingResponses.remove(req.getLastRequestID());
        }
    }

    @Override
    public int processRequest(Request req, DmpResponseHandlerIF responseHandler, int timeoutSeconds) {
        return this.processRequest(req, responseHandler, responseHandler, timeoutSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(Response resp) {
        if (resp.getRequestIDSize() == 0) {
            this.logger.debug("Got Response with no id: " + resp.toOIF());
            return;
        }
        int requestId = -1;
        if (resp.getRequestIDSize() == 1) {
            this.logger.debug("Just one request ID");
            requestId = resp.getLastRequestID();
        } else {
            this.logger.debug("Multiple request IDs");
            requestId = resp.removeLastRequestID();
        }
        this.logger.debug("Handling response for tracking ID: " + requestId);
        DmpResponseHandlerIF responseHandler = null;
        RequestInfo ri = null;
        HashMap<Integer, RequestInfo> hashMap = this.outstandingRequests;
        synchronized (hashMap) {
            this.logger.debug("Handling response: \n" + resp.toOIF());
            if (resp.isLastResponse().booleanValue()) {
                this.logger.debug("Last response - removing outstanding request for requestId: " + requestId);
                ri = this.outstandingRequests.remove(requestId);
            } else {
                this.logger.debug("More responses expected for requestId: " + requestId);
                ri = this.outstandingRequests.get(requestId);
            }
            if (ri == null) {
                this.logger.error("No record of request for " + resp.toOIF());
                this.logger.error("Did you accidentally send the same response twice?");
                return;
            }
            responseHandler = ri.responseHandler;
            if (ri.responseHandler == ri.firstResponseHandler) {
                ri.responseHandler = ri.asyncResponseHandler;
            }
            ri.resetTimeout();
        }
        responseHandler.handleResponse(ri.req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processRequest(Request req, DmpResponseHandlerIF firstResponseHandler, DmpResponseHandlerIF asyncResponseHandler, int timeoutSeconds) {
        DmpRequestProcessorIF requestProcessor = this.defaultRequestHandler;
        HashMap<Class<? extends Request>, LinkedList<DmpRequestProcessorIF>> hashMap = this.requestProcessors;
        synchronized (hashMap) {
            LinkedList<DmpRequestProcessorIF> procList = this.requestProcessors.get(req.getClass());
            if (procList != null) {
                for (DmpRequestProcessorIF processor : procList) {
                    if (!processor.acceptRequest(req)) continue;
                    requestProcessor = processor;
                }
                if (requestProcessor == this.defaultRequestHandler) {
                    this.logger.debug("None of the request processors bound for " + req.getClass().getSimpleName() + " accepted the request");
                }
            }
        }
        if (requestProcessor == null) {
            return -1;
        }
        return this.trackRequest(req, firstResponseHandler, asyncResponseHandler, timeoutSeconds, requestProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int trackRequest(Request req, DmpResponseHandlerIF firstResponseHandler, DmpResponseHandlerIF asyncResponseHandler, int timeoutSeconds, DmpRequestProcessorIF requestProcessor) {
        this.logger.debug("Tracking " + req.getConstructionClassName());
        HashMap<Integer, RequestInfo> hashMap = this.outstandingRequests;
        synchronized (hashMap) {
            ++this.nextRequestId;
            this.logger.debug("Tracking " + req.getConstructionClassName() + " request with tracking ID " + this.nextRequestId);
            req.addRequestID(Integer.valueOf(this.nextRequestId));
            req.setTimeMS(Long.valueOf(System.currentTimeMillis()));
            this.outstandingRequests.put(this.nextRequestId, new RequestInfo(req, firstResponseHandler, asyncResponseHandler, timeoutSeconds));
        }
        requestProcessor.processRequest(req);
        return req.getLastRequestID();
    }

    private class SynchResponseHandler
    implements DmpResponseHandlerIF {
        private SynchResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(Request req, Response resp) {
            Request request = req;
            synchronized (request) {
                BasicRequestTrackerPlugin.this.pendingResponses.put(req.getLastRequestID(), resp);
                req.notify();
            }
        }
    }

    private class RequestTimeoutProcessor
    extends TimerTask {
        private RequestTimeoutProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap hashMap = BasicRequestTrackerPlugin.this.outstandingRequests;
            synchronized (hashMap) {
                long currentTime = System.currentTimeMillis();
                LinkedList entries = new LinkedList(BasicRequestTrackerPlugin.this.outstandingRequests.entrySet());
                for (Map.Entry entry : entries) {
                    RequestInfo ri = (RequestInfo)entry.getValue();
                    if (currentTime < ri.timeoutTime) continue;
                    Response resp = ri.req.getErrorResponse();
                    resp.setResponseText("Request Timed Out");
                    BasicRequestTrackerPlugin.this.processResponse(resp);
                }
            }
        }
    }

    private class RequestInfo {
        Request req;
        DmpResponseHandlerIF firstResponseHandler;
        DmpResponseHandlerIF asyncResponseHandler;
        DmpResponseHandlerIF responseHandler;
        long timeoutTime;
        long timeoutSeconds;

        RequestInfo(Request req, DmpResponseHandlerIF firstResponseHandler, DmpResponseHandlerIF asyncResponseHandler, long timeoutSeconds) {
            this.req = req;
            this.firstResponseHandler = firstResponseHandler;
            this.asyncResponseHandler = asyncResponseHandler;
            this.responseHandler = firstResponseHandler;
            this.timeoutSeconds = timeoutSeconds;
            this.timeoutTime = System.currentTimeMillis() + 1000L * timeoutSeconds;
        }

        void resetTimeout() {
            this.timeoutTime = System.currentTimeMillis() + 1000L * this.timeoutSeconds;
        }
    }
}

