/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.base.plugins;

import java.util.HashMap;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DotName;
import org.dmd.dmp.server.extended.LoginRequest;
import org.dmd.dmp.server.extended.LoginResponse;
import org.dmd.dmp.server.extended.LogoutRequest;
import org.dmd.dmp.server.extended.LogoutResponse;
import org.dmd.dmp.server.extended.Request;
import org.dmd.dmp.server.extended.Response;
import org.dmd.dmp.server.servlet.base.DmpServletPlugin;
import org.dmd.dmp.server.servlet.base.interfaces.SecurityManagerIF;
import org.dmd.dmp.server.servlet.extended.SessionRI;
import org.dmd.dmp.server.servlet.generated.dmo.DmpServerDMSAG;
import org.dmd.dmp.server.servlet.generated.dmw.SessionFolderRIDMW;
import org.dmd.dmp.server.servlet.generated.dmw.UserFolderRIDMW;
import org.dmd.dmp.server.servlet.generated.dmw.UserRIDMW;
import org.dmd.dmp.shared.generated.enums.ResponseTypeEnum;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSecurityPlugin
extends DmpServletPlugin
implements SecurityManagerIF {
    HashMap<String, UserRIDMW> users;
    HashMap<String, SessionRI> sessions;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void preInit() {
        this.cache.maintainIndex(DmpServerDMSAG.__UserRI);
    }

    @Override
    public void init() throws ResultException, DmcValueException {
        this.users = new HashMap();
        this.sessions = new HashMap();
        UserFolderRIDMW uf = new UserFolderRIDMW();
        uf.setDotName(new DotName("uf"));
        this.cache.addObject((DmwNamedObjectWrapper)uf);
        UserRIDMW user1 = new UserRIDMW();
        user1.setDotName(new DotName("uf.1"));
        user1.setUserName("user1");
        user1.setPassword("user1");
        this.cache.addObject((DmwNamedObjectWrapper)user1);
        this.users.put(user1.getUserName(), user1);
        UserRIDMW user2 = new UserRIDMW();
        user2.setDotName(new DotName("uf.2"));
        user2.setUserName("user2");
        user2.setPassword("user2");
        this.cache.addObject((DmwNamedObjectWrapper)user2);
        this.users.put(user1.getUserName(), user1);
        SessionFolderRIDMW sf = new SessionFolderRIDMW();
        sf.setDotName(new DotName("sf"));
        this.cache.addObject((DmwNamedObjectWrapper)sf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginResponse login(LoginRequest request) {
        LoginResponse response = request.getResponse();
        HashMap<String, SessionRI> hashMap = this.sessions;
        synchronized (hashMap) {
            UserRIDMW user = this.users.get(request.getUserName());
            if (user == null) {
                response.setResponseType(ResponseTypeEnum.ERROR);
                if (request.isTrackingEnabled().booleanValue()) {
                    this.logger.warn("Unknown user: " + request.getUserName());
                }
            } else if (!user.getPassword().equals(request.getPassword())) {
                response.setResponseType(ResponseTypeEnum.ERROR);
                if (request.isTrackingEnabled().booleanValue()) {
                    this.logger.warn("Incorrect password for user: " + request.getUserName());
                }
            } else {
                SessionRI session = new SessionRI(this.pluginManager.getCache(), this.pluginManager.getRequestTracker());
                try {
                    session.setDotName(new DotName("sf." + request.getServletRequest().getSession().getId()));
                }
                catch (DmcValueException e1) {
                    e1.printStackTrace();
                }
                session.setSessionIDRI(request.getServletRequest().getSession().getId());
                session.setSessionHostRI(request.getServletRequest().getRemoteHost());
                session.setUserRefRI(user);
                session.initializeEventChannel(this.servlet);
                this.sessions.put(session.getSessionIDRI(), session);
                this.logger.debug("Session created:\n\n" + session.toOIF());
                response.setSessionID(session.getSessionIDRI());
                if (request.isTrackingEnabled().booleanValue()) {
                    this.logger.trace("New session created: " + session.getSessionIDRI() + " - for user: " + request.getUserName());
                }
                try {
                    this.cache.addObject((DmwNamedObjectWrapper)session);
                }
                catch (ResultException e) {
                    DebugInfo.debug((String)e.toString());
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogoutResponse logout(LogoutRequest request) {
        LogoutResponse response = request.getResponse();
        HashMap<String, SessionRI> hashMap = this.sessions;
        synchronized (hashMap) {
            SessionRI session = this.sessions.get(request.getSessionID());
            if (session == null) {
                response.setResponseType(ResponseTypeEnum.ERROR);
            } else {
                this.sessions.remove(session.getSessionIDRI());
                this.cache.removeListenersForSession(session);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response validateSession(Request request) throws DmcValueException {
        Response rc = null;
        HashMap<String, SessionRI> hashMap = this.sessions;
        synchronized (hashMap) {
            SessionRI session = this.sessions.get(request.getSessionID());
            if (request instanceof LoginRequest) {
                if (session != null) {
                    rc = request.getErrorResponse();
                    rc.setResponseText("User already logged in.");
                }
            } else if (session == null) {
                rc = request.getErrorResponse();
                rc.setResponseText("No existing session");
            }
        }
        return rc;
    }

    @Override
    public SessionRI getSession(Request request) {
        return this.sessions.get(request.getSessionID());
    }
}

