/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.dmpservletri;

import de.novanic.eventservice.service.RemoteEventServiceServlet;
import java.io.File;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmp.client.DMPService;
import org.dmd.dmp.server.extended.ActionCancelRequest;
import org.dmd.dmp.server.extended.ActionCancelResponse;
import org.dmd.dmp.server.extended.ActionRequest;
import org.dmd.dmp.server.extended.ActionResponse;
import org.dmd.dmp.server.extended.CreateRequest;
import org.dmd.dmp.server.extended.CreateResponse;
import org.dmd.dmp.server.extended.DeleteRequest;
import org.dmd.dmp.server.extended.DeleteResponse;
import org.dmd.dmp.server.extended.DenotifyRequest;
import org.dmd.dmp.server.extended.GetRequest;
import org.dmd.dmp.server.extended.GetResponse;
import org.dmd.dmp.server.extended.LoginRequest;
import org.dmd.dmp.server.extended.LogoutRequest;
import org.dmd.dmp.server.extended.LogoutResponse;
import org.dmd.dmp.server.extended.NotifyRequest;
import org.dmd.dmp.server.extended.PreAuthRequest;
import org.dmd.dmp.server.extended.Request;
import org.dmd.dmp.server.extended.SetRequest;
import org.dmd.dmp.server.extended.SetResponse;
import org.dmd.dmp.server.servlet.base.PluginManager;
import org.dmd.dmp.server.servlet.base.interfaces.SecurityManagerIF;
import org.dmd.dmp.server.servlet.extended.SessionRI;
import org.dmd.dmp.shared.generated.dmo.ActionCancelRequestDMO;
import org.dmd.dmp.shared.generated.dmo.ActionCancelResponseDMO;
import org.dmd.dmp.shared.generated.dmo.ActionRequestDMO;
import org.dmd.dmp.shared.generated.dmo.ActionResponseDMO;
import org.dmd.dmp.shared.generated.dmo.CreateRequestDMO;
import org.dmd.dmp.shared.generated.dmo.CreateResponseDMO;
import org.dmd.dmp.shared.generated.dmo.DeleteRequestDMO;
import org.dmd.dmp.shared.generated.dmo.DeleteResponseDMO;
import org.dmd.dmp.shared.generated.dmo.DenotifyRequestDMO;
import org.dmd.dmp.shared.generated.dmo.DenotifyResponseDMO;
import org.dmd.dmp.shared.generated.dmo.GetRequestDMO;
import org.dmd.dmp.shared.generated.dmo.GetResponseDMO;
import org.dmd.dmp.shared.generated.dmo.LoginRequestDMO;
import org.dmd.dmp.shared.generated.dmo.LoginResponseDMO;
import org.dmd.dmp.shared.generated.dmo.LogoutRequestDMO;
import org.dmd.dmp.shared.generated.dmo.LogoutResponseDMO;
import org.dmd.dmp.shared.generated.dmo.NotifyRequestDMO;
import org.dmd.dmp.shared.generated.dmo.NotifyResponseDMO;
import org.dmd.dmp.shared.generated.dmo.PreAuthRequestDMO;
import org.dmd.dmp.shared.generated.dmo.PreAuthResponseDMO;
import org.dmd.dmp.shared.generated.dmo.RequestDMO;
import org.dmd.dmp.shared.generated.dmo.ResponseDMO;
import org.dmd.dmp.shared.generated.dmo.SetRequestDMO;
import org.dmd.dmp.shared.generated.dmo.SetResponseDMO;
import org.dmd.dmp.shared.generated.enums.ResponseTypeEnum;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMPServiceImpl
extends RemoteEventServiceServlet
implements DMPService {
    PluginManager pluginManager;
    SecurityManagerIF securityManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void init() {
        try {
            this.pluginManager = new PluginManager(this);
            File here = new File(".");
            this.logger.debug("Running here: " + here.getAbsolutePath());
            this.pluginManager.loadPlugins("dmpServletPlugins.oif");
            this.pluginManager.preInit();
            this.pluginManager.init();
            this.pluginManager.start();
            this.securityManager = this.pluginManager.getSecurityManager();
        }
        catch (ResultException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        catch (DmcRuleExceptionSet e) {
            e.printStackTrace();
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.pluginManager.shutdown();
    }

    @Override
    public ActionResponseDMO action(ActionRequestDMO actionRequest) {
        ActionRequest request = new ActionRequest(actionRequest, this.getThreadLocalRequest());
        ActionResponse response = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        try {
            response = (ActionResponse)this.pluginManager.getSecurityManager().validateSession((Request)request);
            if (response == null) {
                SessionRI session = this.pluginManager.getSecurityManager().getSession((Request)request);
                response = session.handleActionRequest(request);
            }
        }
        catch (DmcValueException e) {
            response = request.getResponse();
            response.setResponseType(ResponseTypeEnum.ERROR);
            response.setResponseText(e.toString());
            e.printStackTrace();
        }
        return response.getDMO();
    }

    @Override
    public CreateResponseDMO create(CreateRequestDMO createRequest) {
        CreateRequest request = new CreateRequest(createRequest, this.getThreadLocalRequest());
        CreateResponse response = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        try {
            response = (CreateResponse)this.pluginManager.getSecurityManager().validateSession((Request)request);
            if (response == null) {
                SessionRI session = this.pluginManager.getSecurityManager().getSession((Request)request);
                response = session.handleCreateRequest(request);
            }
        }
        catch (DmcValueException e) {
            response = (CreateResponse)request.getErrorResponse();
            response.setResponseText(e.toString());
            e.printStackTrace();
        }
        return response.getDMO();
    }

    @Override
    public DeleteResponseDMO delete(DeleteRequestDMO deleteRequest) {
        DeleteRequest request = new DeleteRequest(deleteRequest, this.getThreadLocalRequest());
        DeleteResponse response = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        try {
            response = (DeleteResponse)this.pluginManager.getSecurityManager().validateSession((Request)request);
            if (response == null) {
                SessionRI session = this.pluginManager.getSecurityManager().getSession((Request)request);
                response = session.handleDeleteRequest(request);
            }
        }
        catch (DmcValueException e) {
            response = (DeleteResponse)request.getErrorResponse();
            response.setResponseText(e.toString());
            this.logger.error(e.toString());
        }
        return response.getDMO();
    }

    @Override
    public GetResponseDMO get(GetRequestDMO getRequest) {
        GetRequest request = new GetRequest(getRequest, this.getThreadLocalRequest());
        GetResponse response = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        try {
            response = (GetResponse)this.securityManager.validateSession((Request)request);
            if (response == null) {
                SessionRI session = this.securityManager.getSession((Request)request);
                response = session.handleGetRequest(request);
            }
        }
        catch (DmcValueException e) {
            response = (GetResponse)request.getErrorResponse();
            response.setResponseText(e.toString());
            this.logger.error(e.toString());
        }
        catch (Exception ex) {
            this.logger.error(DebugInfo.extractTheStack((Exception)ex));
            response = (GetResponse)request.getErrorResponse();
            response.setResponseText(DebugInfo.extractTheStack((Exception)ex));
        }
        this.logger.trace("Sending single response to original get request");
        return response.getDMO();
    }

    @Override
    public LoginResponseDMO login(LoginRequestDMO loginRequest) {
        LoginRequest request = new LoginRequest(loginRequest, this.getThreadLocalRequest());
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        return this.pluginManager.getSecurityManager().login(request).getDMO();
    }

    @Override
    public LogoutResponseDMO logout(LogoutRequestDMO logoutRequest) {
        LogoutRequest request = new LogoutRequest(logoutRequest, this.getThreadLocalRequest());
        LogoutResponse response = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        try {
            response = (LogoutResponse)this.securityManager.validateSession((Request)request);
            if (response == null) {
                response = this.securityManager.logout(request);
            }
        }
        catch (DmcValueException e) {
            response = (LogoutResponse)request.getErrorResponse();
            response.setResponseText(e.toString());
            this.logger.error(e.toString());
        }
        catch (Exception ex) {
            this.logger.error(DebugInfo.extractTheStack((Exception)ex));
            response = (LogoutResponse)request.getErrorResponse();
            response.setResponseText(DebugInfo.extractTheStack((Exception)ex));
        }
        return response.getDMO();
    }

    @Override
    public NotifyResponseDMO notify(NotifyRequestDMO notifyRequest) {
        NotifyRequest request = new NotifyRequest(notifyRequest, this.getThreadLocalRequest());
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        return null;
    }

    @Override
    public SetResponseDMO set(SetRequestDMO setRequest) {
        SetRequest request = new SetRequest(setRequest, this.getThreadLocalRequest());
        SetResponse response = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        if (request.getModifyIsEmpty()) {
            response = (SetResponse)request.getErrorResponse();
            response.setResponseText("No modifications were found in the SetRequest");
        } else {
            try {
                response = (SetResponse)this.pluginManager.getSecurityManager().validateSession((Request)request);
                if (response == null) {
                    SessionRI session = this.pluginManager.getSecurityManager().getSession((Request)request);
                    response = session.handleSetRequest(request);
                }
            }
            catch (DmcValueException e) {
                response = (SetResponse)request.getErrorResponse();
                response.setResponseText(e.toString());
                this.logger.error(e.toString());
            }
        }
        return response.getDMO();
    }

    @Override
    public DenotifyResponseDMO denotify(DenotifyRequestDMO notifyRequest) {
        DenotifyRequest request = new DenotifyRequest(notifyRequest, this.getThreadLocalRequest());
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        return null;
    }

    @Override
    public ResponseDMO otherRequest(RequestDMO request) {
        return null;
    }

    @Override
    public PreAuthResponseDMO preauth(PreAuthRequestDMO preAuthRequest) {
        PreAuthRequest request = new PreAuthRequest(preAuthRequest, this.getThreadLocalRequest());
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        return null;
    }

    @Override
    public ActionCancelResponseDMO actionCancel(ActionCancelRequestDMO actionCancelRequest) {
        ActionCancelRequest request = new ActionCancelRequest(actionCancelRequest, this.getThreadLocalRequest());
        ActionCancelResponse response = null;
        if (request.isTrackingEnabled().booleanValue()) {
            this.logger.trace("Received by DMP servlet:\n" + request.toOIF());
        }
        try {
            response = (ActionCancelResponse)this.pluginManager.getSecurityManager().validateSession((Request)request);
            if (response == null) {
                SessionRI session = this.pluginManager.getSecurityManager().getSession((Request)request);
                response = session.handleActionCancelRequest(request);
            }
        }
        catch (DmcValueException e) {
            response = request.getResponse();
            response.setResponseType(ResponseTypeEnum.ERROR);
            response.setResponseText(e.toString());
            e.printStackTrace();
        }
        return response.getDMO();
    }
}

