/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.extended;

import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.domain.DomainFactory;
import de.novanic.eventservice.service.RemoteEventServiceServlet;
import java.util.Timer;
import java.util.TimerTask;
import org.dmd.dmp.server.DmpPipeIF;
import org.dmd.dmp.server.extended.ActionCancelRequest;
import org.dmd.dmp.server.extended.ActionCancelResponse;
import org.dmd.dmp.server.extended.ActionRequest;
import org.dmd.dmp.server.extended.ActionResponse;
import org.dmd.dmp.server.extended.CreateRequest;
import org.dmd.dmp.server.extended.CreateResponse;
import org.dmd.dmp.server.extended.DMPEvent;
import org.dmd.dmp.server.extended.DMPMessage;
import org.dmd.dmp.server.extended.DeleteRequest;
import org.dmd.dmp.server.extended.DeleteResponse;
import org.dmd.dmp.server.extended.GetRequest;
import org.dmd.dmp.server.extended.GetResponse;
import org.dmd.dmp.server.extended.Request;
import org.dmd.dmp.server.extended.Response;
import org.dmd.dmp.server.extended.SetRequest;
import org.dmd.dmp.server.extended.SetResponse;
import org.dmd.dmp.server.generated.DmpSchemaAG;
import org.dmd.dmp.server.servlet.base.GetRequestProcessor;
import org.dmd.dmp.server.servlet.base.SessionIF;
import org.dmd.dmp.server.servlet.base.cache.CacheIF;
import org.dmd.dmp.server.servlet.base.cache.CacheRegistration;
import org.dmd.dmp.server.servlet.base.interfaces.DmpEventHandlerIF;
import org.dmd.dmp.server.servlet.base.interfaces.DmpResponseHandlerIF;
import org.dmd.dmp.server.servlet.base.interfaces.RequestTrackerIF;
import org.dmd.dmp.server.servlet.generated.dmw.SessionRIDMW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionRI
extends SessionRIDMW
implements DmpResponseHandlerIF,
DmpPipeIF,
DmpEventHandlerIF,
SessionIF {
    RemoteEventServiceServlet eventChannel;
    Domain domain;
    CacheRegistration cacheRegistration;
    GetRequestProcessor getRequestProcessor;
    private RequestTrackerIF requestTracker;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SessionRI() {
    }

    public SessionRI(CacheIF c, RequestTrackerIF rt) {
        this.cacheRegistration = c.register(this);
        this.getRequestProcessor = new GetRequestProcessor(this, this.cacheRegistration);
        this.requestTracker = rt;
    }

    public void initializeEventChannel(RemoteEventServiceServlet s) {
        this.eventChannel = s;
        this.domain = DomainFactory.getDomain((String)this.getSessionIDRI());
    }

    public int getOriginatorID() {
        return this.cacheRegistration.getID();
    }

    @Override
    public void handleResponse(Request request, Response response) {
        this.eventChannel.addEvent(this.domain, (Event)response.getDMO());
    }

    public GetResponse handleGetRequest(GetRequest request) {
        GetResponse rc = request.getResponse();
        rc.setLastResponse(Boolean.valueOf(false));
        request.setOriginatorID(Integer.valueOf(this.cacheRegistration.getID()));
        this.logger.trace("Passing request to get processor");
        this.getRequestProcessor.processRequest(request);
        this.logger.trace("Get processor has returned");
        return rc;
    }

    public SetResponse handleSetRequest(SetRequest request) {
        request.setOriginatorID(Integer.valueOf(this.cacheRegistration.getID()));
        SetResponse rc = request.getResponse();
        rc.setLastResponse(Boolean.valueOf(false));
        this.requestTracker.processRequest((Request)request, this);
        return rc;
    }

    public CreateResponse handleCreateRequest(CreateRequest request) {
        request.setOriginatorID(Integer.valueOf(this.cacheRegistration.getID()));
        CreateResponse rc = request.getResponse();
        rc.setLastResponse(Boolean.valueOf(false));
        this.requestTracker.processRequest((Request)request, this);
        this.logger.debug("Sending synchronous response for CreateRequest: " + rc);
        return rc;
    }

    public DeleteResponse handleDeleteRequest(DeleteRequest request) {
        request.setOriginatorID(Integer.valueOf(this.cacheRegistration.getID()));
        DeleteResponse rc = request.getResponse();
        rc.setLastResponse(Boolean.valueOf(false));
        this.requestTracker.processRequest((Request)request, this);
        return rc;
    }

    public ActionResponse handleActionRequest(ActionRequest request) {
        ActionResponse rc = null;
        request.setOriginatorID(Integer.valueOf(this.cacheRegistration.getID()));
        if (request.getActionName().equals(DmpSchemaAG._primeEventChannel.getName().getNameString())) {
            this.logger.debug("Received asynch priming request...");
            final ActionRequest primeRequest = request;
            rc = request.getResponse();
            rc.setLastResponse(Boolean.valueOf(false));
            Timer timer = new Timer(){};
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SessionRI.this.logger.debug("Sending asynch priming response...");
                    ActionResponse response = primeRequest.getResponse();
                    response.setLastResponse(Boolean.valueOf(true));
                    SessionRI.this.sendMessage((DMPMessage)response);
                }
            }, 300L);
            this.logger.debug("Sending synchronous priming response...");
        } else {
            rc = request.getResponse();
            rc.setLastResponse(Boolean.valueOf(false));
            if (request.getTimeoutSeconds() == null) {
                this.requestTracker.processRequest((Request)request, this);
            } else {
                this.requestTracker.processRequest((Request)request, this, request.getTimeoutSeconds());
            }
        }
        return rc;
    }

    public ActionCancelResponse handleActionCancelRequest(ActionCancelRequest request) {
        request.setOriginatorID(Integer.valueOf(this.cacheRegistration.getID()));
        ActionCancelResponse rc = request.getResponse();
        rc.setLastResponse(Boolean.valueOf(false));
        this.requestTracker.processRequest((Request)request, this);
        return rc;
    }

    public void sendMessage(DMPMessage msg) {
        this.logger.trace("Sending message...");
        this.eventChannel.addEvent(this.domain, (Event)msg.getDMO());
    }

    public String getName() {
        return this.getSessionIDRI();
    }

    @Override
    public void handleEvent(DMPEvent event) {
        this.logger.trace("Sending event...");
        this.eventChannel.addEvent(this.domain, (Event)event.getDMO());
    }

    @Override
    public String sessionID() {
        return this.getSessionIDRI();
    }
}

