/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.dmp.server.servlet.generated.types.DmcTypePluginConfigREF;
import org.dmd.dmp.server.servlet.generated.types.PluginConfigREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypePluginConfigREFMAP
extends DmcTypePluginConfigREF
implements Serializable {
    private static final Iterator<PluginConfigREF> emptyList = new HashMap().values().iterator();
    protected Map<CamelCaseName, PluginConfigREF> value;

    public DmcTypePluginConfigREFMAP() {
        this.value = null;
    }

    public DmcTypePluginConfigREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<CamelCaseName, PluginConfigREF>() : new TreeMap<CamelCaseName, PluginConfigREF>();
    }

    public CamelCaseName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (CamelCaseName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypePluginConfigREFMAP getNew() {
        return new DmcTypePluginConfigREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<PluginConfigREF> cloneIt() {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            DmcTypePluginConfigREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PluginConfigREF val : this.value.values()) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginConfigREF add(Object v) throws DmcValueException {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            CamelCaseName key;
            PluginConfigREF oldval;
            PluginConfigREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (CamelCaseName)newval.getKey(), newval)) != null && oldval.valuesAreEqual((DmcMappedAttributeIF)newval)) {
                newval = null;
            }
            return newval;
        }
    }

    public PluginConfigREF del(Object key) {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof CamelCaseName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<PluginConfigREF> getMV() {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<CamelCaseName, PluginConfigREF>(this.value) : new TreeMap<CamelCaseName, PluginConfigREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CamelCaseName, PluginConfigREF> getMVCopy() {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<CamelCaseName, PluginConfigREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<CamelCaseName, PluginConfigREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    public PluginConfigREF getByKey(Object key) {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof CamelCaseName) {
                return this.value.get((CamelCaseName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                PluginConfigREF val = this.typeCheck(v);
                return this.value.containsValue((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        DmcTypePluginConfigREFMAP dmcTypePluginConfigREFMAP = this;
        synchronized (dmcTypePluginConfigREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof CamelCaseName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

