/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.server.servlet.generated.types.DmcTypePluginConfigREF;
import org.dmd.dmp.server.servlet.generated.types.PluginConfigREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypePluginConfigREFSET
extends DmcTypePluginConfigREF
implements Serializable {
    private static final Iterator<PluginConfigREF> emptyList = new HashSet().iterator();
    protected Set<PluginConfigREF> value;

    public DmcTypePluginConfigREFSET() {
        this.value = null;
    }

    public DmcTypePluginConfigREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<PluginConfigREF>() : new TreeSet<PluginConfigREF>();
    }

    public DmcTypePluginConfigREFSET getNew() {
        return new DmcTypePluginConfigREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<PluginConfigREF> cloneIt() {
        DmcTypePluginConfigREFSET dmcTypePluginConfigREFSET = this;
        synchronized (dmcTypePluginConfigREFSET) {
            DmcTypePluginConfigREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (PluginConfigREF val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginConfigREF add(Object v) throws DmcValueException {
        DmcTypePluginConfigREFSET dmcTypePluginConfigREFSET = this;
        synchronized (dmcTypePluginConfigREFSET) {
            PluginConfigREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginConfigREF del(Object v) {
        DmcTypePluginConfigREFSET dmcTypePluginConfigREFSET = this;
        synchronized (dmcTypePluginConfigREFSET) {
            PluginConfigREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<PluginConfigREF> getMV() {
        DmcTypePluginConfigREFSET dmcTypePluginConfigREFSET = this;
        synchronized (dmcTypePluginConfigREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<PluginConfigREF>(this.value).iterator();
            }
            return new TreeSet<PluginConfigREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PluginConfigREF> getMVCopy() {
        DmcTypePluginConfigREFSET dmcTypePluginConfigREFSET = this;
        synchronized (dmcTypePluginConfigREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<PluginConfigREF>();
                }
                return new HashSet<PluginConfigREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<PluginConfigREF>(this.value);
            }
            return new TreeSet<PluginConfigREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypePluginConfigREFSET dmcTypePluginConfigREFSET = this;
        synchronized (dmcTypePluginConfigREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypePluginConfigREFSET dmcTypePluginConfigREFSET = this;
        synchronized (dmcTypePluginConfigREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                PluginConfigREF val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

