/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DotName;
import org.dmd.dmp.server.servlet.generated.types.DmcTypeSessionRIREF;
import org.dmd.dmp.server.servlet.generated.types.SessionRIREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeSessionRIREFMAP
extends DmcTypeSessionRIREF
implements Serializable {
    private static final Iterator<SessionRIREF> emptyList = new HashMap().values().iterator();
    protected Map<DotName, SessionRIREF> value;

    public DmcTypeSessionRIREFMAP() {
        this.value = null;
    }

    public DmcTypeSessionRIREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DotName, SessionRIREF>() : new TreeMap<DotName, SessionRIREF>();
    }

    public DotName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DotName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeSessionRIREFMAP getNew() {
        return new DmcTypeSessionRIREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<SessionRIREF> cloneIt() {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            DmcTypeSessionRIREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (SessionRIREF val : this.value.values()) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionRIREF add(Object v) throws DmcValueException {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            DotName key;
            SessionRIREF oldval;
            SessionRIREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DotName)newval.getKey(), newval)) != null && oldval.valuesAreEqual((DmcMappedAttributeIF)newval)) {
                newval = null;
            }
            return newval;
        }
    }

    public SessionRIREF del(Object key) {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DotName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<SessionRIREF> getMV() {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DotName, SessionRIREF>(this.value) : new TreeMap<DotName, SessionRIREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DotName, SessionRIREF> getMVCopy() {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DotName, SessionRIREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DotName, SessionRIREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    public SessionRIREF getByKey(Object key) {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DotName) {
                return this.value.get((DotName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                SessionRIREF val = this.typeCheck(v);
                return this.value.containsValue((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        DmcTypeSessionRIREFMAP dmcTypeSessionRIREFMAP = this;
        synchronized (dmcTypeSessionRIREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DotName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

