/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.server.servlet.generated.types.DmcTypeSessionRIREF;
import org.dmd.dmp.server.servlet.generated.types.SessionRIREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeSessionRIREFSET
extends DmcTypeSessionRIREF
implements Serializable {
    private static final Iterator<SessionRIREF> emptyList = new HashSet().iterator();
    protected Set<SessionRIREF> value;

    public DmcTypeSessionRIREFSET() {
        this.value = null;
    }

    public DmcTypeSessionRIREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<SessionRIREF>() : new TreeSet<SessionRIREF>();
    }

    public DmcTypeSessionRIREFSET getNew() {
        return new DmcTypeSessionRIREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<SessionRIREF> cloneIt() {
        DmcTypeSessionRIREFSET dmcTypeSessionRIREFSET = this;
        synchronized (dmcTypeSessionRIREFSET) {
            DmcTypeSessionRIREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (SessionRIREF val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionRIREF add(Object v) throws DmcValueException {
        DmcTypeSessionRIREFSET dmcTypeSessionRIREFSET = this;
        synchronized (dmcTypeSessionRIREFSET) {
            SessionRIREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionRIREF del(Object v) {
        DmcTypeSessionRIREFSET dmcTypeSessionRIREFSET = this;
        synchronized (dmcTypeSessionRIREFSET) {
            SessionRIREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<SessionRIREF> getMV() {
        DmcTypeSessionRIREFSET dmcTypeSessionRIREFSET = this;
        synchronized (dmcTypeSessionRIREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<SessionRIREF>(this.value).iterator();
            }
            return new TreeSet<SessionRIREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SessionRIREF> getMVCopy() {
        DmcTypeSessionRIREFSET dmcTypeSessionRIREFSET = this;
        synchronized (dmcTypeSessionRIREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<SessionRIREF>();
                }
                return new HashSet<SessionRIREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<SessionRIREF>(this.value);
            }
            return new TreeSet<SessionRIREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeSessionRIREFSET dmcTypeSessionRIREFSET = this;
        synchronized (dmcTypeSessionRIREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeSessionRIREFSET dmcTypeSessionRIREFSET = this;
        synchronized (dmcTypeSessionRIREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                SessionRIREF val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

