/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DotName;
import org.dmd.dmp.server.servlet.generated.types.DmcTypeUserRIREF;
import org.dmd.dmp.server.servlet.generated.types.UserRIREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeUserRIREFMAP
extends DmcTypeUserRIREF
implements Serializable {
    private static final Iterator<UserRIREF> emptyList = new HashMap().values().iterator();
    protected Map<DotName, UserRIREF> value;

    public DmcTypeUserRIREFMAP() {
        this.value = null;
    }

    public DmcTypeUserRIREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DotName, UserRIREF>() : new TreeMap<DotName, UserRIREF>();
    }

    public DotName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DotName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeUserRIREFMAP getNew() {
        return new DmcTypeUserRIREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<UserRIREF> cloneIt() {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            DmcTypeUserRIREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (UserRIREF val : this.value.values()) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRIREF add(Object v) throws DmcValueException {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            DotName key;
            UserRIREF oldval;
            UserRIREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DotName)newval.getKey(), newval)) != null && oldval.valuesAreEqual((DmcMappedAttributeIF)newval)) {
                newval = null;
            }
            return newval;
        }
    }

    public UserRIREF del(Object key) {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DotName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<UserRIREF> getMV() {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DotName, UserRIREF>(this.value) : new TreeMap<DotName, UserRIREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DotName, UserRIREF> getMVCopy() {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DotName, UserRIREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DotName, UserRIREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    public UserRIREF getByKey(Object key) {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DotName) {
                return this.value.get((DotName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                UserRIREF val = this.typeCheck(v);
                return this.value.containsValue((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        DmcTypeUserRIREFMAP dmcTypeUserRIREFMAP = this;
        synchronized (dmcTypeUserRIREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DotName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

