/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmp.server.servlet.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmp.server.servlet.generated.types.DmcTypeUserRIREF;
import org.dmd.dmp.server.servlet.generated.types.UserRIREF;
import org.dmd.dms.generated.enums.ValueTypeEnum;

public class DmcTypeUserRIREFSET
extends DmcTypeUserRIREF
implements Serializable {
    private static final Iterator<UserRIREF> emptyList = new HashSet().iterator();
    protected Set<UserRIREF> value;

    public DmcTypeUserRIREFSET() {
        this.value = null;
    }

    public DmcTypeUserRIREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<UserRIREF>() : new TreeSet<UserRIREF>();
    }

    public DmcTypeUserRIREFSET getNew() {
        return new DmcTypeUserRIREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<UserRIREF> cloneIt() {
        DmcTypeUserRIREFSET dmcTypeUserRIREFSET = this;
        synchronized (dmcTypeUserRIREFSET) {
            DmcTypeUserRIREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (UserRIREF val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRIREF add(Object v) throws DmcValueException {
        DmcTypeUserRIREFSET dmcTypeUserRIREFSET = this;
        synchronized (dmcTypeUserRIREFSET) {
            UserRIREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRIREF del(Object v) {
        DmcTypeUserRIREFSET dmcTypeUserRIREFSET = this;
        synchronized (dmcTypeUserRIREFSET) {
            UserRIREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<UserRIREF> getMV() {
        DmcTypeUserRIREFSET dmcTypeUserRIREFSET = this;
        synchronized (dmcTypeUserRIREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<UserRIREF>(this.value).iterator();
            }
            return new TreeSet<UserRIREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UserRIREF> getMVCopy() {
        DmcTypeUserRIREFSET dmcTypeUserRIREFSET = this;
        synchronized (dmcTypeUserRIREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<UserRIREF>();
                }
                return new HashSet<UserRIREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<UserRIREF>(this.value);
            }
            return new TreeSet<UserRIREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeUserRIREFSET dmcTypeUserRIREFSET = this;
        synchronized (dmcTypeUserRIREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeUserRIREFSET dmcTypeUserRIREFSET = this;
        synchronized (dmcTypeUserRIREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                UserRIREF val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

