/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dmt.client.editors;

import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.presentation.DmcAdapterIF;
import org.dmd.dmc.presentation.DmcPresentationIF;
import org.dmd.dmc.presentation.DmcPresentationTrackerIF;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dmt.shared.generated.dmo.TestBasicObjectFixedDMO;
import org.dmd.dmt.shared.generated.types.adapters.TestBasicObjectFixedMVAdapter;

public class DMTBasicObjectField
implements DmcPresentationIF {
    int ID;
    DmcPresentationTrackerIF tracker;
    TestBasicObjectFixedMVAdapter tboAdapter;
    DmcAttribute<?> attribute;
    int attrIndex = -1;
    TestBasicObjectFixedDMO initialValue;
    DmcObject DMO;
    TestBasicObjectFixedDMO displayedValue;

    public DmcAdapterIF getAdapter() {
        return this.tboAdapter;
    }

    public DmcObject getDMO() {
        return this.DMO;
    }

    public int getID() {
        return this.ID;
    }

    public String getLabel() {
        return null;
    }

    public boolean isReady() {
        return true;
    }

    public void resetToExisting() {
        this.tboAdapter.resetToExisting();
    }

    public void setAdapter(DmcAdapterIF adapter) {
        this.tboAdapter = (TestBasicObjectFixedMVAdapter)adapter;
        this.attribute = (DmcAttribute)adapter;
        this.setDisplayValue();
    }

    public void setDMO(DmcObject dmo) {
        this.DMO = dmo;
    }

    public void setLabel(String label) {
    }

    public void setMandatory(boolean mandatory) {
    }

    public void setReadOnly(boolean readonly) {
    }

    public void setToolTip(String tooltip) {
    }

    public void setTracker(DmcPresentationTrackerIF t, int id) {
        this.tracker = t;
        this.ID = id;
    }

    public void setValueIndex(int index) {
        this.attrIndex = index;
    }

    public boolean valueChanged() {
        return this.tboAdapter.valueChanged();
    }

    public void setEnabled(boolean flag) {
    }

    void setDisplayValue() {
        if (this.attribute.getAttributeInfo().indexSize == 0) {
            if (this.attribute.getSV() == null) {
                this.displayedValue = null;
                this.initialValue = null;
            } else {
                this.initialValue = this.displayedValue = (TestBasicObjectFixedDMO)this.attribute.getSV();
            }
        } else {
            Object val = this.attribute.getMVnth(this.attrIndex);
            if (val == null) {
                this.displayedValue = null;
                this.initialValue = null;
            } else {
                this.initialValue = this.displayedValue = (TestBasicObjectFixedDMO)this.attribute.getMVnth(this.attrIndex);
            }
        }
    }

    public void showDisplayValue() {
        if (this.displayedValue == null) {
            System.out.println("EMPTY");
        } else {
            System.out.println(this.displayedValue.toOIF());
        }
    }

    public void setValue(TestBasicObjectFixedDMO newvalue) {
        if (this.attrIndex >= 0) {
            try {
                this.attribute.setMVnth(this.attrIndex, (Object)newvalue);
                this.displayedValue = newvalue;
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
        } else if (this.attribute.getAttributeInfo().valueType == ValueTypeEnum.SINGLE) {
            try {
                this.attribute.set((Object)newvalue);
                this.displayedValue = newvalue;
            }
            catch (DmcValueException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("Can't use setValue() on attribute of value type: " + this.attribute.getAttributeInfo().valueType);
        }
    }

    public void addValue(TestBasicObjectFixedDMO newvalue) {
        throw new IllegalStateException("addValue not implemented for attribute of value type: " + this.attribute.getAttributeInfo().valueType);
    }

    public void delValue(TestBasicObjectFixedDMO newvalue) {
        throw new IllegalStateException("delValue not implemented for attribute of value type: " + this.attribute.getAttributeInfo().valueType);
    }

    public boolean isValid() {
        return false;
    }

    public void setEmpty() {
    }
}

