/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.client.mvw;

import com.google.gwt.event.shared.UmbrellaException;
import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.SimpleEventBus;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MvwEventBus
extends SimpleEventBus {
    public void fireEvent(Event<?> event) {
        try {
            super.fireEvent(event);
        }
        catch (UmbrellaException umbrella) {
            for (Throwable t : umbrella.getCauses()) {
                this.dumpThrowable(t);
            }
        }
    }

    void dumpThrowable(Throwable throwable) {
        if (throwable instanceof UmbrellaException) {
            UmbrellaException umbrella = (UmbrellaException)throwable;
            for (Throwable t : umbrella.getCauses()) {
                this.dumpThrowable(t);
            }
        } else {
            Logger logger = Logger.getLogger("dark-matter-mvw");
            logger.log(Level.SEVERE, "EXCEPTION :" + throwable.getMessage() + "\n" + this.extractTheStack(throwable) + "\n\n");
        }
    }

    public void fireEventFromSource(Event<?> event, Object source) {
        try {
            super.fireEventFromSource(event, source);
        }
        catch (UmbrellaException umbrella) {
            for (Throwable t : umbrella.getCauses()) {
                this.dumpThrowable(t);
            }
        }
    }

    private String extractTheStack(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i].toString() + "\n");
        }
        return sb.toString();
    }
}

