/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.client.mvwcomms.extended;

import com.google.gwt.user.client.Timer;
import de.novanic.eventservice.client.event.Event;
import de.novanic.eventservice.client.event.domain.Domain;
import de.novanic.eventservice.client.event.domain.DomainFactory;
import de.novanic.eventservice.client.event.listener.RemoteEventListener;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.dmd.dmc.DmcObject;
import org.dmd.dmp.client.ActionCancelResponseCallback;
import org.dmd.dmp.client.ActionResponseCallback;
import org.dmd.dmp.client.CentralDMPErrorHandlerIF;
import org.dmd.dmp.client.CentralEventHandlerIF;
import org.dmd.dmp.client.CentralRPCErrorHandlerIF;
import org.dmd.dmp.client.CommsControllerIF;
import org.dmd.dmp.client.CreateResponseCallback;
import org.dmd.dmp.client.DeleteResponseCallback;
import org.dmd.dmp.client.ErrorOptionsEnum;
import org.dmd.dmp.client.EventHandlerIF;
import org.dmd.dmp.client.GetResponseCallback;
import org.dmd.dmp.client.LoginResponseCallback;
import org.dmd.dmp.client.LogoutResponseCallback;
import org.dmd.dmp.client.ResponseCallback;
import org.dmd.dmp.client.ResponseHandlerIF;
import org.dmd.dmp.client.SetResponseCallback;
import org.dmd.dmp.shared.generated.dmo.ActionCancelRequestDMO;
import org.dmd.dmp.shared.generated.dmo.ActionRequestDMO;
import org.dmd.dmp.shared.generated.dmo.ActionResponseDMO;
import org.dmd.dmp.shared.generated.dmo.CreateRequestDMO;
import org.dmd.dmp.shared.generated.dmo.DMPEventDMO;
import org.dmd.dmp.shared.generated.dmo.DeleteRequestDMO;
import org.dmd.dmp.shared.generated.dmo.GetRequestDMO;
import org.dmd.dmp.shared.generated.dmo.GetResponseDMO;
import org.dmd.dmp.shared.generated.dmo.LoginRequestDMO;
import org.dmd.dmp.shared.generated.dmo.LoginResponseDMO;
import org.dmd.dmp.shared.generated.dmo.LogoutRequestDMO;
import org.dmd.dmp.shared.generated.dmo.PrimeEventChannelATI;
import org.dmd.dmp.shared.generated.dmo.RequestDMO;
import org.dmd.dmp.shared.generated.dmo.ResponseDMO;
import org.dmd.dmp.shared.generated.dmo.SetRequestDMO;
import org.dmd.dmp.shared.generated.enums.ResponseTypeEnum;
import org.dmd.dmp.shared.generated.enums.ScopeEnum;
import org.dmd.dms.extended.ActionTriggerInfo;
import org.dmd.mvw.client.mvw.generated.mvw.MvwRunContextIF;
import org.dmd.mvw.client.mvwcomms.generated.mvw.controllers.CommsControllerBaseImpl;

public class CommsController
extends CommsControllerBaseImpl
implements CommsControllerIF {
    int requestID = 1;
    String sessionID = null;
    Integer originatorID = null;
    CentralDMPErrorHandlerIF DMPErrorHandler = null;
    CentralRPCErrorHandlerIF RPCErrorHandler = null;
    CentralEventHandlerIF centralEventHandler = null;
    TreeMap<Integer, ResponseCallback> requests;
    TreeMap<Long, ResponseCallback> eventHandlers;
    long lastRequestTime = -1L;
    Domain eventDomain;
    boolean trackAllMessages = false;
    boolean controllerTracing = false;
    Timer primingTimer;
    boolean eventChannelReady;
    boolean havePrimingResponse;
    private boolean loggedIn = false;
    Logger logger = Logger.getLogger("CommsController");

    public CommsController(MvwRunContextIF rc) {
        super(rc);
        this.requests = new TreeMap();
        this.eventHandlers = new TreeMap();
    }

    private void reset() {
        this.requestID = 1;
        this.sessionID = null;
        this.originatorID = null;
        this.requests = new TreeMap();
        this.eventHandlers = new TreeMap();
        this.eventDomain = null;
        this.eventChannelReady = false;
        this.havePrimingResponse = false;
        this.loggedIn = false;
        this.logger.fine("Reset complete");
    }

    public void setControllerTracing(boolean f) {
        this.controllerTracing = f;
    }

    public void setGlobalMessageTracking(boolean f) {
        this.trackAllMessages = f;
    }

    public void setCentralEventHandler(CentralEventHandlerIF eh) {
        if (this.centralEventHandler != null) {
            throw new IllegalStateException("You should only register one central event handler.");
        }
        this.centralEventHandler = eh;
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    void setTracking(RequestDMO request) {
        if (this.trackAllMessages) {
            request.setTrackingEnabled(Boolean.valueOf(true));
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public boolean isCommsSessionReady() {
        return this.loggedIn && this.eventChannelReady;
    }

    public LoginRequestDMO getLoginRequest() {
        LoginRequestDMO request = new LoginRequestDMO();
        this.setTracking((RequestDMO)request);
        request.addRequestID(Integer.valueOf(this.requestID++));
        return request;
    }

    public void sendLoginRequest(LoginRequestDMO request, ResponseHandlerIF handler, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID != null) {
            throw new IllegalStateException("Attempted to send login request even though we have a session ID.");
        }
        LoginResponseCallback cb = new LoginResponseCallback(request, handler, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.login(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    public LogoutRequestDMO getLogoutRequest() {
        LogoutRequestDMO request = new LogoutRequestDMO();
        this.setTracking((RequestDMO)request);
        request.addRequestID(Integer.valueOf(this.requestID++));
        request.setSessionID(this.sessionID);
        return request;
    }

    public void sendLogoutRequest(LogoutRequestDMO request, ResponseHandlerIF handler, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID == null) {
            throw new IllegalStateException("Attempted to send logout request but we're not logged in.");
        }
        LogoutResponseCallback cb = new LogoutResponseCallback(request, handler, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.logout(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    public GetRequestDMO getGetRequest() {
        GetRequestDMO request = new GetRequestDMO();
        this.setTracking((RequestDMO)request);
        request.addRequestID(Integer.valueOf(this.requestID++));
        request.setSessionID(this.sessionID);
        request.setScope(ScopeEnum.BASE);
        return request;
    }

    public void sendGetRequest(GetRequestDMO request, ResponseHandlerIF handler, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID == null) {
            throw new IllegalStateException("Attempted to send get request but we're not logged in.");
        }
        GetResponseCallback cb = new GetResponseCallback(request, handler, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.get(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    public void sendGetRequest(GetRequestDMO request, ResponseHandlerIF handler, EventHandlerIF eh, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID == null) {
            throw new IllegalStateException("Attempted to send get request but we're not logged in.");
        }
        GetResponseCallback cb = new GetResponseCallback(request, handler, eh, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.get(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    public SetRequestDMO getSetRequest() {
        SetRequestDMO request = new SetRequestDMO();
        this.setTracking((RequestDMO)request);
        request.addRequestID(Integer.valueOf(this.requestID++));
        request.setSessionID(this.sessionID);
        return request;
    }

    public void sendSetRequest(SetRequestDMO request, ResponseHandlerIF handler, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID == null) {
            throw new IllegalStateException("Attempted to send set request but we're not logged in.");
        }
        SetResponseCallback cb = new SetResponseCallback(request, handler, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.set(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    public CreateRequestDMO getCreateRequest() {
        CreateRequestDMO request = new CreateRequestDMO();
        this.setTracking((RequestDMO)request);
        request.addRequestID(Integer.valueOf(this.requestID++));
        request.setSessionID(this.sessionID);
        return request;
    }

    public void sendCreateRequest(CreateRequestDMO request, ResponseHandlerIF handler, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID == null) {
            throw new IllegalStateException("Attempted to send create request but we're not logged in.");
        }
        CreateResponseCallback cb = new CreateResponseCallback(request, handler, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.create(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    public DeleteRequestDMO getDeleteRequest() {
        DeleteRequestDMO request = new DeleteRequestDMO();
        this.setTracking((RequestDMO)request);
        request.addRequestID(Integer.valueOf(this.requestID++));
        request.setSessionID(this.sessionID);
        return request;
    }

    public void sendDeleteRequest(DeleteRequestDMO request, ResponseHandlerIF handler, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID == null) {
            throw new IllegalStateException("Attempted to send delete request but we're not logged in.");
        }
        DeleteResponseCallback cb = new DeleteResponseCallback(request, handler, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.delete(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    public ActionRequestDMO getActionRequest(ActionTriggerInfo ati) {
        ActionRequestDMO request = new ActionRequestDMO();
        this.setTracking((RequestDMO)request);
        request.addRequestID(Integer.valueOf(this.requestID++));
        request.setSessionID(this.sessionID);
        request.setActionName(ati.getActionName());
        request.setActionTrigger((DmcObject)ati);
        return request;
    }

    public void sendActionRequest(ActionRequestDMO request, ResponseHandlerIF handler, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID == null) {
            throw new IllegalStateException("Attempted to send action request but we're not logged in.");
        }
        ActionResponseCallback cb = new ActionResponseCallback(request, handler, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.action(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    public ActionCancelRequestDMO getActionCancelRequest() {
        ActionCancelRequestDMO request = new ActionCancelRequestDMO();
        this.setTracking((RequestDMO)request);
        request.addRequestID(Integer.valueOf(this.requestID++));
        request.setSessionID(this.sessionID);
        return request;
    }

    public void sendActionCancelRequest(ActionCancelRequestDMO request, ResponseHandlerIF handler, ErrorOptionsEnum rpc, ErrorOptionsEnum dmp) {
        if (this.sessionID == null) {
            throw new IllegalStateException("Attempted to send action request but we're not logged in.");
        }
        ActionCancelResponseCallback cb = new ActionCancelResponseCallback(request, handler, this, rpc, dmp);
        this.checkRequestID((RequestDMO)request);
        this.requests.put(request.getNthRequestID(0), cb);
        this.dmpConnection.actionCancel(request, cb);
        this.lastRequestTime = System.currentTimeMillis();
    }

    @Override
    public void handleFailure(ResponseCallback cb, Throwable caught) {
        if (this.controllerTracing) {
            this.logger.finest("A GWT RPC error occurred: " + caught.toString());
        }
        switch (cb.rpcErrorOption()) {
            case LOCAL: {
                cb.getHandler().handleRPCFailure(caught, cb.getRequest());
                break;
            }
            case CENTRAL: {
                if (this.RPCErrorHandler == null) {
                    throw new IllegalStateException("Central RPC error handling requested but no central handler is set.");
                }
                this.RPCErrorHandler.handleRPCFailureCentrally(caught, cb.getRequest());
                break;
            }
            case CENTRALANDLOCAL: {
                if (this.RPCErrorHandler == null) {
                    throw new IllegalStateException("Central RPC error handling requested but no central handler is set.");
                }
                this.RPCErrorHandler.handleRPCFailureCentrally(caught, cb.getRequest());
                cb.getHandler().handleRPCFailure(caught, cb.getRequest());
            }
        }
    }

    @Override
    public void handleResponse(ResponseCallback cb, ResponseDMO response) {
        if (this.controllerTracing) {
            this.logger.finest(response.toOIF());
        }
        if (response.getResponseType() == ResponseTypeEnum.ERROR) {
            switch (cb.dmpErrorOption()) {
                case LOCAL: {
                    cb.getHandler().handleResponse(response);
                    break;
                }
                case CENTRAL: {
                    if (this.DMPErrorHandler == null) {
                        throw new IllegalStateException("Central DMP error handling requested but no central handler is set.");
                    }
                    this.DMPErrorHandler.handleErrorResponseCentrally(response, cb.getRequest());
                    break;
                }
                case CENTRALANDLOCAL: {
                    if (this.DMPErrorHandler == null) {
                        throw new IllegalStateException("Central DMP error handling requested but no central handler is set.");
                    }
                    this.DMPErrorHandler.handleErrorResponseCentrally(response, cb.getRequest());
                    cb.getHandler().handleResponse(response);
                }
            }
        } else if (response.getResponseType() == ResponseTypeEnum.SUCCESS) {
            if (cb.getCallbackID() == 1) {
                LoginResponseDMO lr = (LoginResponseDMO)response;
                this.eventDomain = DomainFactory.getDomain((String)lr.getSessionID());
                this.sessionID = lr.getSessionID();
                this.originatorID = lr.getOriginatorID();
                this.eventService.addListener(this.eventDomain, new RemoteEventListener(){

                    public void apply(Event anEvent) {
                        CommsController.this.handleAsynchronousInfo(anEvent);
                    }
                });
                this.loggedIn = true;
                this.fireLoginCompleteEvent();
                this.primeTheEventChannel();
            } else if (cb.getCallbackID() == 2) {
                if (this.eventDomain != null) {
                    this.eventService.removeListeners(this.eventDomain);
                    this.eventDomain = null;
                }
                this.loggedIn = false;
                this.fireLogoutCompleteEvent();
                this.reset();
            } else if (cb.getCallbackID() == 3) {
                this.registerEventHandler(cb, (GetResponseDMO)response);
            }
            cb.getHandler().handleResponse(response);
        } else {
            cb.getHandler().handleResponse(response);
        }
    }

    void registerEventHandler(ResponseCallback cb, GetResponseDMO getResponse) {
        if (cb.getEventHandler() == null) {
            return;
        }
        if (getResponse.getListenerID() != null && this.eventHandlers.get(getResponse.getListenerID()) == null) {
            if (this.controllerTracing) {
                this.logger.finest("registerEventHandler() - registering event handler for listenerID: " + getResponse.getListenerID());
            }
            this.eventHandlers.put(getResponse.getListenerID(), cb);
        }
    }

    void handleAsynchronousInfo(Object async) {
        if (async instanceof DMPEventDMO) {
            DMPEventDMO event = (DMPEventDMO)async;
            if (this.controllerTracing) {
                this.logger.finest("handleAsynchronousInfo() got event:\n\n" + event.toOIF() + "\n\n");
            }
            if (event.getListenerID() == null) {
                if (this.centralEventHandler != null) {
                    this.centralEventHandler.handleEventCentrally(event);
                }
                this.logger.severe("handleAsynchronousInfo() - received event with no listenerID: " + event.toOIF());
                return;
            }
            ResponseCallback cb = this.eventHandlers.get(event.getListenerID());
            if (cb == null) {
                this.logger.severe("handleAsynchronousInfo() - couldn't get callback for event with listenerID: " + event.getListenerID());
            } else {
                event.setHandlerID(cb.getRequest().getHandlerID());
                if (this.originatorID != null && event.getOriginatorID() != null && this.originatorID == event.getOriginatorID()) {
                    event.setMyOwnEvent(Boolean.valueOf(true));
                }
                cb.getEventHandler().handleEvent(event);
            }
        } else if (async instanceof ResponseDMO) {
            ResponseCallback cb;
            ResponseDMO response = (ResponseDMO)async;
            if (this.controllerTracing) {
                this.logger.finest("handleAsynchronousInfo() - got response:\n\n" + response.toOIF() + "\n\n");
            }
            if ((cb = this.requests.get(response.getNthRequestID(0))) == null) {
                this.logger.severe("handleAsynchronousInfo() - couldn't get callback for response: " + response.toOIF());
            } else {
                if (cb.getCallbackID() == 3) {
                    this.registerEventHandler(cb, (GetResponseDMO)response);
                }
                cb.getHandler().handleResponse(response);
                if (response.isLastResponse().booleanValue()) {
                    if (this.controllerTracing) {
                        this.logger.finest("handleAsynchronousInfo() is last response...");
                    }
                    this.requests.remove(response.getNthRequestID(0));
                }
            }
        }
    }

    @Override
    public void useCentralDMPErrorHandler(CentralDMPErrorHandlerIF handler) {
        this.DMPErrorHandler = handler;
    }

    @Override
    public void useCentralRPCErrorHandler(CentralRPCErrorHandlerIF handler) {
        this.RPCErrorHandler = handler;
    }

    void checkRequestID(RequestDMO request) {
        if (request.getNthRequestID(0) == null) {
            throw new IllegalStateException("This request has no requestID value; you should use the getNewXXXRequest() method to construct requests that are sent via the MVW CommsController\n" + request.toOIF());
        }
    }

    void primeTheEventChannel() {
        this.eventChannelReady = false;
        this.havePrimingResponse = false;
        this.primingTimer = new Timer(){

            public void run() {
                if (CommsController.this.havePrimingResponse) {
                    if (CommsController.this.controllerTracing) {
                        CommsController.this.logger.finest("Having event channel priming response - cancelling timer.");
                    }
                    CommsController.this.primingTimer.cancel();
                } else {
                    ActionRequestDMO request = CommsController.this.getPrimeEventChannelRequest((ActionTriggerInfo)new PrimeEventChannelATI());
                    CommsController.this.sendPrimeEventChannelRequest(request);
                    if (CommsController.this.controllerTracing) {
                        CommsController.this.logger.finest("Event channel priming request sent...");
                    }
                }
            }
        };
        this.primingTimer.scheduleRepeating(500);
    }

    @Override
    protected void handlePrimeEventChannelResponseError(ActionResponseDMO response) {
        this.logger.severe("An error occurred while priming the event channel:\n\n" + response.toOIF());
        this.havePrimingResponse = true;
        this.fireCommsSessionFailed(response.getResponseText());
    }

    @Override
    protected void handlePrimeEventChannelResponse(ActionResponseDMO response) {
        if (this.controllerTracing) {
            this.logger.finest("Event channel priming response:\n\n" + response.toOIF());
        }
        if (response.isLastResponse().booleanValue()) {
            this.logger.finest("Event channel is operational...");
            this.havePrimingResponse = true;
            this.eventChannelReady = true;
            this.fireCommsSessionReady();
        }
    }

    @Override
    protected ActionRequestDMO getPrimeEventChannelRequest(ActionTriggerInfo ati) {
        ActionRequestDMO request = this.getActionRequest(ati);
        request.setHandlerID(Integer.valueOf(0));
        request.setNotifyOriginator(Boolean.valueOf(true));
        return request;
    }

    @Override
    protected void sendPrimeEventChannelRequest(ActionRequestDMO request) {
        this.sendActionRequest(request, this, ErrorOptionsEnum.CENTRAL, ErrorOptionsEnum.LOCAL);
    }

    @Override
    public void onForceCommsReset() {
        this.reset();
    }
}

