/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.client.mvwmenus.extended.controllers;

import java.util.TreeMap;
import org.dmd.dmc.DmcObject;
import org.dmd.mvw.client.mvwmenus.base.Action;
import org.dmd.mvw.client.mvwmenus.base.MvwBackgroundMenu;
import org.dmd.mvw.client.mvwmenus.base.MvwMenu;
import org.dmd.mvw.client.mvwmenus.base.MvwMenuItem;
import org.dmd.mvw.client.mvwmenus.base.MvwPopupMenu;
import org.dmd.mvw.client.mvwmenus.base.MvwSeparator;
import org.dmd.mvw.client.mvwmenus.base.MvwSubMenu;
import org.dmd.mvw.client.mvwmenus.generated.mvw.controllers.MenuControllerBaseImpl;

public class MenuController
extends MenuControllerBaseImpl {
    TreeMap<String, Action> actions = new TreeMap();
    TreeMap<String, MvwMenuItem> menuItems = new TreeMap();
    TreeMap<String, MvwSeparator> separators = new TreeMap();
    TreeMap<String, MvwMenu> allMenus = new TreeMap();
    TreeMap<String, MvwSubMenu> subMenus = new TreeMap();
    TreeMap<String, MvwMenu> topLevelMenus = new TreeMap();
    TreeMap<String, MvwPopupMenu> popups = new TreeMap();
    TreeMap<String, MvwBackgroundMenu> backgroundMenus = new TreeMap();

    public MvwMenu getMenu(String name) {
        return this.topLevelMenus.get(name);
    }

    public MvwSubMenu getSubMenu(String name) {
        return this.subMenus.get(name);
    }

    public MvwMenu getPopupMenuForObject(DmcObject obj) {
        return this.popups.get(obj.getConstructionClassName());
    }

    public MvwMenu getBackgroundMenu(String name) {
        return this.backgroundMenus.get(name);
    }

    public void initializeMenus() {
        MvwMenu menu;
        for (MvwMenuItem mii : this.menuItems.values()) {
            Action action = this.actions.get(mii.getActionName());
            mii.setAction(action);
            MvwMenu menu2 = this.allMenus.get(mii.getAddToMenu());
            menu2.addSubItem(mii);
        }
        for (MvwSeparator subitem : this.separators.values()) {
            menu = this.allMenus.get(subitem.getAddToMenu());
            menu.addSubItem(subitem);
        }
        for (MvwSubMenu sub : this.subMenus.values()) {
            menu = this.allMenus.get(sub.getAddToMenu());
            menu.addSubItem(sub);
        }
        for (MvwSubMenu sub : this.subMenus.values()) {
            sub.buildMenu();
        }
        for (MvwMenu mi : this.topLevelMenus.values()) {
            mi.buildMenu();
        }
    }

    public void addAction(Action a) {
        System.out.println("MenuController.addAction() " + a.getName());
        this.actions.put(a.getName(), a);
    }

    public void addMenuItem(MvwMenuItem mii) {
        System.out.println("MenuController.addMenuItem() " + mii.toString());
        this.menuItems.put(mii.getName(), mii);
    }

    public void addSeparator(MvwSeparator msi) {
        this.separators.put(msi.getName(), msi);
    }

    public void removeSeparator(MvwSeparator msi) {
        this.separators.remove(msi.getName());
    }

    public void addMenu(MvwMenu mi) {
        this.allMenus.put(mi.getName(), mi);
        if (mi instanceof MvwSubMenu) {
            this.subMenus.put(mi.getName(), (MvwSubMenu)mi);
        } else {
            this.topLevelMenus.put(mi.getName(), mi);
            if (mi instanceof MvwPopupMenu) {
                MvwPopupMenu pmi = (MvwPopupMenu)mi;
                this.popups.put(pmi.getForClass().name, pmi);
            }
            if (mi instanceof MvwBackgroundMenu) {
                MvwBackgroundMenu bmi = (MvwBackgroundMenu)mi;
                this.backgroundMenus.put(bmi.getName(), bmi);
            }
        }
    }
}

