/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmg.generated.DmgSchemaAG;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.util.DmsSchemaParser;
import org.dmd.mvw.tools.mvwgenerator.doc.web.MvwHtmlDocGenerator;
import org.dmd.mvw.tools.mvwgenerator.generated.MvwSchemaAG;
import org.dmd.mvw.tools.mvwgenerator.util.MvwDefinitionManager;
import org.dmd.mvw.tools.mvwgenerator.util.MvwGenerator;
import org.dmd.mvw.tools.mvwgenerator.util.MvwParser;
import org.dmd.util.BooleanVar;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;
import org.dmd.util.parsing.Classifier;
import org.dmd.util.parsing.CommandLine;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;
import org.dmd.util.parsing.StringArrayList;
import org.dmd.util.parsing.TokenArrayList;

public class MvwGenUtility {
    SchemaManager baseSchema;
    SchemaManager baseWithMVWSchema;
    ConfigFinder schemaFinder;
    ConfigFinder configFinder;
    DmsSchemaParser schemaParser;
    MvwDefinitionManager defManager;
    MvwDefinitionManager aggregateManager;
    MvwParser parser;
    MvwGenerator codeGenerator;
    MvwHtmlDocGenerator docGenerator;
    PrintfFormat format;
    CommandLine cl;
    StringBuffer help;
    BooleanVar helpFlag = new BooleanVar();
    StringArrayList srcdir = new StringArrayList();
    StringBuffer workspace = new StringBuffer();
    BooleanVar autogen = new BooleanVar();
    StringBuffer cfg = new StringBuffer();
    BooleanVar debug = new BooleanVar();
    BooleanVar debugdmdcfg = new BooleanVar();
    BooleanVar debugmvwcfg = new BooleanVar();
    StringBuffer docdir = new StringBuffer();
    StringArrayList jars = new StringArrayList();

    public MvwGenUtility(String[] args) throws ResultException, IOException, DmcValueException, DmcValueExceptionSet, DmcNameClashException {
        this.initHelp();
        this.cl = new CommandLine();
        this.cl.addOption("-h", this.helpFlag, "Dumps the help message.");
        this.cl.addOption("-srcdir", this.srcdir, "The source directories to search.");
        this.cl.addOption("-workspace", this.workspace, "The workspace prefix");
        this.cl.addOption("-autogen", this.autogen, "Indicates that you want to generate from all configs automatically.");
        this.cl.addOption("-debug", this.debug, "Dump debug information.");
        this.cl.addOption("-debugdmdcfg", this.debug, "Dump debug information for schema finder.");
        this.cl.addOption("-debugmvwcfg", this.debug, "Dump debug information for mvw config finder.");
        this.cl.addOption("-docdir", this.docdir, "The documentation directory.");
        this.cl.addOption("-jars", this.jars, "The prefixs of jars to search for .mvw config files.");
        this.cl.parseArgs(args);
        if (this.helpFlag.booleanValue()) {
            System.out.println(this.help.toString());
        }
        this.baseSchema = new SchemaManager();
        this.baseWithMVWSchema = new SchemaManager();
        DmgSchemaAG dmg = new DmgSchemaAG();
        this.baseWithMVWSchema.manageSchema((SchemaDefinition)dmg);
        MvwSchemaAG mvw = new MvwSchemaAG();
        this.baseWithMVWSchema.manageSchema((SchemaDefinition)mvw);
        StringArrayList searchdirs = new StringArrayList();
        if (this.srcdir.size() > 0) {
            searchdirs = new StringArrayList();
            for (String dir : this.srcdir) {
                searchdirs.add((Object)(this.workspace.toString() + "/" + dir));
            }
        } else {
            searchdirs = this.srcdir;
        }
        this.schemaFinder = new ConfigFinder(searchdirs.iterator());
        if (this.debugdmdcfg.booleanValue()) {
            this.schemaFinder.debug(true);
        }
        this.schemaFinder.addSuffix(".dms");
        if (this.jars.size() > 0) {
            for (String jar : this.jars) {
                this.schemaFinder.addJarPrefix(jar);
            }
        }
        this.schemaFinder.findConfigs();
        this.schemaParser = new DmsSchemaParser(this.baseSchema, this.schemaFinder);
        this.defManager = new MvwDefinitionManager(this.baseWithMVWSchema, this.schemaParser);
        this.defManager.debug(this.debug.booleanValue());
        this.defManager.schemadebug(this.debugdmdcfg.booleanValue());
        this.aggregateManager = new MvwDefinitionManager(this.baseWithMVWSchema, this.schemaParser);
        this.configFinder = new ConfigFinder(searchdirs.iterator());
        if (this.jars.size() > 0) {
            for (String jar : this.jars) {
                this.configFinder.addJarPrefix(jar);
            }
        }
        this.docGenerator = new MvwHtmlDocGenerator(this.aggregateManager);
        if (this.debugmvwcfg.booleanValue()) {
            this.configFinder.debug(true);
        }
        this.configFinder.addSuffix(".mvw");
        this.configFinder.findConfigs();
        this.parser = new MvwParser(this.baseWithMVWSchema, this.configFinder, this.defManager);
        this.parser.debug(this.debug.booleanValue());
        this.codeGenerator = new MvwGenerator(this.defManager, System.out);
        String f = "%-" + this.configFinder.getLongestName() + "s";
        this.format = new PrintfFormat(f);
    }

    void initHelp() {
        this.help = new StringBuffer();
        this.help.append("mvwgen -h -cfg -workspace -srcdir -docdir <directory> -autogen -debug -debugmvwcfg -debugdmdcfg\n\n");
        this.help.append("The mvwgen tool generates GWT MVP compatible interfaces and base implementation classes from\n");
        this.help.append("definitions found in .mvw configuration files. MVW configurations are recursivley discovered\n");
        this.help.append("in your development environment using commandline arguments:\n");
        this.help.append("\n");
        this.help.append("-workspace <path> indicates your Eclipse work space path.\n");
        this.help.append("\n");
        this.help.append("-srcdir <project/src> <project/src>... indicates the project source folder(s) to search\n");
        this.help.append("\n");
        this.help.append("-autogen indicates that you wish to generate code from all discovered .mvw files\n");
        this.help.append("\n");
        this.help.append("-docdir indicates that you wish to generate documentation from all discovered .mvw files\n");
        this.help.append("        This must be used in conjunction with -autogen.\n");
        this.help.append("        You should use the same doc directory as that used for the schema documentation.\n");
        this.help.append("\n");
        this.help.append("-debug turns on generation debugging\n");
        this.help.append("\n");
        this.help.append("-debugmvwcfg turns on debug for the MVW config finder\n");
        this.help.append("\n");
        this.help.append("-debugdmdcfg turns on debug for the schema config finder\n");
        this.help.append("\n");
        this.help.append("-h dumps the help information.\n");
        this.help.append("\n");
        this.help.append("example: mvwgen -workspace C:/eclipse/workspace -srcdir proj1/src proj2/src proj3/src\n");
        this.help.append("\n");
    }

    public void run() throws DmcNameClashException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String currLine = null;
        Classifier classifier = new Classifier();
        TokenArrayList tokens = null;
        if (this.autogen.booleanValue()) {
            for (ConfigVersion version : this.configFinder.getVersions().values()) {
                ConfigLocation loc = version.getLatestVersion();
                if (this.debug.booleanValue()) {
                    DebugInfo.debug((String)("MVW config: " + loc.getConfigName()));
                }
                if (!loc.isFromJAR()) {
                    this.generateFromConfig(version);
                }
                this.aggregateManager.mergeDefinitions(this.defManager);
            }
            System.out.println("DONE");
            try {
                if (this.docdir.length() > 0) {
                    if (this.workspace.length() > 0) {
                        this.docGenerator.dumpDocumentation(this.workspace.toString() + "/" + this.docdir.toString());
                    } else {
                        this.docGenerator.dumpDocumentation(this.docdir.toString());
                    }
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
                e.printStackTrace();
                System.exit(1);
            }
            System.exit(0);
        }
        System.out.println("\nmvw generator - enter the name of a Model View Whatever config\n");
        System.out.println("Enter ? for a list of configs...\n\n");
        block9: while (true) {
            try {
                while (true) {
                    String s;
                    if ((s = in.readLine()) == null) {
                        return;
                    }
                    currLine = s.trim();
                    if (currLine.length() == 0 || (tokens = classifier.classify(currLine, false)).size() == 0) continue;
                    ConfigVersion currConfig = this.configFinder.getConfig(tokens.nth(0).getValue());
                    if (tokens.nth(0).getValue().equals("?")) {
                        System.out.println("");
                        System.out.println(this.configFinder.getSearchInfo() + "\n");
                        for (ConfigVersion version : this.configFinder.getVersions().values()) {
                            ConfigLocation loc = version.getLatestVersion();
                            if (loc.getJarFilename() == null) {
                                System.out.println(this.format.sprintf(loc.getConfigName()) + "   version: " + loc.getVersion());
                                System.out.println(this.format.sprintf("") + " " + loc.getConfigParentDirectory() + "\n");
                                continue;
                            }
                            System.out.println(this.format.sprintf("JAR " + loc.getConfigName()) + " " + loc.getDirectory());
                            System.out.println(this.format.sprintf("") + " " + loc.getConfigParentDirectory() + "\n");
                        }
                        System.out.println("");
                        continue;
                    }
                    if (currConfig == null) {
                        System.err.println("\n" + currLine + " is not a recoginized config name.\n\n");
                        continue;
                    }
                    try {
                        this.parser.parseConfig(currConfig.getLatestVersion());
                        if (tokens.size() == 2) {
                            if (tokens.nth(1).getValue().equals("doc")) continue block9;
                            System.err.println("\n" + currLine + " is not a recoginized command option.\n\n");
                            continue block9;
                        }
                        FileUpdateManager.instance().reportProgress(System.out);
                        FileUpdateManager.instance().reportErrors(System.err);
                        FileUpdateManager.instance().generationStarting();
                        this.codeGenerator.generateCode(currConfig.getLatestVersion());
                        FileUpdateManager.instance().generationComplete();
                        continue block9;
                    }
                    catch (ResultException e) {
                        System.err.println("\n" + e.toString());
                        continue;
                    }
                    catch (DmcValueException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (DmcRuleExceptionSet e) {
                        System.err.println("\n" + e.toString());
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                System.out.println("IOException:\n" + e.getMessage());
                System.exit(1);
                continue;
            }
            break;
        }
    }

    void generateFromConfig(ConfigVersion currConfig) throws DmcNameClashException {
        try {
            this.parser.parseConfig(currConfig.getLatestVersion());
            FileUpdateManager.instance().reportProgress(System.out);
            FileUpdateManager.instance().reportErrors(System.err);
            FileUpdateManager.instance().generationStarting();
            this.codeGenerator.generateCode(currConfig.getLatestVersion());
            FileUpdateManager.instance().generationComplete();
        }
        catch (ResultException e) {
            System.err.println("\n" + e.toString());
            System.exit(1);
        }
        catch (DmcValueException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (DmcRuleExceptionSet e) {
            e.printStackTrace();
            System.err.println(e.toString());
            System.exit(1);
        }
    }
}

