/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.doc.web;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.dms.doc.web.Converter;
import org.dmd.mvw.tools.mvwgenerator.doc.web.StandardParts;
import org.dmd.mvw.tools.mvwgenerator.doc.web.Summarizer;
import org.dmd.mvw.tools.mvwgenerator.extended.Module;
import org.dmd.mvw.tools.mvwgenerator.extended.MvwDefinition;

public class ModulePage {
    public static void dumpModule(String outdir, Module module, Summarizer summarizer) throws IOException {
        module.initAssociatedDefintions();
        String ofn = outdir + File.separator + module.getCamelCaseName() + ".html";
        BufferedWriter out = new BufferedWriter(new FileWriter(ofn));
        StandardParts.writePageHeader(out, "The " + module.getCamelCaseName() + " Module");
        StandardParts.writeContentStart(out);
        ModulePage.dumpModule(module, out);
        ModulePage.dumpIndex(module, out);
        StandardParts.writeContentEnd(out);
        out.write(summarizer.getSideBar());
        StandardParts.writePageFooter(out);
        out.close();
    }

    static void dumpModule(Module module, BufferedWriter out) throws IOException {
        out.write("      <div class=\"module-name\">" + module.getCamelCaseName() + " </div>\n\n");
        if (module.getDescriptionHasValue()) {
            out.write("      <div class=\"description\">" + Converter.convert((Iterator)module.getDescriptionIterable()) + " </div>\n\n");
        } else {
            out.write("      <div class=\"description\">No description</div>\n\n");
        }
    }

    static void dumpIndex(Module module, BufferedWriter out) throws IOException {
        if (module.getApplications().size() > 0) {
            ModulePage.writeSummary("Applications", module.getApplications(), out);
        }
        if (module.getControllers().size() > 0) {
            ModulePage.writeSummary("Controllers", module.getControllers(), out);
        }
        if (module.getPresenters().size() > 0) {
            ModulePage.writeSummary("Presenters", module.getPresenters(), out);
        }
        if (module.getViews().size() > 0) {
            ModulePage.writeSummary("Views", module.getViews(), out);
        }
        if (module.getPlaces().size() > 0) {
            ModulePage.writeSummary("Places", module.getPlaces(), out);
        }
        if (module.getActivities().size() > 0) {
            ModulePage.writeSummary("Activities", module.getActivities(), out);
        }
        if (module.getContextItems().size() > 0) {
            ModulePage.writeSummary("Run Context Items", module.getContextItems(), out);
        }
        if (module.getBindings().size() > 0) {
            ModulePage.writeSummary("Form Bindings", module.getBindings(), out);
        }
        if (module.getEditors().size() > 0) {
            ModulePage.writeSummary("Field Editors", module.getEditors(), out);
        }
    }

    static void writeSummary(String title, TreeMap<CamelCaseName, ? extends MvwDefinition> defs, BufferedWriter out) throws IOException {
        out.write("    <div class=\"definitionList\">\n");
        out.write("    <h2> " + title + "</h2>\n");
        out.write("    <table>\n");
        for (MvwDefinition mvwDefinition : defs.values()) {
            out.write("      <tr>\n");
            out.write("      <td class=\"spacer\"> </td>\n");
            out.write("      <td> <a class=\"deflink\" href=\"#" + mvwDefinition.getCamelCaseName() + "\"> " + mvwDefinition.getCamelCaseName() + " </a></td>\n");
            out.write("      </tr>\n");
        }
        out.write("    </table>\n");
        out.write("    </div>");
    }

    static void dumpDetails(Module module, BufferedWriter out) throws IOException {
        if (module.getApplications().size() > 0) {
            // empty if block
        }
        if (module.getControllers().size() > 0) {
            // empty if block
        }
        if (module.getPresenters().size() > 0) {
            // empty if block
        }
        if (module.getViews().size() > 0) {
            // empty if block
        }
        if (module.getPlaces().size() > 0) {
            // empty if block
        }
        if (module.getActivities().size() > 0) {
            // empty if block
        }
        if (module.getContextItems().size() > 0) {
            // empty if block
        }
        if (module.getBindings().size() > 0) {
            // empty if block
        }
        if (module.getEditors().size() > 0) {
            // empty if block
        }
    }
}

