/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.doc.web;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.dmd.dmc.DmcOmni;
import org.dmd.mvw.tools.mvwgenerator.doc.web.ModulePage;
import org.dmd.mvw.tools.mvwgenerator.doc.web.Summarizer;
import org.dmd.mvw.tools.mvwgenerator.extended.Module;
import org.dmd.mvw.tools.mvwgenerator.util.MvwDefinitionManager;
import org.dmd.util.exceptions.DebugInfo;

public class MvwHtmlDocGenerator {
    String outdir;
    MvwDefinitionManager defManager;

    public MvwHtmlDocGenerator(MvwDefinitionManager dm) {
        this.defManager = dm;
    }

    public void dumpDocumentation(String od) throws IOException {
        this.outdir = od + File.separator + "mvw";
        DebugInfo.debug((String)("Generating MVW documentation: " + this.outdir));
        Summarizer summary = new Summarizer(this.defManager, od);
        this.initDirs();
        URL url = this.getClass().getResource("mvwstyle.css");
        DebugInfo.debug((String)("url: " + url.getFile()));
        FileUtils.copyURLToFile((URL)url, (File)new File(this.outdir + File.separator + "mvwstyle.css"));
        DmcOmni.instance().backRefTracking(true);
        this.defManager.prepAggregatedInfo();
        for (Module module : this.defManager.getModules().values()) {
            ModulePage.dumpModule(this.outdir, module, summary);
        }
        summary.dumpSummaryFiles();
    }

    void initDirs() {
        File dmsdocdir = new File(this.outdir);
        if (!dmsdocdir.exists()) {
            dmsdocdir.mkdir();
        }
    }
}

