/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.doc.web;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.dmd.mvw.tools.mvwgenerator.doc.web.EventFormatter;
import org.dmd.mvw.tools.mvwgenerator.doc.web.RunContextItemFormatter;
import org.dmd.mvw.tools.mvwgenerator.doc.web.StandardParts;
import org.dmd.mvw.tools.mvwgenerator.extended.Event;
import org.dmd.mvw.tools.mvwgenerator.extended.Module;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.mvw.tools.mvwgenerator.util.MvwDefinitionManager;

public class Summarizer {
    MvwDefinitionManager defManager;
    String outdir;
    StringBuffer sidebar;

    public Summarizer(MvwDefinitionManager mdm, String od) {
        this.defManager = mdm;
        this.sidebar = new StringBuffer();
        this.outdir = od + File.separator + "mvw";
        this.buildSidebar();
    }

    public String getSideBar() {
        return this.sidebar.toString();
    }

    void buildSidebar() {
        this.sidebar.append("    <div id=\"sidebar\">\n");
        this.sidebar.append("    <div class=\"sidebarTitle\"> Modules </div>\n");
        for (Module module : this.defManager.getModules().values()) {
            String name = module.getCamelCaseName().getNameString();
            this.sidebar.append("        <a class=\"navLink\" href=\"" + name + ".html\"> " + name + "</a>\n");
        }
        this.sidebar.append("        <p/>\n");
        this.sidebar.append("    <div class=\"sidebarTitle\"> Summaries </div>\n");
        this.sidebar.append("        <a class=\"navLink\" href=\"EventSummary.html\"> Events</a>\n");
        this.sidebar.append("        <a class=\"navLink\" href=\"RCISummary.html\"> Run Context Items</a>\n");
        this.sidebar.append("    </div>\n");
    }

    public void dumpSummaryFiles() throws IOException {
        this.dumpEventSummary();
        this.dumpRCISummary();
    }

    void dumpEventSummary() throws IOException {
        String ofn = this.outdir + File.separator + "EventSummary.html";
        BufferedWriter out = new BufferedWriter(new FileWriter(ofn));
        StandardParts.writePageHeader(out, "Event Summary");
        StandardParts.writeContentStart(out);
        out.write("<h1> Event Summary </h1>\n\n");
        out.write("    <table>\n\n");
        for (Event event : this.defManager.getEvents().values()) {
            EventFormatter.dumpEventSummary(event, out);
        }
        out.write("    </table>\n\n");
        StandardParts.writeContentEnd(out);
        out.write(this.getSideBar());
        StandardParts.writePageFooter(out);
        out.close();
    }

    void dumpRCISummary() throws IOException {
        String ofn = this.outdir + File.separator + "RCISummary.html";
        BufferedWriter out = new BufferedWriter(new FileWriter(ofn));
        StandardParts.writePageHeader(out, "Run Context Item Summary");
        StandardParts.writeContentStart(out);
        out.write("<h1> Run Context Item Summary </h1>\n\n");
        out.write("    <table>\n\n");
        for (RunContextItem rci : this.defManager.getDefaultContext().getItemsByName().values()) {
            RunContextItemFormatter.dumpRCISummary(rci, out);
        }
        out.write("    </table>\n\n");
        StandardParts.writeContentEnd(out);
        out.write(this.getSideBar());
        StandardParts.writePageFooter(out);
        out.close();
    }
}

