/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.extended;

import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.CodeGenComponentIF;
import org.dmd.mvw.tools.mvwgenerator.extended.ErrorOptionsEnum;
import org.dmd.mvw.tools.mvwgenerator.extended.Event;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.mvw.tools.mvwgenerator.extended.View;
import org.dmd.mvw.tools.mvwgenerator.generated.dmo.ComponentDMO;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.ComponentDMW;
import org.dmd.mvw.tools.mvwgenerator.generated.enums.RequestOptionEnum;
import org.dmd.mvw.tools.mvwgenerator.types.RequestTypeWithOptions;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.util.BooleanVar;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class Component
extends ComponentDMW
implements CodeGenComponentIF {
    protected boolean initialized;
    protected ImportManager imports;
    StringBuffer loadAttributeSchemas;
    boolean hasCommsMethods;
    boolean handlesObjectEvents;
    boolean usesCentralDMPErrorHandler;
    boolean usesCentralRPCErrorHandler;
    protected BooleanVar usesRunContext;
    int methodID;
    StringBuffer commsMethods;
    protected StringBuffer abstractMethods;
    StringBuffer fireMethods;
    StringBuffer errorCases;
    StringBuffer rpcErrorCases;
    StringBuffer successCases;
    StringBuffer commsConstants;
    StringBuffer eventRegistration;
    StringBuffer objEventHandlers;
    TreeMap<String, CommsHandler> commsHandlers;
    protected StringBuffer actionVariables;
    protected StringBuffer actionInstantiations;

    public Component() {
    }

    @Override
    public void resetCodeGenInfo() {
        this.imports = null;
        this.loadAttributeSchemas = null;
        this.hasCommsMethods = false;
        this.methodID = 0;
        this.commsMethods = null;
        this.abstractMethods = null;
        this.fireMethods = null;
        this.errorCases = null;
        this.objEventHandlers = null;
        this.rpcErrorCases = null;
        this.successCases = null;
        this.commsConstants = null;
        this.eventRegistration = null;
        this.commsHandlers = null;
        this.actionVariables = null;
        this.actionInstantiations = null;
    }

    public String getBaseClassName() {
        if (this.getUseBaseClass() == null) {
            return "";
        }
        int lastdot = this.getUseBaseClass().lastIndexOf(".");
        return this.getUseBaseClass().substring(lastdot + 1);
    }

    protected Component(ComponentDMO obj, ClassDefinition cd) {
        super(obj, cd);
    }

    @Override
    public Component getModificationRecorder() {
        return null;
    }

    public boolean hasCommsMethods() {
        return this.hasCommsMethods;
    }

    public boolean handlesObjectEvents() {
        return this.handlesObjectEvents;
    }

    public boolean usesCentralDmpErrorHandling() {
        return this.usesCentralDMPErrorHandler;
    }

    public boolean usesCentralRpcErrorHandling() {
        return this.usesCentralRPCErrorHandler;
    }

    public boolean usesRunContext() {
        if (this.usesRunContext == null) {
            this.usesRunContext = new BooleanVar();
            if (this.getHandlesEventHasValue()) {
                this.usesRunContext.set(true);
            } else if (this.getFiresEventHasValue()) {
                this.usesRunContext.set(true);
            } else if (this.getInstantiatesViewHasValue()) {
                this.usesRunContext.set(true);
            } else if (this.getUsesRunContextItemHasValue()) {
                this.usesRunContext.set(true);
            } else if (this.getSendsRequestHasValue()) {
                this.usesRunContext.set(true);
            }
        }
        return this.usesRunContext.booleanValue();
    }

    public String getImports() {
        return this.imports.getFormattedImports();
    }

    public String getAttributeSchemaLoaders() {
        return this.loadAttributeSchemas.toString();
    }

    public String getCommsMethods() {
        return this.commsMethods.toString();
    }

    public String getAbstractMethods() {
        return this.abstractMethods.toString();
    }

    public String getFireMethods() {
        return this.fireMethods.toString();
    }

    public String getEventRegistration() {
        return this.eventRegistration.toString();
    }

    public String getCommsConstants() {
        if (this.commsConstants.length() > 0) {
            this.commsConstants.append("\n");
        }
        return this.commsConstants.toString();
    }

    public String getActionVariables() {
        return this.actionVariables.toString();
    }

    public String getActionInstantiations() {
        return this.actionInstantiations.toString();
    }

    protected void initCodeGenInfo(boolean rpc, boolean dmp) throws ResultException {
        Event event;
        Iterator<CommsHandler> iterator;
        this.imports = new ImportManager();
        this.loadAttributeSchemas = new StringBuffer();
        this.hasCommsMethods = false;
        this.methodID = 0;
        this.commsMethods = new StringBuffer();
        this.abstractMethods = new StringBuffer();
        this.fireMethods = new StringBuffer();
        this.errorCases = new StringBuffer();
        this.objEventHandlers = new StringBuffer();
        this.rpcErrorCases = new StringBuffer();
        this.successCases = new StringBuffer();
        this.commsConstants = new StringBuffer();
        this.eventRegistration = new StringBuffer();
        this.commsHandlers = new TreeMap();
        this.actionVariables = new StringBuffer();
        this.actionInstantiations = new StringBuffer();
        if (this.getHandlesEventHasValue()) {
            iterator = this.getHandlesEventIterable().iterator();
            while (iterator.hasNext()) {
                event = (Event)iterator.next();
                event.addHandlesEventImports(this.imports);
                event.handledBy(this);
                this.eventRegistration.append(event.getRegisterForEvent());
                this.abstractMethods.append(event.getAbstractMethod());
            }
        }
        if (this.getFiresEventHasValue()) {
            iterator = this.getFiresEventIterable().iterator();
            while (iterator.hasNext()) {
                event = (Event)iterator.next();
                event.addFiresEventImports(this.imports);
                event.firedBy(this);
                this.fireMethods.append(event.getFireMethod());
            }
        }
        if (this.getInstantiatesViewHasValue()) {
            iterator = this.getInstantiatesViewIterable().iterator();
            while (iterator.hasNext()) {
                View view = (View)iterator.next();
                this.addUsesRunContextItem(view.getRunContextItem());
            }
        }
        if (this.getUsesRunContextItemHasValue()) {
            iterator = this.getUsesRunContextItemIterable().iterator();
            while (iterator.hasNext()) {
                RunContextItem rci = (RunContextItem)((Object)iterator.next());
                rci.addUsageImplImports(this.imports);
            }
        }
        if (this.getUseSchemaHasValue()) {
            this.imports.addImport("org.dmd.dmc.DmcOmni", "Support for schema loading");
            for (SchemaDefinition sd : this.getUseSchemaIterable()) {
                String capped = GenUtility.dotNameToCamelCase(sd.getName().getNameString());
                this.loadAttributeSchemas.append("        DmcOmni.instance().addCompactSchema(" + capped + "DMSAG.instance());\n");
                this.imports.addImport(sd.getSchemaPackage() + ".generated.dmo." + capped + "DMSAG", "Attribute schema");
            }
        }
        if (this.getSendsRequestHasValue()) {
            this.standardCommsInit();
            iterator = this.getSendsRequestIterable().iterator();
            while (iterator.hasNext()) {
                RequestTypeWithOptions request = (RequestTypeWithOptions)((Object)iterator.next());
                this.imports.addImport(request.getRequestImport(), "Component sends " + request.getRequestType() + "Requests");
                this.imports.addImport(request.getResponseImport(), "Component receives " + request.getRequestType() + "Responses");
                if (request.isUsingClassInfo()) {
                    this.imports.addImport(request.getClassImport(), "Component uses " + request.getClassName() + " objects");
                    if (request.getRequestType().equals("Set")) {
                        this.imports.addImport("org.dmd.dmc.DmcValueException", "Used when creating " + request.getRequestType() + "Requests");
                        this.imports.addImport("org.dmd.dms.generated.dmo.MetaDMSAG", "Used when creating " + request.getRequestType() + "Requests");
                    }
                }
                if (request.getRequestType().equals("Get") && request.getOptions().contains((Object)RequestOptionEnum.EVENTS)) {
                    this.imports.addImport("org.dmd.dmp.client.EventHandlerIF", "Handles events resulting from GetRequests");
                    this.imports.addImport("org.dmd.dmp.shared.generated.dmo.DMPEventDMO", "Events");
                    this.handlesObjectEvents = true;
                }
                if (request.getRequestType().equals("Action")) {
                    this.imports.addImport("org.dmd.dms.extended.ActionTriggerInfo", "Sends action requests");
                }
                this.addRequest(request);
            }
        }
        if (this.hasCommsMethods) {
            for (CommsHandler ch : this.commsHandlers.values()) {
                ch.addSendRequestFunction(this.commsMethods);
                ch.addHandlers(this.successCases, this.errorCases, this.rpcErrorCases, this.abstractMethods, this.objEventHandlers);
                this.commsConstants.append("    private final int " + ch.constant + " = " + ch.methodID + ";\n");
            }
            this.commsMethods.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            this.commsMethods.append("    @Override\n");
            this.commsMethods.append("    final public void handleResponse(ResponseDMO response){\n");
            this.commsMethods.append("        if (response.getResponseType() == ResponseTypeEnum.ERROR){\n");
            this.commsMethods.append("            switch(response.getHandlerID()){\n");
            this.commsMethods.append(this.errorCases.toString());
            this.commsMethods.append("            }\n");
            this.commsMethods.append("        }\n");
            this.commsMethods.append("        else{\n");
            this.commsMethods.append("            switch(response.getHandlerID()){\n");
            this.commsMethods.append(this.successCases.toString());
            this.commsMethods.append("            }\n");
            this.commsMethods.append("        }\n");
            this.commsMethods.append("    }\n\n");
            if (this.handlesObjectEvents) {
                this.commsMethods.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                this.commsMethods.append("    @Override\n");
                this.commsMethods.append("    final public void handleEvent(DMPEventDMO event){\n");
                this.commsMethods.append("        switch(event.getHandlerID()){\n");
                this.commsMethods.append(this.objEventHandlers.toString());
                this.commsMethods.append("        }\n");
                this.commsMethods.append("    }\n\n");
            }
            this.commsMethods.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            this.commsMethods.append("    @Override\n");
            this.commsMethods.append("    final public void handleRPCFailure(Throwable caught, RequestDMO request){\n");
            if (this.rpcErrorCases.length() == 0) {
                this.commsMethods.append("        throw(new IllegalStateException(\"RPC errors are supposed to be centrally handled!\"));\n");
            } else {
                this.commsMethods.append("        switch(request.getHandlerID()){\n");
                this.commsMethods.append(this.rpcErrorCases.toString());
                this.commsMethods.append("        }\n");
            }
            this.commsMethods.append("    }\n\n");
        }
        if (this.getUseBaseClass() != null) {
            this.imports.addImport(this.getUseBaseClass(), "Specified base class");
        }
        if (this.usesRunContext()) {
            this.imports.addImport("org.dmd.mvw.client.mvw.generated.mvw.MvwRunContextIF", "Need the run context");
        }
    }

    void addRequest(RequestTypeWithOptions rtwo) throws ResultException {
        CommsHandler ch = new CommsHandler(this.methodID++, rtwo);
        CommsHandler existing = this.commsHandlers.get(ch.key);
        if (existing != null) {
            ResultException ex = new ResultException();
            ex.addError("Duplicate function names for sendRequest attributes in a component: " + rtwo.getFunctionName());
            ex.result.lastResult().moreMessages("Existing request: sends" + existing.requestType + "Request");
            ex.result.lastResult().moreMessages(" Another request: sends" + rtwo.getRequestType() + "Request");
            ex.setLocationInfo(this.getFile(), this.getLineNumber().intValue());
            throw ex;
        }
        this.commsHandlers.put(ch.key, ch);
        if (ch.dmp == ErrorOptionsEnum.CENTRAL || ch.dmp == ErrorOptionsEnum.CENTRALANDLOCAL) {
            this.usesCentralDMPErrorHandler = true;
        }
        if (ch.rpc == ErrorOptionsEnum.CENTRAL || ch.rpc == ErrorOptionsEnum.CENTRALANDLOCAL) {
            this.usesCentralRPCErrorHandler = true;
        }
    }

    void standardCommsInit() {
        this.hasCommsMethods = true;
        this.imports.addImport("org.dmd.dmp.client.ResponseHandlerIF", "DMP communications");
        this.imports.addImport("org.dmd.dmp.client.ErrorOptionsEnum", "DMP communications");
        this.imports.addImport("org.dmd.dmp.shared.generated.dmo.RequestDMO", "DMP communications");
        this.imports.addImport("org.dmd.dmp.shared.generated.dmo.ResponseDMO", "DMP communications");
        this.imports.addImport("org.dmd.dmp.shared.generated.enums.ResponseTypeEnum", "DMP communications");
    }

    public String genSubPackage() {
        throw new IllegalStateException("Must overload genSubPackage()");
    }

    class CommsHandler {
        int methodID;
        RequestTypeWithOptions requestDef;
        String baseName;
        String key;
        String requestType;
        String constant;
        ErrorOptionsEnum rpc = ErrorOptionsEnum.CENTRAL;
        ErrorOptionsEnum dmp = ErrorOptionsEnum.CENTRAL;

        CommsHandler(int id, RequestTypeWithOptions rtwo) {
            this.methodID = id;
            this.requestDef = rtwo;
            this.baseName = GenUtility.capTheName(rtwo.getFunctionName());
            this.requestType = rtwo.getRequestType();
            this.key = this.baseName;
            this.constant = this.baseName.toUpperCase() + this.requestType.toUpperCase() + "CALLBACK";
            this.initErrorHandlingFlags();
        }

        void initErrorHandlingFlags() {
            boolean centralRpc = false;
            boolean localRpc = false;
            boolean centralDmp = false;
            boolean localDmp = false;
            if (this.requestDef != null) {
                if (this.requestDef.getOptions().contains((Object)RequestOptionEnum.CENTRALRPCERRORS) || this.requestDef.getOptions().contains((Object)RequestOptionEnum.CENTRALERRORS)) {
                    centralRpc = true;
                }
                if (this.requestDef.getOptions().contains((Object)RequestOptionEnum.CENTRALDMPERRORS) || this.requestDef.getOptions().contains((Object)RequestOptionEnum.CENTRALERRORS)) {
                    centralDmp = true;
                }
                if (this.requestDef.getOptions().contains((Object)RequestOptionEnum.RPCERRORS)) {
                    localRpc = true;
                }
                if (this.requestDef.getOptions().contains((Object)RequestOptionEnum.DMPERRORS)) {
                    localDmp = true;
                }
            }
            if (!centralDmp && !localDmp) {
                centralDmp = true;
            }
            if (!centralRpc && !localRpc) {
                centralRpc = true;
            }
            if (centralRpc && localRpc) {
                this.rpc = ErrorOptionsEnum.CENTRALANDLOCAL;
            } else if (centralRpc) {
                this.rpc = ErrorOptionsEnum.CENTRAL;
            } else if (localRpc) {
                this.rpc = ErrorOptionsEnum.LOCAL;
            }
            if (centralDmp && localDmp) {
                this.dmp = ErrorOptionsEnum.CENTRALANDLOCAL;
            } else if (centralDmp) {
                this.dmp = ErrorOptionsEnum.CENTRAL;
            } else if (localDmp) {
                this.dmp = ErrorOptionsEnum.LOCAL;
            }
        }

        void addSendRequestFunction(StringBuffer sb) {
            if (this.requestType.equals("Get") && this.requestDef.getOptions().contains((Object)RequestOptionEnum.EVENTS)) {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    protected void send" + this.baseName + "Request(" + this.requestType + "RequestDMO request){\n");
                sb.append("        commsController.send" + this.requestType + "Request(request,this,this,ErrorOptionsEnum." + (Object)((Object)this.rpc) + ",ErrorOptionsEnum." + (Object)((Object)this.dmp) + ");\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    protected void send" + this.baseName + "Request(" + this.requestType + "RequestDMO request){\n");
                sb.append("        commsController.send" + this.requestType + "Request(request,this,ErrorOptionsEnum." + (Object)((Object)this.rpc) + ",ErrorOptionsEnum." + (Object)((Object)this.dmp) + ");\n");
                sb.append("    }\n\n");
            }
            if (this.requestDef.isUsingClassInfo()) {
                if (this.requestDef.getRequestType().equals("Set")) {
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    protected " + this.requestType + "RequestDMO get" + this.baseName + "Request(" + this.requestDef.getClassName() + "DMO modrec){\n");
                    sb.append("        if (modrec.getModifier() == null)\n");
                    sb.append("            throw(new IllegalStateException(\"The DMO passed here should have a modifier.\"));\n");
                    sb.append("    \n");
                    sb.append("        " + this.requestType + "RequestDMO request = commsController.get" + this.requestType + "Request();\n");
                    sb.append("        request.setHandlerID(" + this.constant + ");\n");
                    sb.append("        request.setNotifyOriginator(true);\n");
                    sb.append("    \n");
                    sb.append("        request.setTarget(modrec.getObjectName());\n");
                    sb.append("        try{\n");
                    sb.append("            request.add(MetaDMSAG.__modify, modrec.getModifier());\n");
                    sb.append("            request.setTargetObjectClass(modrec.getConstructionClass());\n");
                    sb.append("        } catch (DmcValueException e) {\n");
                    sb.append("            throw(new IllegalStateException(\"Setting the modifier on a SetRequest shouldn't thrown an exception.\",e));\n");
                    sb.append("        }\n");
                    sb.append("    \n");
                    sb.append("        return(request);\n");
                    sb.append("    }\n\n");
                } else if (this.requestDef.getRequestType().equals("Create")) {
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    protected " + this.requestType + "RequestDMO get" + this.baseName + "Request(" + this.requestDef.getClassName() + "DMO newobj){\n");
                    sb.append("        " + this.requestType + "RequestDMO request = commsController.get" + this.requestType + "Request();\n");
                    sb.append("        request.setHandlerID(" + this.constant + ");\n");
                    sb.append("        request.setNotifyOriginator(true);\n");
                    sb.append("        request.setNewObject(newobj);\n");
                    sb.append("        return(request);\n");
                    sb.append("    }\n\n");
                }
            } else if (this.requestType.equals("Action")) {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    protected " + this.requestType + "RequestDMO get" + this.baseName + "Request(ActionTriggerInfo ati){\n");
                sb.append("        " + this.requestType + "RequestDMO request = commsController.get" + this.requestType + "Request(ati);\n");
                sb.append("        request.setHandlerID(" + this.constant + ");\n");
                sb.append("        request.setNotifyOriginator(true);\n");
                sb.append("        return(request);\n");
                sb.append("    }\n\n");
            } else {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    protected " + this.requestType + "RequestDMO get" + this.baseName + "Request(){\n");
                sb.append("        " + this.requestType + "RequestDMO request = commsController.get" + this.requestType + "Request();\n");
                if (this.requestType.equals("Get") && this.requestDef.getOptions().contains((Object)RequestOptionEnum.EVENTS)) {
                    sb.append("        request.setRegisterForEvents(true);\n");
                }
                sb.append("        request.setHandlerID(" + this.constant + ");\n");
                sb.append("        request.setNotifyOriginator(true);\n");
                sb.append("        return(request);\n");
                sb.append("    }\n\n");
                if (this.requestType.equals("Get") && this.requestDef.getOptions().contains((Object)RequestOptionEnum.EVENTS)) {
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    protected void denotifyFor" + this.baseName + "Events(){\n");
                    sb.append("        // TODO: fill in denotify request and send it\n");
                    sb.append("    }\n\n");
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    protected void handle" + this.baseName + "Event(){\n");
                    sb.append("        // TODO: fill in denotify request and send it\n");
                    sb.append("    }\n\n");
                }
            }
        }

        void addHandlers(StringBuffer success, StringBuffer dmpError, StringBuffer rpcError, StringBuffer abstractFunctions, StringBuffer objEventHandlers) {
            boolean dmp = false;
            boolean rpc = false;
            if (this.requestDef != null) {
                dmp = this.requestDef.getOptions().contains((Object)RequestOptionEnum.DMPERRORS);
                rpc = this.requestDef.getOptions().contains((Object)RequestOptionEnum.RPCERRORS);
            }
            String responseCast = this.requestType + "ResponseDMO";
            String requestCast = this.requestType + "RequestDMO";
            if (dmp) {
                dmpError.append("            case " + this.constant + ":\n");
                dmpError.append("                handle" + this.baseName + "ResponseError((" + responseCast + ")response);\n");
                dmpError.append("                break;\n");
                abstractFunctions.append("    abstract protected void handle" + this.baseName + "ResponseError(" + responseCast + " response);\n\n");
            } else {
                dmpError.append("            case " + this.constant + ":\n");
                dmpError.append("                throw(new IllegalStateException(\"DMP errors for " + this.baseName + " are supposed to be centrally handled!\"));\n");
            }
            if (rpc) {
                rpcError.append("        case " + this.constant + ":\n");
                rpcError.append("            handle" + this.baseName + "ResponseRPCError(caught,(" + requestCast + ")request);\n");
                rpcError.append("            break;\n");
                abstractFunctions.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                abstractFunctions.append("    abstract protected void handle" + this.baseName + "ResponseRPCError(Throwable caught, " + requestCast + " request);\n\n");
            } else {
                rpcError.append("        case " + this.constant + ":\n");
                rpcError.append("            throw(new IllegalStateException(\"RPC errors for " + this.baseName + " are supposed to be centrally handled!\"));\n");
            }
            success.append("            case " + this.constant + ":\n");
            success.append("                handle" + this.baseName + "Response((" + responseCast + ")response);\n");
            success.append("                break;\n");
            abstractFunctions.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            abstractFunctions.append("    abstract protected void handle" + this.baseName + "Response(" + responseCast + " response);\n\n");
            if (this.requestType.equals("Get") && this.requestDef.getOptions().contains((Object)RequestOptionEnum.EVENTS)) {
                abstractFunctions.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                abstractFunctions.append("    abstract protected void handleEventFrom" + this.baseName + "(DMPEventDMO event);\n\n");
                objEventHandlers.append("        case " + this.constant + ":\n");
                objEventHandlers.append("            handleEventFrom" + this.baseName + "(event);\n");
                objEventHandlers.append("            break;\n");
            }
        }
    }
}

