/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.extended;

import java.util.Iterator;
import org.dmd.mvw.tools.mvwgenerator.extended.CodeGenComponentIF;
import org.dmd.mvw.tools.mvwgenerator.extended.Presenter;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.ActionBinding;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.ControllerDMW;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.util.exceptions.ResultException;

public class Controller
extends ControllerDMW
implements CodeGenComponentIF {
    StringBuffer controllerInterfaces;
    RunContextItem runContextItem;

    @Override
    public void resetCodeGenInfo() {
        super.resetCodeGenInfo();
        this.initialized = false;
        this.controllerInterfaces = null;
    }

    @Override
    public boolean usesRunContext() {
        super.usesRunContext();
        if (this.getImplementsActionHasValue()) {
            this.usesRunContext.set(true);
        }
        return this.usesRunContext.booleanValue();
    }

    public void setRunContextItem(RunContextItem i) {
        this.runContextItem = i;
    }

    public RunContextItem getRunContextItem() {
        return this.runContextItem;
    }

    public String getControllerInterfaces() {
        if (this.hasCommsMethods()) {
            this.controllerInterfaces.append("implements ResponseHandlerIF");
            if (this.handlesObjectEvents()) {
                this.controllerInterfaces.append(", EventHandlerIF");
            }
        }
        if (this.isCentralDMPErrorHandler().booleanValue()) {
            if (this.controllerInterfaces.length() > 0) {
                this.controllerInterfaces.append(", ");
            } else {
                this.controllerInterfaces.append("implements ");
            }
            this.controllerInterfaces.append("CentralDMPErrorHandlerIF");
        }
        if (this.isCentralRPCErrorHandler().booleanValue()) {
            if (this.controllerInterfaces.length() > 0) {
                this.controllerInterfaces.append(", ");
            } else {
                this.controllerInterfaces.append("implements ");
            }
            this.controllerInterfaces.append("CentralRPCErrorHandlerIF");
        }
        if (this.isCentralAsyncErrorHandler().booleanValue()) {
            if (this.controllerInterfaces.length() > 0) {
                this.controllerInterfaces.append(", ");
            } else {
                this.controllerInterfaces.append("implements ");
            }
            this.controllerInterfaces.append("MvwAsyncErrorHandlerIF");
        }
        if (this.controllerInterfaces.length() > 0) {
            this.controllerInterfaces.append(" ");
        }
        return this.controllerInterfaces.toString();
    }

    @Override
    public void initCodeGenInfo(boolean rpc, boolean dmp) throws ResultException {
        if (!this.initialized) {
            Iterator iterator;
            this.initialized = true;
            if (this.getInstantiatesPresenterHasValue()) {
                iterator = this.getInstantiatesPresenterIterable().iterator();
                while (iterator.hasNext()) {
                    Presenter presenter = (Presenter)iterator.next();
                    this.addUsesRunContextItem(presenter.getRunContextItem());
                }
            }
            super.initCodeGenInfo(rpc, dmp);
            if (this.isCentralDMPErrorHandler().booleanValue()) {
                this.imports.addImport("org.dmd.dmp.client.CentralDMPErrorHandlerIF", "Is the central DMP error handler");
            }
            if (this.isCentralRPCErrorHandler().booleanValue()) {
                this.imports.addImport("org.dmd.dmp.client.CentralRPCErrorHandlerIF", "Is the central RPC error handler");
            }
            if (this.isCentralAsyncErrorHandler().booleanValue()) {
                this.imports.addImport("org.dmd.mvw.client.mvw.MvwAsyncErrorHandlerIF", "Is the central async code error handler");
            }
            if (this.getImplementsActionHasValue()) {
                iterator = this.getImplementsActionIterable().iterator();
                while (iterator.hasNext()) {
                    ActionBinding action = (ActionBinding)iterator.next();
                    String capped = GenUtility.capTheName(action.getActionBindingName().getNameString());
                    String cappedAction = GenUtility.capTheName(action.getActionBindingName().getNameString()) + "Action";
                    this.actionVariables.append("    protected final " + cappedAction + " " + action.getActionBindingName() + ";\n");
                    this.actionInstantiations.append("\n");
                    this.actionInstantiations.append("        " + action.getActionBindingName() + " = new " + cappedAction + "(this);\n");
                    this.actionInstantiations.append("        MenuControllerRCI.addAction(" + action.getActionBindingName() + ");\n");
                    String i = this.getDefinedInModule().getGenPackage() + ".generated.mvw.actions." + cappedAction;
                    this.imports.addImport(i, "The " + action.getActionBindingName() + " action");
                    this.imports.addImport("org.dmd.mvw.client.mvwmenus.interfaces.TriggerIF", "Required by actions");
                    this.abstractMethods.append("\n");
                    this.abstractMethods.append("    abstract public void execute" + capped + "(TriggerIF trigger, Object widgetEvent);\n");
                }
            }
            this.controllerInterfaces = new StringBuffer();
        }
    }

    public String getExtendedClassPackage() {
        if (this.getSubpackage() == null) {
            return this.getDefinedInModule().getGenPackage() + ".extended";
        }
        return this.getDefinedInModule().getGenPackage() + ".extended." + this.getSubpackage();
    }

    public String getBaseImplImport() {
        return this.getDefinedInModule().getGenPackage() + ".generated.mvw.controllers." + this.getControllerName() + "BaseImpl";
    }

    @Override
    public String genSubPackage() {
        return "controllers";
    }
}

