/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.extended;

import java.util.ArrayList;
import java.util.TreeMap;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.dmw.DmwWrapper;
import org.dmd.mvw.tools.mvwgenerator.extended.CodeGenComponentIF;
import org.dmd.mvw.tools.mvwgenerator.extended.MvwDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.View;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.EventDMW;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class Event
extends EventDMW
implements CodeGenComponentIF {
    boolean initialized;
    int longestType;
    ArrayList<String> types;
    ArrayList<String> members;
    ArrayList<View> local;
    TreeMap<CamelCaseName, MvwDefinition> localSorted;
    ArrayList<MvwDefinition> firedBy;
    TreeMap<CamelCaseName, MvwDefinition> firedBySorted;
    ArrayList<MvwDefinition> handledBy;
    TreeMap<CamelCaseName, MvwDefinition> handledBySorted;
    StringBuffer registerForEvent;
    StringBuffer abstractMethod;
    ImportManager imports;

    void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.types = new ArrayList();
            this.members = new ArrayList();
            this.registerForEvent = new StringBuffer();
            this.abstractMethod = new StringBuffer();
            this.imports = new ImportManager();
            if (this.getImportThisHasValue()) {
                for (String imp : this.getImportThisIterable()) {
                    this.imports.addImport(imp, "Required type");
                }
            }
            if (!this.getArgVector().equals("()")) {
                String t1 = this.getArgVector().substring(1, this.getArgVector().length() - 1);
                String[] terms = t1.split(",");
                for (int i = 0; i < terms.length; ++i) {
                    if (terms[i].length() == 0) continue;
                    String currentTerm = terms[i].trim();
                    int spacepos = currentTerm.indexOf(" ");
                    if (spacepos == -1) {
                        throw new IllegalStateException("Invalid argument vector: " + this.getArgVector() + "\nWhile formatting event:\n\n" + this.toOIF());
                    }
                    String type = currentTerm.substring(0, spacepos);
                    String member = currentTerm.substring(spacepos + 1);
                    this.types.add(type);
                    this.members.add(member);
                    if (type.length() <= this.longestType) continue;
                    this.longestType = type.length();
                }
                StringBuffer av = new StringBuffer();
                for (int i = 0; i < this.types.size(); ++i) {
                    int argcount = i + 1;
                    if (i > 0) {
                        av.append(", ");
                    }
                    av.append(this.types.get(i) + " arg" + argcount);
                }
            }
            String capped = GenUtility.capTheName(this.getEventName().getNameString());
            this.registerForEvent.append("        eventBus.addHandler(" + capped + ".TYPE,\n");
            this.registerForEvent.append("            new " + capped + "Handler() {\n");
            this.registerForEvent.append("                public void handle" + capped + "(" + capped + " event) {\n");
            this.registerForEvent.append("                    on" + capped + "(" + this.getValuesFromEvent() + ");\n");
            this.registerForEvent.append("                }\n");
            this.registerForEvent.append("            });\n\n");
            this.abstractMethod.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            this.abstractMethod.append("    abstract public void on" + capped + "(");
            if (this.types.size() > 0) {
                boolean first = true;
                for (int i = 0; i < this.types.size(); ++i) {
                    if (first) {
                        first = false;
                    } else {
                        this.abstractMethod.append(", ");
                    }
                    this.abstractMethod.append(this.types.get(i) + " " + this.members.get(i));
                }
            }
            this.abstractMethod.append(");\n\n");
        }
    }

    public void showReferences() {
        if (this.isReferenced()) {
            System.out.println("Event - " + this.getCamelCaseName() + " is referenced by");
            for (DmwWrapper wrapper : this.getReferringObjects()) {
                MvwDefinition def = (MvwDefinition)wrapper;
                System.out.println("    " + def.getCamelCaseName().toString());
            }
        }
    }

    public TreeMap<CamelCaseName, MvwDefinition> getFiredBy() {
        if (this.firedBySorted == null) {
            this.firedBySorted = new TreeMap();
            if (this.firedBy != null) {
                for (MvwDefinition def : this.firedBy) {
                    this.firedBySorted.put(def.getCamelCaseName(), def);
                }
            }
        }
        return this.firedBySorted;
    }

    public TreeMap<CamelCaseName, MvwDefinition> getHandledBy() {
        if (this.handledBySorted == null) {
            this.handledBySorted = new TreeMap();
            if (this.handledBy != null) {
                for (MvwDefinition def : this.handledBy) {
                    this.handledBySorted.put(def.getCamelCaseName(), def);
                }
            }
        }
        return this.handledBySorted;
    }

    public TreeMap<CamelCaseName, MvwDefinition> getLocallyFired() {
        if (this.localSorted == null) {
            this.localSorted = new TreeMap();
            if (this.local != null) {
                for (MvwDefinition mvwDefinition : this.local) {
                    this.localSorted.put(mvwDefinition.getCamelCaseName(), mvwDefinition);
                }
            }
        }
        return this.localSorted;
    }

    public void addImport(ImportManager im) {
        im.addImport(this.getDefinedInModule().getGenPackage() + ".generated.mvw.events." + this.getEventName(), "Required by " + this.getEventName());
        im.addImportsFrom(this.imports);
    }

    public void addFiresEventImports(ImportManager im) {
        this.initialize();
        im.addImportsFrom(this.imports);
        im.addImport(this.getDefinedInModule().getGenPackage() + ".generated.mvw.events." + this.getEventName(), "Required by " + this.getEventName());
    }

    public void addHandlesEventImports(ImportManager im) {
        this.initialize();
        im.addImportsFrom(this.imports);
        im.addImport(this.getDefinedInModule().getGenPackage() + ".generated.mvw.events." + this.getEventName(), "Required by " + this.getEventName());
        im.addImport(this.getDefinedInModule().getGenPackage() + ".generated.mvw.events." + this.getEventName() + "Handler", "Required by " + this.getEventName());
    }

    public String getAbstractMethod() {
        this.initialize();
        return this.abstractMethod.toString();
    }

    public String getRegisterForEvent() {
        this.initialize();
        return this.registerForEvent.toString();
    }

    String getValuesFromEvent() {
        StringBuffer sb = new StringBuffer();
        if (this.types.size() > 0) {
            boolean first = true;
            for (String val : this.members) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                String capped = GenUtility.capTheName(val);
                sb.append("event.get" + capped + "()");
            }
        }
        return sb.toString();
    }

    public ArrayList<String> getTypes() {
        this.initialize();
        return this.types;
    }

    public ArrayList<String> getMembers() {
        this.initialize();
        return this.members;
    }

    public int getLongestType() {
        this.initialize();
        return this.longestType;
    }

    public void firedLocally(View v) {
        if (this.local == null) {
            this.local = new ArrayList();
        }
        this.local.add(v);
    }

    public void firedBy(MvwDefinition d) {
        if (this.firedBy == null) {
            this.firedBy = new ArrayList();
        }
        this.firedBy.add(d);
    }

    public void handledBy(MvwDefinition d) {
        if (this.handledBy == null) {
            this.handledBy = new ArrayList();
        }
        this.handledBy.add(d);
    }

    public void checkSanity() throws ResultException {
        if (this.handledBy != null && this.firedBy == null && this.isFiredInThisModule().booleanValue()) {
            ResultException ex = new ResultException();
            ex.addError("The " + this.getEventName() + " is handled by the following components, but is never fired or broadcast:");
            for (MvwDefinition def : this.handledBy) {
                ex.result.lastResult().moreMessages(def.getConstructionClassName() + ":" + def.getObjectName() + " defined in: " + def.getFile());
            }
            if (this.local != null) {
                ex.result.lastResult().moreMessages(" ");
                ex.result.lastResult().moreMessages("The event is fired locally by View:");
                for (View view : this.local) {
                    ex.result.lastResult().moreMessages(view.getViewName() + " defined in: " + view.getFile());
                }
            }
            throw ex;
        }
    }

    public boolean needGwtEvent() throws ResultException {
        if (!this.isFiredInThisModule().booleanValue()) {
            return true;
        }
        if (this.handledBy != null && this.firedBy == null) {
            StringBuffer sb = new StringBuffer();
            for (MvwDefinition def : this.handledBy) {
                sb.append(def.getObjectName() + " ");
            }
            ResultException ex = new ResultException();
            ex.addError("The " + this.getEventName() + " is handled by: " + sb.toString() + " but is never fired.");
            throw ex;
        }
        return this.firedBy != null || this.handledBy != null;
    }

    public String getViewLocalMethod() {
        this.initialize();
        String capped = GenUtility.capTheName(this.getEventName().getNameString());
        StringBuffer sb = new StringBuffer();
        sb.append("    // " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    protected void fire" + capped + this.getArgVector() + "{\n");
        sb.append("        presenter.on" + capped + "(");
        boolean first = true;
        for (String arg : this.members) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(arg);
        }
        sb.append(");\n");
        sb.append("    }\n\n");
        return sb.toString();
    }

    public String getViewBroadcastMethod() {
        this.initialize();
        String capped = GenUtility.capTheName(this.getEventName().getNameString());
        StringBuffer sb = new StringBuffer();
        StringBuffer args = new StringBuffer();
        args.append("(");
        boolean first = true;
        for (String arg : this.members) {
            if (first) {
                first = false;
            } else {
                args.append(", ");
            }
            args.append(arg);
        }
        args.append(")");
        sb.append("    // " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    protected void fire" + capped + this.getArgVector() + "{\n");
        sb.append("        presenter.on" + capped + args.toString() + ";\n");
        sb.append("        eventBus.fireEvent(new " + capped + args.toString() + ");\n");
        sb.append("    }\n\n");
        return sb.toString();
    }

    public String getViewBroadcastOnlyMethod() {
        this.initialize();
        String capped = GenUtility.capTheName(this.getEventName().getNameString());
        StringBuffer sb = new StringBuffer();
        StringBuffer args = new StringBuffer();
        args.append("(");
        boolean first = true;
        for (String arg : this.members) {
            if (first) {
                first = false;
            } else {
                args.append(", ");
            }
            args.append(arg);
        }
        args.append(")");
        sb.append("    // " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    protected void fire" + capped + this.getArgVector() + "{\n");
        sb.append("        eventBus.fireEvent(new " + capped + args.toString() + ");\n");
        sb.append("    }\n\n");
        return sb.toString();
    }

    public String getFireMethod() {
        this.initialize();
        String capped = GenUtility.capTheName(this.getEventName().getNameString());
        StringBuffer sb = new StringBuffer();
        StringBuffer args = new StringBuffer();
        args.append("(");
        boolean first = true;
        for (String arg : this.members) {
            if (first) {
                first = false;
            } else {
                args.append(", ");
            }
            args.append(arg);
        }
        args.append(")");
        sb.append("    // " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        sb.append("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    protected void fire" + capped + this.getArgVector() + "{\n");
        sb.append("        eventBus.fireEvent(new " + capped + args.toString() + ");\n");
        sb.append("    }\n\n");
        return sb.toString();
    }

    @Override
    public void resetCodeGenInfo() {
        this.initialized = false;
        this.longestType = 0;
        this.types = null;
        this.members = null;
        this.local = null;
        this.localSorted = null;
        this.firedBy = null;
        this.firedBySorted = null;
        this.handledBy = null;
        this.handledBySorted = null;
        this.registerForEvent = null;
        this.abstractMethod = null;
        this.imports = null;
    }
}

