/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.extended;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.dmw.DmwWrapper;
import org.dmd.mvw.tools.mvwgenerator.extended.Activity;
import org.dmd.mvw.tools.mvwgenerator.extended.Controller;
import org.dmd.mvw.tools.mvwgenerator.extended.MvwDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.Place;
import org.dmd.mvw.tools.mvwgenerator.extended.Presenter;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.mvw.tools.mvwgenerator.extended.View;
import org.dmd.mvw.tools.mvwgenerator.extended.WebApplication;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.FieldEditorDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.FormBindingDefinition;
import org.dmd.mvw.tools.mvwgenerator.generated.dmo.MvwDMSAG;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.ModuleDMW;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.util.exceptions.DebugInfo;

public class Module
extends ModuleDMW {
    ArrayList<RunContextItem> runContextItems = new ArrayList();
    TreeMap<CamelCaseName, WebApplication> applications;
    TreeMap<CamelCaseName, Controller> controllers;
    TreeMap<CamelCaseName, Presenter> presenters;
    TreeMap<CamelCaseName, View> views;
    TreeMap<CamelCaseName, Place> places;
    TreeMap<CamelCaseName, Activity> activities;
    TreeMap<CamelCaseName, RunContextItem> contextItems;
    TreeMap<CamelCaseName, FormBindingDefinition> bindings;
    TreeMap<CamelCaseName, FieldEditorDefinition> editors;

    public void addRunContextItem(RunContextItem rci) {
        this.runContextItems.add(rci);
    }

    public String getContextName() {
        if (this.runContextItems.size() == 0) {
            return "";
        }
        String capped = GenUtility.capTheName(this.getModuleName().getNameString());
        return capped + "RunContextIF";
    }

    public String getContextImport() {
        if (this.runContextItems.size() == 0) {
            return "";
        }
        String capped = GenUtility.capTheName(this.getModuleName().getNameString());
        return this.getGenPackage() + ".generated.mvw." + capped + "RunContextIF";
    }

    public int contextItemCount() {
        return this.runContextItems.size();
    }

    public Iterator<RunContextItem> getItems() {
        return this.runContextItems.iterator();
    }

    public void initAssociatedDefintions() {
        this.applications = new TreeMap();
        this.controllers = new TreeMap();
        this.presenters = new TreeMap();
        this.views = new TreeMap();
        this.places = new TreeMap();
        this.activities = new TreeMap();
        this.contextItems = new TreeMap();
        this.bindings = new TreeMap();
        this.editors = new TreeMap();
        DebugInfo.debug((String)this.getBackRefs());
        ArrayList definedIn = this.getReferringObjectsViaAttribute(MvwDMSAG.__definedInModule);
        for (DmwWrapper wrapper : definedIn) {
            MvwDefinition def = (MvwDefinition)wrapper;
            if (def instanceof WebApplication) {
                this.applications.put(def.getCamelCaseName(), (WebApplication)def);
                continue;
            }
            if (def instanceof Controller) {
                this.controllers.put(def.getCamelCaseName(), (Controller)def);
                continue;
            }
            if (def instanceof Presenter) {
                this.presenters.put(def.getCamelCaseName(), (Presenter)def);
                continue;
            }
            if (def instanceof View) {
                this.views.put(def.getCamelCaseName(), (View)def);
                continue;
            }
            if (def instanceof Place) {
                this.places.put(def.getCamelCaseName(), (Place)def);
                continue;
            }
            if (def instanceof Activity) {
                this.activities.put(def.getCamelCaseName(), (Activity)def);
                continue;
            }
            if (def instanceof RunContextItem) {
                this.contextItems.put(def.getCamelCaseName(), (RunContextItem)def);
                continue;
            }
            if (def instanceof FormBindingDefinition) {
                this.bindings.put(def.getCamelCaseName(), (FormBindingDefinition)def);
                continue;
            }
            if (!(def instanceof FieldEditorDefinition)) continue;
            this.editors.put(def.getCamelCaseName(), (FieldEditorDefinition)def);
        }
    }

    public ArrayList<RunContextItem> getRunContextItems() {
        return this.runContextItems;
    }

    public TreeMap<CamelCaseName, WebApplication> getApplications() {
        return this.applications;
    }

    public TreeMap<CamelCaseName, Controller> getControllers() {
        return this.controllers;
    }

    public TreeMap<CamelCaseName, Presenter> getPresenters() {
        return this.presenters;
    }

    public TreeMap<CamelCaseName, View> getViews() {
        return this.views;
    }

    public TreeMap<CamelCaseName, Place> getPlaces() {
        return this.places;
    }

    public TreeMap<CamelCaseName, Activity> getActivities() {
        return this.activities;
    }

    public TreeMap<CamelCaseName, RunContextItem> getContextItems() {
        return this.contextItems;
    }

    public TreeMap<CamelCaseName, FormBindingDefinition> getBindings() {
        return this.bindings;
    }

    public TreeMap<CamelCaseName, FieldEditorDefinition> getEditors() {
        return this.editors;
    }
}

