/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.extended;

import org.dmd.dmc.DmcValueException;
import org.dmd.dms.ClassDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.Presenter;
import org.dmd.mvw.tools.mvwgenerator.extended.View;
import org.dmd.mvw.tools.mvwgenerator.extended.WebApplication;
import org.dmd.mvw.tools.mvwgenerator.generated.dmo.RunContextItemDMO;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.RunContextItemDMW;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.formatting.PrintfFormat;

public class RunContextItem
extends RunContextItemDMW {
    String sortKey;
    View view;
    Presenter presenter;

    public RunContextItem() {
    }

    public RunContextItem(RunContextItemDMO dmo, ClassDefinition cd) {
        super(dmo, cd);
    }

    @Override
    public void setItemName(Object value) throws DmcValueException {
        super.setItemName(value);
        this.setCamelCaseName(value);
    }

    public void setView(View v) {
        this.view = v;
    }

    public void setPresenter(Presenter p) {
        this.presenter = p;
    }

    public String getPlainName() {
        int rci = this.getItemName().getNameString().indexOf("RCI");
        if (rci == -1) {
            return this.getItemName().getNameString();
        }
        return this.getItemName().getNameString().substring(0, rci);
    }

    public String getSortKey() {
        if (this.sortKey == null) {
            String tmp = this.getItemOrder().toString();
            if (tmp.length() == 4) {
                this.sortKey = tmp + this.getItemName().getNameString();
            }
            if (tmp.length() == 3) {
                this.sortKey = "0" + tmp + this.getItemName().getNameString();
            } else if (tmp.length() == 2) {
                this.sortKey = "00" + tmp + this.getItemName().getNameString();
            } else if (tmp.length() == 1) {
                this.sortKey = "000" + tmp + this.getItemName().getNameString();
            } else {
                throw new IllegalStateException("RunContextItem itemOrder must be 4 digits or less!");
            }
        }
        return this.sortKey;
    }

    public String getItemType() {
        int lastdot = this.getUseClass().lastIndexOf(".");
        return this.getUseClass().substring(lastdot + 1);
    }

    public String getDefinition(PrintfFormat format) {
        if (!this.isSingleton().booleanValue() && this.isCreateOnDemand().booleanValue()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("    // Defined in module: " + this.getDefinedInModule().getCamelCaseName() + "\n");
        if (this.isSingleton().booleanValue()) {
            sb.append("    private " + format.sprintf(this.getItemType()) + " " + this.getItemName() + ";\n\n");
        } else {
            sb.append("    private final " + format.sprintf(this.getItemType()) + " " + this.getItemName() + ";\n\n");
        }
        return sb.toString();
    }

    public String getInstantiation(PrintfFormat format) {
        if (this.isCreateOnDemand().booleanValue()) {
            return "";
        }
        return "        " + format.sprintf((Object)this.getItemName()) + " = " + this.getConstruction() + ";\n";
    }

    public String getImplVariable() {
        if (this.isCreateOnDemand().booleanValue()) {
            if (this.isSingleton().booleanValue()) {
                return "    private " + this.getItemType() + " " + this.getItemName() + ";\n";
            }
            return "";
        }
        return "    protected final " + this.getItemType() + " " + this.getItemName() + ";\n";
    }

    public String getOnDemandMethod() {
        if (this.isCreateOnDemand().booleanValue()) {
            String capped = GenUtility.capTheName(this.getItemName().getNameString());
            StringBuilder sb = new StringBuilder();
            if (this.view != null) {
                if (this.view.isCodeSplit().booleanValue()) {
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void get" + this.getPlainName() + "Async(){\n");
                    sb.append("        ((" + this.getRunContextInterfaceName() + ")runcontext).get" + capped + "(this, this);\n");
                    sb.append("    }\n\n");
                } else {
                    String pres = this.view.getViewName() + "IF." + this.view.getViewName() + "PresenterIF";
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + this.getItemType() + " getNew" + this.getPlainName() + "(" + pres + " presenter){\n");
                    sb.append("        return( ((" + this.getRunContextInterfaceName() + ")runcontext).get" + capped + "(presenter));\n");
                    sb.append("    }\n\n");
                }
            }
            if (this.presenter != null) {
                if (this.presenter.isCodeSplit().booleanValue()) {
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public void get" + this.getPlainName() + "Async(){\n");
                    sb.append("        ((" + this.getRunContextInterfaceName() + ")runcontext).get" + capped + "(this);\n");
                    sb.append("    }\n\n");
                } else if (this.isSingleton().booleanValue()) {
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + this.getItemType() + " get" + this.getPlainName() + "(){\n");
                    sb.append("        return( ((" + this.getRunContextInterfaceName() + ")runcontext).get" + capped + "());\n");
                    sb.append("    }\n\n");
                } else {
                    sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                    sb.append("    public " + this.getItemType() + " getNew" + this.getPlainName() + "(){\n");
                    sb.append("        return( ((" + this.getRunContextInterfaceName() + ")runcontext).get" + capped + "());\n");
                    sb.append("    }\n\n");
                }
            }
            return sb.toString();
        }
        return "";
    }

    public String getImplVariableAssignment() {
        if (this.isCreateOnDemand().booleanValue()) {
            return "";
        }
        String capped = GenUtility.capTheName(this.getItemName().getNameString());
        return "        " + this.getItemName() + " = ((" + this.getRunContextInterfaceName() + ")rc).get" + capped + "();\n";
    }

    public String getInterfaceMethod(PrintfFormat format) {
        String capped = GenUtility.capTheName(this.getItemName().getNameString());
        StringBuilder sb = new StringBuilder();
        if (this.view != null) {
            String pres = this.view.getViewName() + "IF." + this.view.getViewName() + "PresenterIF";
            if (this.view.isCodeSplit().booleanValue()) {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + format.sprintf("void") + " get" + capped + "(" + pres + " presenter, " + this.view.getAsyncInterface() + " requester);\n\n");
            } else {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + format.sprintf(this.getItemType()) + " get" + capped + "(" + pres + " presenter);\n\n");
            }
        }
        if (this.presenter != null) {
            if (this.presenter.isCodeSplit().booleanValue()) {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + format.sprintf("void") + " get" + capped + "(" + this.presenter.getAsyncInterface() + " requester);\n\n");
            } else {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + format.sprintf(this.getItemType()) + " get" + capped + "();\n\n");
            }
        }
        if (this.view == null && this.presenter == null) {
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + format.sprintf(this.getItemType()) + " get" + capped + "();\n\n");
        }
        return sb.toString();
    }

    public String getImplMethod(WebApplication app) {
        String capped = GenUtility.capTheName(this.getItemName().getNameString());
        StringBuilder sb = new StringBuilder();
        if (this.isCreateOnDemand().booleanValue()) {
            if (this.presenter != null) {
                return this.getPresenterImplMethod(app);
            }
            if (this.view != null) {
                return this.getViewImplMethod(app);
            }
        } else {
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    @Override\n");
            sb.append("    public " + this.getItemType() + " get" + capped + "(){\n");
            sb.append("        return(" + this.getItemName() + ");\n");
            sb.append("    }\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    String getPresenterImplMethod(WebApplication app) {
        String capped = GenUtility.capTheName(this.getItemName().getNameString());
        StringBuilder sb = new StringBuilder();
        if (this.presenter.isCodeSplit().booleanValue()) {
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    @Override\n");
            sb.append("    public void get" + capped + "(final " + this.presenter.getAsyncInterface() + " requester){\n");
            if (this.isSingleton().booleanValue()) {
                sb.append("        if (" + this.getItemName() + " == null){\n");
                sb.append("            final " + app.getRunContextName() + " thisContext = this;\n");
                sb.append("            GWT.runAsync(new RunAsyncCallback() {\n");
                sb.append("\n");
                sb.append("                @Override\n");
                sb.append("                public void onSuccess() {\n");
                sb.append("                    " + this.getItemName() + " = " + this.getConstruction() + ";\n");
                sb.append("                    requester.async" + this.presenter.getPresenterName() + "Ready(" + this.getItemName() + ");\n");
                sb.append("                }\n");
                sb.append("\n");
                sb.append("                @Override\n");
                sb.append("                public void onFailure(Throwable reason) {\n");
                sb.append("                    centralAsyncErrorHandler.handleAsyncCodeError(\"" + this.getConstruction() + "\",reason);\n");
                sb.append("                }\n");
                sb.append("            });\n");
                sb.append("        }\n");
                sb.append("        else\n");
                sb.append("            requester.async" + this.presenter.getPresenterName() + "Ready(" + this.getItemName() + ");\n");
            } else {
                sb.append("        GWT.runAsync(new RunAsyncCallback() {\n");
                sb.append("        \t\n");
                sb.append("        \t   @Override\n");
                sb.append("        \t   public void onSuccess() {\n");
                sb.append("               requester.async" + this.presenter.getPresenterName() + "Ready(" + this.getConstruction() + ");\n");
                sb.append("        \t   }\n");
                sb.append("        \t\n");
                sb.append("        \t   @Override\n");
                sb.append("        \t   public void onFailure(Throwable reason) {\n");
                sb.append("        \t\t   centralAsyncErrorHandler.handleAsyncCodeError(\"" + this.getConstruction() + "\",reason);\n");
                sb.append("        \t   }\n");
                sb.append("        });\n");
            }
            sb.append("    }\n");
            sb.append("\n");
        } else {
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    @Override\n");
            sb.append("    public " + this.getItemType() + " get" + capped + "(){\n");
            if (this.isSingleton().booleanValue()) {
                sb.append("        if (" + this.getItemName() + " == null)\n");
                sb.append("            " + this.getItemName() + " = " + this.getConstruction() + ";\n");
                sb.append("        return(" + this.getItemName() + ");\n");
            } else {
                sb.append("        return(" + this.getConstruction() + ");\n");
            }
            sb.append("    }\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    String getViewImplMethod(WebApplication app) {
        String capped = GenUtility.capTheName(this.getItemName().getNameString());
        StringBuilder sb = new StringBuilder();
        String pres = this.view.getViewName() + "IF." + this.view.getViewName() + "PresenterIF";
        if (this.view.isCodeSplit().booleanValue()) {
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    @Override\n");
            sb.append("    public void get" + capped + "(final " + pres + " presenter, final " + this.view.getAsyncInterface() + " requester){\n");
            if (this.view.getUsesRunContextItemHasValue()) {
                sb.append("        final " + app.getRunContextName() + " thisContext = this;\n");
            }
            sb.append("        GWT.runAsync(new RunAsyncCallback() {\n");
            sb.append("        \t\n");
            sb.append("        \t   @Override\n");
            sb.append("        \t   public void onSuccess() {\n");
            sb.append("                requester.async" + this.view.getViewName() + "Ready(" + this.getConstruction() + ");\n");
            sb.append("        \t   }\n");
            sb.append("        \t\n");
            sb.append("        \t   @Override\n");
            sb.append("        \t   public void onFailure(Throwable reason) {\n");
            sb.append("        \t\t   centralAsyncErrorHandler.handleAsyncCodeError(\"" + this.getConstruction() + "\",reason);\n");
            sb.append("        \t   }\n");
            sb.append("        });\n");
            sb.append("    }\n");
            sb.append("\n");
        } else {
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    @Override\n");
            sb.append("    public " + this.getItemType() + " get" + capped + "(" + pres + " presenter){\n");
            if (this.isSingleton().booleanValue()) {
                sb.append("        if (" + this.getItemName() + " == null)\n");
                sb.append("            " + this.getItemName() + " = " + this.getConstruction() + ";\n");
                sb.append("        return(" + this.getItemName() + ");\n");
            } else {
                sb.append("        " + this.getItemType() + " view = " + this.getConstruction() + ";\n");
                sb.append("        return(view);\n");
            }
            sb.append("    }\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    public void addInterfaceImports(ImportManager im) {
        if (this.view != null) {
            im.addImport(this.view.getViewImport(), "The " + this.view.getViewName());
            if (this.view.isCodeSplit().booleanValue()) {
                im.addImport(this.view.getAsyncImport(), "Asynchronous creation of " + this.view.getViewName());
            } else {
                im.addImport(this.getUseClass(), "Used by " + this.getItemName());
            }
        }
        if (this.presenter != null) {
            if (this.presenter.isCodeSplit().booleanValue()) {
                im.addImport(this.presenter.getAsyncImport(), "Asynchronous creation of " + this.presenter.getPresenterName());
            } else {
                im.addImport(this.getUseClass(), "Used by " + this.getItemName());
            }
        }
        if (this.view == null && this.presenter == null) {
            im.addImport(this.getUseClass(), "Used by " + this.getItemName());
        }
    }

    public String getRunContextInterfaceName() {
        String mod = GenUtility.capTheName(this.getDefinedInModule().getModuleName().getNameString());
        return mod + "RunContextIF";
    }

    public void addUsageImplImports(ImportManager im) {
        this.addUsageImplImports(im, false);
    }

    public void addUsageImplImports(ImportManager im, boolean formattingRunContextIF) {
        String mod = GenUtility.capTheName(this.getDefinedInModule().getModuleName().getNameString());
        String prefix = this.getDefinedInModule().getGenPackage() + ".generated.mvw.";
        im.addImport(prefix + mod + "RunContextIF", mod + " run context");
        if (this.view != null) {
            if (this.view.isCodeSplit().booleanValue()) {
                if (formattingRunContextIF) {
                    im.addImport(this.view.getViewImport(), "The " + this.view.getViewName());
                }
                im.addImport(this.view.getAsyncImport(), "Asynchronous creation of  " + this.view.getViewName());
            } else {
                im.addImport(this.view.getViewImport(), "The " + this.view.getViewName());
                im.addImport(this.getUseClass(), "Used by " + this.getItemName());
            }
        }
        if (this.presenter != null) {
            if (this.presenter.isCodeSplit().booleanValue()) {
                im.addImport(this.presenter.getAsyncImport(), "Asynchronous creation of " + this.presenter.getPresenterName());
                im.addImport(this.getUseClass(), "Used by " + this.getItemName());
            } else {
                im.addImport(this.getUseClass(), "Used by " + this.getItemName());
            }
        }
        if (this.view == null && this.presenter == null) {
            im.addImport(this.getUseClass(), "Used by " + this.getItemName());
        }
    }

    public void addRunContextImplImports(ImportManager im) {
        im.addImport(this.getUseClass(), "Used by " + this.getItemName());
        if (this.getImportThisHasValue()) {
            for (String imp : this.getImportThisIterable()) {
                im.addImport(imp, "Used by " + this.getItemName());
            }
        }
        if (this.view != null) {
            im.addImport(this.view.getViewImport(), "The " + this.view.getViewName());
            if (this.view.isCodeSplit().booleanValue()) {
                im.addImport(this.view.getAsyncImport(), "Needed to create " + this.view.getViewName() + " instances asynchronously");
                im.addImport("com.google.gwt.core.client.GWT", "Access to runAsynch()");
                im.addImport("com.google.gwt.core.client.RunAsyncCallback", "Handling runAsync() results");
            }
        }
        if (this.presenter != null && this.presenter.isCodeSplit().booleanValue()) {
            im.addImport(this.presenter.getAsyncImport(), "Needed to create " + this.presenter.getPresenterName() + " instances asynchronously");
            im.addImport("com.google.gwt.core.client.GWT", "Access to runAsynch()");
            im.addImport("com.google.gwt.core.client.RunAsyncCallback", "Handling runAsync() results");
        }
    }

    public boolean refersToAsyncCode() {
        if (this.presenter != null && this.presenter.isCodeSplit().booleanValue()) {
            return true;
        }
        return this.view != null && this.view.isCodeSplit() != false;
    }

    public String getAsyncInterface() {
        if (this.presenter != null && this.presenter.isCodeSplit().booleanValue()) {
            return this.presenter.getAsyncInterface();
        }
        if (this.view != null && this.view.isCodeSplit().booleanValue()) {
            return this.view.getAsyncInterface();
        }
        return null;
    }
}

