/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.extended;

import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.ClassDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.CodeGenComponentIF;
import org.dmd.mvw.tools.mvwgenerator.extended.Event;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.mvw.tools.mvwgenerator.generated.dmo.ViewDMO;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.ViewDMW;
import org.dmd.mvw.tools.mvwgenerator.generated.enums.SelectionTypeEnum;
import org.dmd.mvw.tools.mvwgenerator.generated.types.DisplayDataSpec;
import org.dmd.mvw.tools.mvwgenerator.types.MethodWithArgs;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.ResultException;

public class View
extends ViewDMW
implements CodeGenComponentIF {
    boolean initialized;
    TreeMap<String, DisplayDataSpec> displayData;
    ImportManager viewImports;
    StringBuffer presenterInterface;
    StringBuffer viewInterface;
    ImportManager presenterImplImports;
    ImportManager viewImplImports;
    StringBuffer viewImplMethods;
    RunContextItem runContextItem;

    public View() {
        this.initialized = false;
    }

    @Override
    public void resetCodeGenInfo() {
        this.initialized = false;
        this.displayData = null;
        this.viewImports = null;
        this.presenterInterface = null;
        this.viewInterface = null;
        this.presenterImplImports = null;
        this.viewImplImports = null;
        this.viewImplMethods = null;
    }

    protected View(ViewDMO obj, ClassDefinition cd) {
        super(obj, cd);
    }

    public void setRunContextItem(RunContextItem i) {
        this.runContextItem = i;
    }

    public RunContextItem getRunContextItem() {
        return this.runContextItem;
    }

    public boolean requiresEventBus() {
        if (this.getBroadcastHasValue()) {
            return true;
        }
        return this.getBroadcastOnlyHasValue();
    }

    public String getPresenterImport() {
        return this.getDefinedInModule().getGenPackage() + ".generated.mvw.views." + this.getViewName() + "IF." + this.getViewName() + "PresenterIF";
    }

    public String getViewImport() {
        return this.getDefinedInModule().getGenPackage() + ".generated.mvw.views." + this.getViewName() + "IF";
    }

    public String getBaseImplImport() {
        return this.getDefinedInModule().getGenPackage() + ".generated.mvw.views." + this.getViewName() + "BaseImpl";
    }

    public ImportManager getPresenterImplImports() {
        return this.presenterImplImports;
    }

    public String getExtendedClassImport() {
        if (this.getSubpackage() == null) {
            return this.getDefinedInModule().getGenPackage() + ".extended." + this.getViewName();
        }
        return this.getDefinedInModule().getGenPackage() + ".extended." + this.getSubpackage() + "." + this.getViewName();
    }

    public String getExtendedClassPackage() {
        if (this.getSubpackage() == null) {
            return this.getDefinedInModule().getGenPackage() + ".extended";
        }
        return this.getDefinedInModule().getGenPackage() + ".extended." + this.getSubpackage();
    }

    public void initCodeGenInfo() throws ResultException, DmcValueException {
        if (!this.initialized) {
            MethodWithArgs method;
            Event event;
            Iterator iterator;
            this.initialized = true;
            this.displayData = new TreeMap();
            this.viewImports = new ImportManager();
            this.presenterInterface = new StringBuffer();
            this.viewInterface = new StringBuffer();
            this.presenterImplImports = new ImportManager();
            this.presenterImplImports.addImport(this.getPresenterImport(), "Presenter interface");
            if (!this.isCodeSplit().booleanValue()) {
                this.presenterImplImports.addImport(this.getViewImport(), "View interface");
            }
            this.viewImplImports = new ImportManager();
            this.viewImplMethods = new StringBuffer();
            if (this.isCodeSplit().booleanValue()) {
                MethodWithArgs method2 = new MethodWithArgs("void async" + this.getViewName() + "Ready(" + this.getViewName() + " v) Called when the asynchronously created view is ready");
                this.addPresenterMethod(method2);
                this.addPresenterImport(this.getExtendedClassImport());
            }
            if (this.getUsesRunContextItemHasValue()) {
                this.viewImplImports.addImport("org.dmd.mvw.client.mvw.generated.mvw.MvwRunContextIF", "Using run context items");
                iterator = this.getUsesRunContextItemIterable().iterator();
                while (iterator.hasNext()) {
                    RunContextItem rci = (RunContextItem)((Object)iterator.next());
                    rci.addUsageImplImports(this.viewImplImports);
                }
            }
            if (this.getLocalHasValue()) {
                iterator = this.getLocalIterable().iterator();
                while (iterator.hasNext()) {
                    event = (Event)iterator.next();
                    event.firedLocally(this);
                    this.viewImplMethods.append(event.getViewLocalMethod());
                    this.presenterInterface.append("        public void on" + event.getEventName() + event.getArgVector() + ";\n\n");
                    for (String imp : event.getImportThisIterable()) {
                        this.viewImports.addImport(imp, "Required by " + event.getEventName());
                        this.viewImplImports.addImport(imp, "Required by " + event.getEventName());
                    }
                }
            }
            if (this.isWidget().booleanValue()) {
                this.viewImplImports.addImport("com.google.gwt.user.client.ui.IsWidget", "Implements IsWidget");
            }
            if (this.getBroadcastHasValue()) {
                iterator = this.getBroadcastIterable().iterator();
                while (iterator.hasNext()) {
                    event = (Event)iterator.next();
                    event.firedBy(this);
                    this.viewImplMethods.append(event.getViewBroadcastMethod());
                    event.addImport(this.viewImplImports);
                    this.presenterInterface.append("        public void on" + event.getEventName() + event.getArgVector() + ";\n\n");
                    for (String imp : event.getImportThisIterable()) {
                        this.viewImports.addImport(imp, "Required by " + event.getEventName());
                        event.addImport(this.viewImplImports);
                    }
                }
            }
            if (this.getBroadcastOnlyHasValue()) {
                iterator = this.getBroadcastOnlyIterable().iterator();
                while (iterator.hasNext()) {
                    event = (Event)iterator.next();
                    event.firedBy(this);
                    this.viewImplMethods.append(event.getViewBroadcastOnlyMethod());
                    event.addImport(this.viewImplImports);
                }
            }
            if (this.getViewImportHasValue()) {
                for (String imp : this.getViewImportIterable()) {
                    this.viewImports.addImport(imp, "View import");
                }
            }
            if (this.getPresenterMethodHasValue()) {
                iterator = this.getPresenterMethodIterable().iterator();
                while (iterator.hasNext()) {
                    method = (MethodWithArgs)iterator.next();
                    if (method.getComment().length() > 0) {
                        this.presenterInterface.append("        /** \n");
                        this.presenterInterface.append("         * " + method.getComment() + "\n");
                        this.presenterInterface.append("         */ \n");
                    }
                    this.presenterInterface.append("        " + method.getSignature() + ";\n\n");
                }
            }
            if (this.getPresenterImportHasValue()) {
                for (String imp : this.getPresenterImportIterable()) {
                    this.viewImports.addImport(imp, "View import");
                }
            }
            if (this.getSharedImportHasValue()) {
                for (String imp : this.getSharedImportIterable()) {
                    this.viewImports.addImport(imp, "Shared import");
                    this.viewImplImports.addImport(imp, "Shared import");
                }
            }
            if (this.getViewMethodHasValue()) {
                iterator = this.getViewMethodIterable().iterator();
                while (iterator.hasNext()) {
                    method = (MethodWithArgs)iterator.next();
                    if (method.getComment().length() > 0) {
                        this.viewInterface.append("    /** \n");
                        this.viewInterface.append("     * " + method.getComment() + "\n");
                        this.viewInterface.append("     */ \n");
                    }
                    this.viewInterface.append("    public " + method.getSignature() + ";\n\n");
                }
            }
        }
    }

    DisplayDataSpec checkVarName(String varname, String attribute) throws ResultException {
        DisplayDataSpec spec = this.displayData.get(varname);
        if (spec == null) {
            ResultException ex = new ResultException();
            ex.addError("Unknown varname for " + attribute + ": " + varname);
            ex.result.lastResult().lineNumber(this.getLineNumber().intValue());
            ex.result.lastResult().fileName(this.getFile());
            throw ex;
        }
        return spec;
    }

    void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized for code generation");
        }
    }

    public String getInterfaceImports() {
        this.checkInitialized();
        return this.viewImports.getFormattedImports();
    }

    public String getViewImplImports() {
        this.checkInitialized();
        return this.viewImplImports.getFormattedImports();
    }

    public String getViewImplMethods() {
        this.checkInitialized();
        return this.viewImplMethods.toString();
    }

    public String getPresenterMethods() {
        this.checkInitialized();
        return this.presenterInterface.toString();
    }

    public String getViewMethods() {
        this.checkInitialized();
        return this.viewInterface.toString();
    }

    public String getDataMethods() {
        this.checkInitialized();
        StringBuffer sb = new StringBuffer();
        for (DisplayDataSpec spec : this.displayData.values()) {
            String capped = GenUtility.capTheName(spec.getVarName());
            if (spec.getCardinality() == SelectionTypeEnum.SINGLE) {
                sb.append("    public void set" + capped + "(" + spec.getDataClass().getObjectName() + "DMO " + spec.getVarName() + ");\n\n");
                sb.append("    public " + spec.getDataClass().getObjectName() + "DMO get" + capped + "();\n\n");
                continue;
            }
            sb.append("    public void set" + capped + "(List<" + spec.getDataClass().getObjectName() + "DMO> " + spec.getVarName() + ");\n\n");
            sb.append("    public List<" + spec.getDataClass().getObjectName() + "DMO> get" + capped + "();\n\n");
        }
        return sb.toString();
    }

    public String getAsyncImport() {
        return this.getDefinedInModule().getGenPackage() + ".generated.mvw.views." + this.getViewName() + "AsyncIF";
    }

    public String getAsyncInterface() {
        return this.getViewName() + "AsyncIF";
    }
}

