/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.extended.menus;

import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.MenuBar;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.MenuItem;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.Separator;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.SubMenu;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.MenuElementDefinitionDMW;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.MenuImplementationConfigDMW;
import org.dmd.mvw.tools.mvwgenerator.generated.types.MenuElementTypeAndComment;
import org.dmd.util.exceptions.ResultException;

public class MenuImplementationConfig
extends MenuImplementationConfigDMW {
    boolean initialized = false;
    TreeMap<String, MenuElementTypeAndComment> menubarTypes;
    TreeMap<String, MenuElementTypeAndComment> submenuTypes;
    TreeMap<String, MenuElementTypeAndComment> menuItemTypes;
    TreeMap<String, MenuElementTypeAndComment> separatorTypes;

    void initialize() {
        if (!this.initialized) {
            MenuElementTypeAndComment mtac;
            Iterator iterator;
            this.initialized = true;
            this.menubarTypes = new TreeMap();
            this.submenuTypes = new TreeMap();
            this.menuItemTypes = new TreeMap();
            this.separatorTypes = new TreeMap();
            this.menubarTypes.put(this.getDefaultMenuBar().getType(), this.getDefaultMenuBar());
            if (this.getAlternateMenuBarHasValue()) {
                iterator = this.getAlternateMenuBarIterable().iterator();
                while (iterator.hasNext()) {
                    mtac = (MenuElementTypeAndComment)iterator.next();
                    this.menubarTypes.put(mtac.getType(), mtac);
                }
            }
            this.submenuTypes.put(this.getDefaultSubMenu().getType(), this.getDefaultSubMenu());
            if (this.getAlternateSubMenuHasValue()) {
                iterator = this.getAlternateSubMenuIterable().iterator();
                while (iterator.hasNext()) {
                    mtac = (MenuElementTypeAndComment)iterator.next();
                    this.submenuTypes.put(mtac.getType(), mtac);
                }
            }
            this.menuItemTypes.put(this.getDefaultMenuItem().getType(), this.getDefaultMenuItem());
            if (this.getAlternateMenuItemHasValue()) {
                iterator = this.getAlternateMenuItemIterable().iterator();
                while (iterator.hasNext()) {
                    mtac = (MenuElementTypeAndComment)iterator.next();
                    this.menuItemTypes.put(mtac.getType(), mtac);
                }
            }
            this.separatorTypes.put(this.getDefaultSeparator().getType(), this.getDefaultSeparator());
        }
    }

    public void validateImplementations(TreeMap<CamelCaseName, MenuElementDefinitionDMW> menuElements) throws ResultException {
        this.initialize();
        ResultException errors = null;
        for (MenuElementDefinitionDMW def : menuElements.values()) {
            if (def instanceof MenuBar) {
                if (def.getUseImpl() == null) {
                    def.setUseImpl(this.getDefaultMenuBar().getType());
                    continue;
                }
                if (this.menubarTypes.get(def.getUseImpl()) != null) continue;
                if (errors == null) {
                    errors = new ResultException();
                }
                errors.addError("Invalid implementation (useImpl) for MenuBar: " + def.getUseImpl());
                errors.result.lastResult().fileName(def.getFile());
                errors.result.lastResult().lineNumber(def.getLineNumber().intValue());
                continue;
            }
            if (def instanceof MenuItem) {
                if (def.getUseImpl() == null) {
                    def.setUseImpl(this.getDefaultMenuItem().getType());
                    continue;
                }
                if (this.menuItemTypes.get(def.getUseImpl()) != null) continue;
                if (errors == null) {
                    errors = new ResultException();
                }
                errors.addError("Invalid implementation (useImpl) for MenuItem: " + def.getUseImpl());
                errors.result.lastResult().fileName(def.getFile());
                errors.result.lastResult().lineNumber(def.getLineNumber().intValue());
                continue;
            }
            if (def instanceof SubMenu) {
                if (def.getUseImpl() == null) {
                    def.setUseImpl(this.getDefaultSubMenu().getType());
                    continue;
                }
                if (this.submenuTypes.get(def.getUseImpl()) != null) continue;
                if (errors == null) {
                    errors = new ResultException();
                }
                errors.addError("Invalid implementation (useImpl) for SubMenu: " + def.getUseImpl());
                errors.result.lastResult().fileName(def.getFile());
                errors.result.lastResult().lineNumber(def.getLineNumber().intValue());
                continue;
            }
            if (!(def instanceof Separator)) continue;
            if (def.getUseImpl() == null) {
                def.setUseImpl(this.getDefaultSeparator().getType());
                continue;
            }
            if (this.separatorTypes.get(def.getUseImpl()) != null) continue;
            if (errors == null) {
                errors = new ResultException();
            }
            errors.addError("Invalid implementation (useImpl) for Separator: " + def.getUseImpl());
            errors.result.lastResult().fileName(def.getFile());
            errors.result.lastResult().lineNumber(def.getLineNumber().intValue());
        }
        if (errors != null) {
            throw errors;
        }
    }
}

