/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.generated.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.dmd.dmc.DmcEnumIF;

public enum RequestOptionEnum implements DmcEnumIF
{
    NONE(0, "Indicates that no options are specified."),
    DMPERRORS(1, "Indicates that DMP error responses will be handled locally."),
    RPCERRORS(2, "Indicates that RPC errors will be handled locally."),
    CENTRALDMPERRORS(3, "Indicates that you want DMP errors centrally handled."),
    CENTRALRPCERRORS(4, "Indicates that you want RPC errors centrally handled."),
    CENTRALERRORS(5, "Indicates that you want DMP/RPC errors centrally handled."),
    CACHE(6, "Indicates that you want the results centrally cached."),
    EVENTS(7, "Indicates that you want notification of events associated with the get request.");

    private static final Map<Integer, RequestOptionEnum> lookup;
    private static final Map<String, RequestOptionEnum> lookupString;
    private int ival;
    private String dval;

    private RequestOptionEnum(int i, String d) {
        this.ival = i;
        this.dval = d;
    }

    public int intValue() {
        return this.ival;
    }

    public String displayValue() {
        return this.dval;
    }

    public static RequestOptionEnum get(int code) {
        return lookup.get(code);
    }

    public static RequestOptionEnum get(String str) {
        return lookupString.get(str.toUpperCase());
    }

    static {
        lookup = new HashMap<Integer, RequestOptionEnum>();
        for (RequestOptionEnum s : EnumSet.allOf(RequestOptionEnum.class)) {
            lookup.put(s.intValue(), s);
        }
        lookupString = new HashMap<String, RequestOptionEnum>();
        for (RequestOptionEnum s : EnumSet.allOf(RequestOptionEnum.class)) {
            lookupString.put(s.name(), s);
        }
    }
}

