/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.mvw.tools.mvwgenerator.generated.types.ComponentREF;
import org.dmd.mvw.tools.mvwgenerator.generated.types.DmcTypeComponentREF;

public class DmcTypeComponentREFMAP
extends DmcTypeComponentREF
implements Serializable {
    private static final Iterator<ComponentREF> emptyList = new HashMap().values().iterator();
    protected Map<CamelCaseName, ComponentREF> value;

    public DmcTypeComponentREFMAP() {
        this.value = null;
    }

    public DmcTypeComponentREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<CamelCaseName, ComponentREF>() : new TreeMap<CamelCaseName, ComponentREF>();
    }

    public CamelCaseName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (CamelCaseName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeComponentREFMAP getNew() {
        return new DmcTypeComponentREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<ComponentREF> cloneIt() {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            DmcTypeComponentREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ComponentREF val : this.value.values()) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentREF add(Object v) throws DmcValueException {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            CamelCaseName key;
            ComponentREF oldval;
            ComponentREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (CamelCaseName)newval.getKey(), newval)) != null && oldval.valuesAreEqual((DmcMappedAttributeIF)newval)) {
                newval = null;
            }
            return newval;
        }
    }

    public ComponentREF del(Object key) {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof CamelCaseName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ComponentREF> getMV() {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<CamelCaseName, ComponentREF>(this.value) : new TreeMap<CamelCaseName, ComponentREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CamelCaseName, ComponentREF> getMVCopy() {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<CamelCaseName, ComponentREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<CamelCaseName, ComponentREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    public ComponentREF getByKey(Object key) {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof CamelCaseName) {
                return this.value.get((CamelCaseName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                ComponentREF val = this.typeCheck(v);
                return this.value.containsValue((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        DmcTypeComponentREFMAP dmcTypeComponentREFMAP = this;
        synchronized (dmcTypeComponentREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof CamelCaseName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

