/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.mvw.tools.mvwgenerator.generated.types.ComponentREF;
import org.dmd.mvw.tools.mvwgenerator.generated.types.DmcTypeComponentREF;

public class DmcTypeComponentREFSET
extends DmcTypeComponentREF
implements Serializable {
    private static final Iterator<ComponentREF> emptyList = new HashSet().iterator();
    protected Set<ComponentREF> value;

    public DmcTypeComponentREFSET() {
        this.value = null;
    }

    public DmcTypeComponentREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ComponentREF>() : new TreeSet<ComponentREF>();
    }

    public DmcTypeComponentREFSET getNew() {
        return new DmcTypeComponentREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<ComponentREF> cloneIt() {
        DmcTypeComponentREFSET dmcTypeComponentREFSET = this;
        synchronized (dmcTypeComponentREFSET) {
            DmcTypeComponentREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ComponentREF val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentREF add(Object v) throws DmcValueException {
        DmcTypeComponentREFSET dmcTypeComponentREFSET = this;
        synchronized (dmcTypeComponentREFSET) {
            ComponentREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentREF del(Object v) {
        DmcTypeComponentREFSET dmcTypeComponentREFSET = this;
        synchronized (dmcTypeComponentREFSET) {
            ComponentREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ComponentREF> getMV() {
        DmcTypeComponentREFSET dmcTypeComponentREFSET = this;
        synchronized (dmcTypeComponentREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ComponentREF>(this.value).iterator();
            }
            return new TreeSet<ComponentREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ComponentREF> getMVCopy() {
        DmcTypeComponentREFSET dmcTypeComponentREFSET = this;
        synchronized (dmcTypeComponentREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ComponentREF>();
                }
                return new HashSet<ComponentREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ComponentREF>(this.value);
            }
            return new TreeSet<ComponentREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeComponentREFSET dmcTypeComponentREFSET = this;
        synchronized (dmcTypeComponentREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeComponentREFSET dmcTypeComponentREFSET = this;
        synchronized (dmcTypeComponentREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ComponentREF val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

