/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.mvw.tools.mvwgenerator.generated.types.DisplayDataSpec;
import org.dmd.mvw.tools.mvwgenerator.generated.types.DmcTypeDisplayDataSpec;

public class DmcTypeDisplayDataSpecSET
extends DmcTypeDisplayDataSpec
implements Serializable {
    private static final Iterator<DisplayDataSpec> emptyList = new HashSet().iterator();
    protected Set<DisplayDataSpec> value;

    public DmcTypeDisplayDataSpecSET() {
        this.value = null;
    }

    public DmcTypeDisplayDataSpecSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<DisplayDataSpec>() : new TreeSet<DisplayDataSpec>();
    }

    public DmcTypeDisplayDataSpecSET getNew() {
        return new DmcTypeDisplayDataSpecSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<DisplayDataSpec> cloneIt() {
        DmcTypeDisplayDataSpecSET dmcTypeDisplayDataSpecSET = this;
        synchronized (dmcTypeDisplayDataSpecSET) {
            DmcTypeDisplayDataSpecSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (DisplayDataSpec val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayDataSpec add(Object v) throws DmcValueException {
        DmcTypeDisplayDataSpecSET dmcTypeDisplayDataSpecSET = this;
        synchronized (dmcTypeDisplayDataSpecSET) {
            DisplayDataSpec rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayDataSpec del(Object v) {
        DmcTypeDisplayDataSpecSET dmcTypeDisplayDataSpecSET = this;
        synchronized (dmcTypeDisplayDataSpecSET) {
            DisplayDataSpec rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<DisplayDataSpec> getMV() {
        DmcTypeDisplayDataSpecSET dmcTypeDisplayDataSpecSET = this;
        synchronized (dmcTypeDisplayDataSpecSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<DisplayDataSpec>(this.value).iterator();
            }
            return new TreeSet<DisplayDataSpec>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DisplayDataSpec> getMVCopy() {
        DmcTypeDisplayDataSpecSET dmcTypeDisplayDataSpecSET = this;
        synchronized (dmcTypeDisplayDataSpecSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<DisplayDataSpec>();
                }
                return new HashSet<DisplayDataSpec>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<DisplayDataSpec>(this.value);
            }
            return new TreeSet<DisplayDataSpec>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeDisplayDataSpecSET dmcTypeDisplayDataSpecSET = this;
        synchronized (dmcTypeDisplayDataSpecSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeDisplayDataSpecSET dmcTypeDisplayDataSpecSET = this;
        synchronized (dmcTypeDisplayDataSpecSET) {
            if (this.value == null) {
                return false;
            }
            try {
                DisplayDataSpec val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

