/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.mvw.tools.mvwgenerator.generated.types.DmcTypeOperationSpec;
import org.dmd.mvw.tools.mvwgenerator.generated.types.OperationSpec;

public class DmcTypeOperationSpecSET
extends DmcTypeOperationSpec
implements Serializable {
    private static final Iterator<OperationSpec> emptyList = new HashSet().iterator();
    protected Set<OperationSpec> value;

    public DmcTypeOperationSpecSET() {
        this.value = null;
    }

    public DmcTypeOperationSpecSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<OperationSpec>() : new TreeSet<OperationSpec>();
    }

    public DmcTypeOperationSpecSET getNew() {
        return new DmcTypeOperationSpecSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<OperationSpec> cloneIt() {
        DmcTypeOperationSpecSET dmcTypeOperationSpecSET = this;
        synchronized (dmcTypeOperationSpecSET) {
            DmcTypeOperationSpecSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (OperationSpec val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationSpec add(Object v) throws DmcValueException {
        DmcTypeOperationSpecSET dmcTypeOperationSpecSET = this;
        synchronized (dmcTypeOperationSpecSET) {
            OperationSpec rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationSpec del(Object v) {
        DmcTypeOperationSpecSET dmcTypeOperationSpecSET = this;
        synchronized (dmcTypeOperationSpecSET) {
            OperationSpec rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<OperationSpec> getMV() {
        DmcTypeOperationSpecSET dmcTypeOperationSpecSET = this;
        synchronized (dmcTypeOperationSpecSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<OperationSpec>(this.value).iterator();
            }
            return new TreeSet<OperationSpec>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OperationSpec> getMVCopy() {
        DmcTypeOperationSpecSET dmcTypeOperationSpecSET = this;
        synchronized (dmcTypeOperationSpecSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<OperationSpec>();
                }
                return new HashSet<OperationSpec>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<OperationSpec>(this.value);
            }
            return new TreeSet<OperationSpec>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeOperationSpecSET dmcTypeOperationSpecSET = this;
        synchronized (dmcTypeOperationSpecSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeOperationSpecSET dmcTypeOperationSpecSET = this;
        synchronized (dmcTypeOperationSpecSET) {
            if (this.value == null) {
                return false;
            }
            try {
                OperationSpec val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

