/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.mvw.tools.mvwgenerator.generated.types.DmcTypeViewREF;
import org.dmd.mvw.tools.mvwgenerator.generated.types.ViewREF;

public class DmcTypeViewREFSET
extends DmcTypeViewREF
implements Serializable {
    private static final Iterator<ViewREF> emptyList = new HashSet().iterator();
    protected Set<ViewREF> value;

    public DmcTypeViewREFSET() {
        this.value = null;
    }

    public DmcTypeViewREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<ViewREF>() : new TreeSet<ViewREF>();
    }

    public DmcTypeViewREFSET getNew() {
        return new DmcTypeViewREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DmcAttribute<ViewREF> cloneIt() {
        DmcTypeViewREFSET dmcTypeViewREFSET = this;
        synchronized (dmcTypeViewREFSET) {
            DmcTypeViewREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ViewREF val : this.value) {
                try {
                    rc.add((Object)val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewREF add(Object v) throws DmcValueException {
        DmcTypeViewREFSET dmcTypeViewREFSET = this;
        synchronized (dmcTypeViewREFSET) {
            ViewREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewREF del(Object v) {
        DmcTypeViewREFSET dmcTypeViewREFSET = this;
        synchronized (dmcTypeViewREFSET) {
            ViewREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains((Object)rc)) {
                this.value.remove((Object)rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<ViewREF> getMV() {
        DmcTypeViewREFSET dmcTypeViewREFSET = this;
        synchronized (dmcTypeViewREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<ViewREF>(this.value).iterator();
            }
            return new TreeSet<ViewREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ViewREF> getMVCopy() {
        DmcTypeViewREFSET dmcTypeViewREFSET = this;
        synchronized (dmcTypeViewREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<ViewREF>();
                }
                return new HashSet<ViewREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<ViewREF>(this.value);
            }
            return new TreeSet<ViewREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMVSize() {
        DmcTypeViewREFSET dmcTypeViewREFSET = this;
        synchronized (dmcTypeViewREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object v) {
        DmcTypeViewREFSET dmcTypeViewREFSET = this;
        synchronized (dmcTypeViewREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                ViewREF val = this.typeCheck(v);
                return this.value.contains((Object)val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

