/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.types;

import java.io.Serializable;
import java.util.ArrayList;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.CheapSplitter;
import org.dmd.dms.AttributeDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.FieldEditorDefinition;

public class EditField
implements DmcMappedAttributeIF,
Serializable {
    AttributeDefinition attrDef;
    FieldEditorDefinition editorDef;
    String attribute;
    String fieldEditor;
    boolean readOnly;
    boolean must;
    String label;
    String tip;

    public EditField() {
        this.attribute = null;
        this.fieldEditor = null;
        this.readOnly = false;
        this.must = false;
        this.label = null;
        this.tip = null;
    }

    public EditField(String an, String ft, boolean ro, boolean m, String l, String t) {
        this.attribute = an;
        this.fieldEditor = ft;
        this.readOnly = ro;
        this.must = m;
        this.label = l;
        this.tip = t;
    }

    public EditField(EditField ef) {
        this.attribute = ef.attribute;
        this.fieldEditor = ef.fieldEditor;
        this.readOnly = ef.readOnly;
        this.must = ef.must;
        this.label = ef.label;
        this.tip = ef.tip;
    }

    public EditField(String v) throws DmcValueException {
        String value = v.replaceAll("\t", " ").trim();
        int spacepos = value.indexOf(" ");
        if (spacepos == -1) {
            throw new DmcValueException("Missing field editor: " + v + " - should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
        }
        int colonpos = value.indexOf(":");
        if (colonpos == -1) {
            this.parseFirstPart(value);
        } else {
            String firstPart = value.substring(0, colonpos);
            this.parseFirstPart(firstPart);
            String secondPart = value.substring(colonpos);
            this.parseSecondPart(secondPart.trim());
        }
    }

    void parseFirstPart(String value) throws DmcValueException {
        boolean wantAttr = true;
        boolean wantEditor = true;
        boolean haveOption = false;
        String[] vals = value.split(" ");
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].length() == 0) continue;
            if (wantAttr) {
                this.attribute = vals[i];
                wantAttr = false;
                continue;
            }
            if (wantEditor) {
                this.fieldEditor = vals[i];
                wantEditor = false;
                continue;
            }
            if (!haveOption) {
                if (vals[i].equals("RO")) {
                    this.readOnly = true;
                    haveOption = true;
                    continue;
                }
                if (vals[i].equals("MUST")) {
                    this.must = true;
                    haveOption = true;
                    continue;
                }
                throw new DmcValueException("Unknown field option: " + vals[i] + " - should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
            }
            throw new DmcValueException("Extraneous option: " + vals[i] + " - should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
        }
    }

    void parseSecondPart(String value) throws DmcValueException {
        ArrayList tokens = CheapSplitter.split((String)value, (char)':', (boolean)true, (boolean)true);
        boolean wantLabel = false;
        boolean wantTip = false;
        int colonCount = 0;
        if (tokens.size() == 1) {
            throw new DmcValueException("Missing label - value should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
        }
        for (int i = 0; i < tokens.size(); ++i) {
            if (((String)tokens.get(i)).equals(":")) {
                if (++colonCount == 1) {
                    wantLabel = true;
                    continue;
                }
                if (colonCount == 2) {
                    wantTip = true;
                    continue;
                }
                if (colonCount <= 2) continue;
                throw new DmcValueException("Extraneous colons - value should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
            }
            if (wantLabel) {
                this.label = (String)tokens.get(i);
                if (this.label.length() == 0) {
                    throw new DmcValueException("Missing label - should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
                }
                wantLabel = false;
                continue;
            }
            if (wantTip) {
                this.tip = (String)tokens.get(i);
                if (this.tip.length() == 0) {
                    throw new DmcValueException("Missing tool tip - should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
                }
                wantTip = false;
                continue;
            }
            String garbage = (String)tokens.get(i);
            throw new DmcValueException("Extraneous tokens/space: *" + garbage + "* [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
        }
        if (wantLabel) {
            throw new DmcValueException("Missing label - should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
        }
        if (wantTip) {
            throw new DmcValueException("Missing tool tip - should be of the form: [attribute name] [field editor] <RO|MUST> <: label> <: tip>");
        }
    }

    public void setAttrDef(AttributeDefinition ad) {
        this.attrDef = ad;
    }

    public AttributeDefinition getAttrDef() {
        return this.attrDef;
    }

    public void setEditorDef(FieldEditorDefinition fed) {
        this.editorDef = fed;
    }

    public FieldEditorDefinition getEditorDef() {
        return this.editorDef;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getFieldEditor() {
        return this.fieldEditor;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTip() {
        return this.tip;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isMandatory() {
        return this.must;
    }

    public String toString() {
        String option = "";
        if (this.readOnly) {
            option = " RO";
        }
        if (this.must) {
            option = " MUST";
        }
        if (this.label == null) {
            return this.attribute + " " + this.fieldEditor + option;
        }
        if (this.tip == null) {
            return this.attribute + " " + this.fieldEditor + option + " : " + this.label;
        }
        return this.attribute + " " + this.fieldEditor + option + " : " + this.label + " : " + this.tip;
    }

    public Object getKey() {
        return this.attribute;
    }

    public String getKeyAsString() {
        return this.attribute;
    }

    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof EditField) {
            EditField other = (EditField)obj;
            if (this.readOnly != other.readOnly) {
                return false;
            }
            if (this.must != other.must) {
                return false;
            }
            if (this.attribute.equals(other.attribute) && this.fieldEditor.equals(other.fieldEditor)) {
                if (this.label == null) {
                    if (other.label == null) {
                        rc = true;
                    }
                } else if (other.label != null && this.label.equals(other.label)) {
                    if (this.tip == null) {
                        if (other.tip == null) {
                            rc = true;
                        }
                    } else if (other.tip != null && this.tip.equals(other.tip)) {
                        rc = true;
                    }
                }
            }
        }
        return rc;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.attribute);
        dos.writeUTF(this.fieldEditor);
        dos.writeUTF(this.label);
        dos.writeUTF(this.tip);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.attribute = dis.readUTF();
        this.fieldEditor = dis.readUTF();
        this.label = dis.readUTF();
        this.tip = dis.readUTF();
    }
}

