/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.types;

import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeSet;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public class EventWithArgs
implements DmcMappedAttributeIF,
Serializable {
    String eventName;
    String argVector;
    TreeSet<String> imports;

    public EventWithArgs() {
        this.eventName = null;
        this.argVector = null;
        this.imports = null;
    }

    public EventWithArgs(String en, String av, TreeSet<String> i) {
        this.eventName = en;
        this.argVector = av;
        this.imports = i;
    }

    public EventWithArgs(EventWithArgs ewa) {
        this.eventName = ewa.eventName;
        this.argVector = ewa.argVector;
        this.imports = ewa.imports;
    }

    public EventWithArgs(String v) throws DmcValueException {
        String value = v.trim();
        int spacepos = value.indexOf(" ");
        if (spacepos == -1) {
            this.eventName = value;
            this.argVector = "()";
            this.imports = new TreeSet();
        } else {
            this.eventName = value.substring(0, spacepos);
            int lbpos = value.indexOf("(", spacepos + 1);
            int rbpos = value.indexOf(")", spacepos + 1);
            if (lbpos == -1) {
                throw new DmcValueException("The argument vector must start with a (");
            }
            if (rbpos == -1) {
                throw new DmcValueException("The argument vector must end with a )");
            }
            this.argVector = value.substring(lbpos, rbpos + 1);
            this.imports = new TreeSet();
            if (value.length() > rbpos + 1) {
                String remainder = value.substring(rbpos + 1);
                String[] classes = remainder.split(" ");
                for (int i = 0; i < classes.length; ++i) {
                    if (classes[i].length() <= 0) continue;
                    this.imports.add(classes[i]);
                }
            }
        }
        if (!this.eventName.endsWith("Event")) {
            throw new DmcValueException("The event name must end with `Event`)");
        }
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getArgVector() {
        return this.argVector;
    }

    public TreeSet<String> getImports() {
        return this.imports;
    }

    public String toString() {
        if (this.imports.size() == 0) {
            return this.eventName + " " + this.argVector;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.eventName + " " + this.argVector);
        Iterator<String> it = this.imports.iterator();
        while (it.hasNext()) {
            sb.append(" " + it.next());
        }
        return sb.toString();
    }

    public Object getKey() {
        return this.eventName;
    }

    public String getKeyAsString() {
        return this.eventName;
    }

    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof EventWithArgs) {
            EventWithArgs other = (EventWithArgs)obj;
            if (this.eventName.equals(other.eventName) && this.argVector.equals(other.argVector) && this.imports.equals(other.imports)) {
                rc = true;
            }
        }
        return rc;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.eventName);
        dos.writeUTF(this.argVector);
        if (this.imports.size() == 0) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.imports.size());
            Iterator<String> it = this.imports.iterator();
            while (it.hasNext()) {
                dos.writeUTF(it.next());
            }
        }
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.eventName = dis.readUTF();
        this.argVector = dis.readUTF();
        this.imports = new TreeSet();
        int size = dis.readInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.imports.add(dis.readUTF());
            }
        }
    }
}

